/*
 * Decompiled with CFR 0.152.
 */
package com.sun.webui.jsf.renderkit.widget;

import com.sun.webui.jsf.component.ComplexComponent;
import com.sun.webui.jsf.component.RbCbSelector;
import com.sun.webui.jsf.renderkit.widget.RendererBase;
import com.sun.webui.jsf.util.ConversionUtilities;
import com.sun.webui.jsf.util.JSONUtilities;
import com.sun.webui.jsf.util.WidgetUtilities;
import java.io.IOException;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.convert.ConverterException;
import org.json.JSONException;
import org.json.JSONObject;

abstract class RbCbRendererBase
extends RendererBase {
    private static final String[] stringAttributes = new String[]{"alt", "lang", "dir", "align", "accessKey", "style", "onFocus", "onBlur", "onClick", "onDblClick", "onChange", "onMouseDown", "onMouseUp", "onMouseOver", "onMouseMove", "onMouseOut", "onKeyPress", "onKeyDown", "onKeyUp", "onSelect"};
    private static final String[] intAttributes = new String[]{"tabIndex"};

    RbCbRendererBase() {
    }

    public Object getConvertedValue(FacesContext context, UIComponent component, Object submittedValue) throws ConverterException {
        return ((RbCbSelector)component).getConvertedValue(context, (RbCbSelector)component, submittedValue);
    }

    protected JSONObject getProperties(FacesContext context, UIComponent component) throws IOException, JSONException {
        RbCbSelector rbcbSelector = (RbCbSelector)component;
        String componentId = component instanceof ComplexComponent ? ((ComplexComponent)((Object)component)).getLabeledElementId(context) : component.getClientId(context);
        boolean inGroup = true;
        String name = rbcbSelector.getName();
        if (name == null) {
            name = componentId;
            inGroup = false;
        }
        JSONObject json = new JSONObject();
        json.put("name", name).put("readOnly", rbcbSelector.isReadOnly()).put("disabled", rbcbSelector.isDisabled()).put("title", rbcbSelector.getToolTip()).put("visible", rbcbSelector.isVisible()).put("className", rbcbSelector.getStyleClass());
        Object selectedValue = rbcbSelector.getSelectedValue();
        String value = ConversionUtilities.convertValueToString(component, selectedValue);
        String[] subValue = (String[])rbcbSelector.getSubmittedValue();
        if (subValue == null) {
            Object selected = rbcbSelector.getSelected();
            if (this.isSelected(context, component)) {
                json.put("checked", true);
            }
            ConversionUtilities.setRenderedValue(component, selected);
        } else if (subValue.length != 0 && subValue[0].length() != 0 && value != null && value.equals(subValue[0])) {
            json.put("checked", true);
        }
        boolean booleanControl = selectedValue instanceof Boolean;
        if (inGroup && booleanControl) {
            value = componentId;
        }
        json.put("value", value);
        json.put("image", WidgetUtilities.renderComponent(context, rbcbSelector.getImageComponent()));
        json.put("label", WidgetUtilities.renderComponent(context, rbcbSelector.getLabelComponent()));
        JSONUtilities.addStringProperties(stringAttributes, component, json);
        JSONUtilities.addIntegerProperties(intAttributes, component, json);
        return json;
    }

    protected abstract boolean isSelected(FacesContext var1, UIComponent var2);
}

