/*
 * Decompiled with CFR 0.152.
 */
package com.sun.webui.jsf.util;

import com.sun.webui.jsf.component.ImageComponent;
import com.sun.webui.jsf.component.ListSelector;
import com.sun.webui.jsf.model.Indicator;
import com.sun.webui.jsf.model.Option;
import com.sun.webui.jsf.model.OptionGroup;
import com.sun.webui.jsf.model.Separator;
import com.sun.webui.jsf.util.ConversionUtilities;
import com.sun.webui.jsf.util.FastStringWriter;
import com.sun.webui.jsf.util.RenderingUtilities;
import com.sun.webui.jsf.util.ThemeUtilities;
import com.sun.webui.theme.Theme;
import java.io.IOException;
import java.io.Writer;
import java.util.Iterator;
import javax.faces.component.UIComponent;
import javax.faces.context.ExternalContext;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WidgetUtilities {
    public static JSONArray getIndicators(FacesContext context, Iterator<Indicator> indicators, String ignoreType, Theme theme, UIComponent parent) throws IOException, JSONException {
        if (indicators == null) {
            return null;
        }
        JSONArray jArray = new JSONArray();
        while (indicators.hasNext()) {
            Indicator indicator = indicators.next();
            String type = indicator.getType();
            if (type.equals(ignoreType)) continue;
            JSONObject json = new JSONObject();
            UIComponent img = indicator.getImageComponent(theme);
            if (img == null) {
                img = ThemeUtilities.getIcon(theme, "DOT");
            }
            if (img.getId() == null) {
                img.setId(type);
            }
            if (img.getParent() == null) {
                img.setParent(parent);
            }
            json.put("type", type);
            json.put("image", WidgetUtilities.renderComponent(context, img));
            jArray.put(json);
        }
        return jArray;
    }

    public static JSONArray getOptions(FacesContext context, UIComponent component, Option[] options) throws IOException, JSONException {
        if (options == null) {
            return null;
        }
        String tmp = null;
        boolean separatorCreated = false;
        int imgProps = -1;
        JSONObject optionElement = null;
        JSONArray json = new JSONArray();
        for (int i = 0; i < options.length; ++i) {
            optionElement = new JSONObject();
            json.put(optionElement);
            if (options[i] instanceof Separator) {
                JSONObject separatorObject = WidgetUtilities.getSeparatorProperties(component);
                if (separatorObject == null) continue;
                json.put(separatorObject);
                continue;
            }
            optionElement.put("value", ConversionUtilities.convertValueToString(component, options[i].getValue())).put("label", options[i].getLabel()).put("escape", options[i].isEscape()).put("disabled", options[i].isDisabled());
            tmp = options[i].getTooltip();
            if (tmp != null) {
                optionElement.put("title", tmp);
            }
            JSONObject image = WidgetUtilities.getImageOptionProperties(context, component, options[i]);
            optionElement.put("image", image);
            if (options[i] instanceof OptionGroup) {
                JSONArray groupOptions = WidgetUtilities.getOptions(context, component, ((OptionGroup)options[i]).getOptions());
                optionElement.put("group", true);
                optionElement.put("options", groupOptions);
                if (!(component instanceof ListSelector) || i >= options.length - 1 || !((ListSelector)component).isSeparators()) continue;
                optionElement.put("separator", true);
                JSONObject separatorObject = WidgetUtilities.getSeparatorProperties(component);
                if (separatorObject == null) continue;
                json.put(separatorObject);
                continue;
            }
            optionElement.put("group", false);
            optionElement.put("separator", options[i].getSeparator());
        }
        return json;
    }

    public static String translateURL(FacesContext context, UIComponent component, String url) {
        String name = null;
        StringBuffer sb = new StringBuffer(url);
        RenderingUtilities.Param[] paramList = RenderingUtilities.getParamList(context, component);
        int len = paramList.length;
        if (len > 0) {
            sb.append("?");
        }
        for (int i = 0; i < len; ++i) {
            if (0 != i) {
                sb.append("&");
            }
            if ((name = paramList[i].getName()) == null) continue;
            sb.append(name);
            sb.append("=");
            sb.append(paramList[i].getValue());
        }
        return context.getExternalContext().encodeResourceURL(sb.toString());
    }

    public static JSONObject renderComponent(FacesContext context, UIComponent component) throws IOException, JSONException {
        JSONObject json = null;
        if (component == null || !component.isRendered()) {
            return json;
        }
        ResponseWriter oldWriter = context.getResponseWriter();
        Writer strWriter = WidgetUtilities.initStringWriter(context);
        RenderingUtilities.renderComponent(component, context);
        context.setResponseWriter(oldWriter);
        String s = strWriter.toString();
        try {
            json = new JSONObject(s);
        }
        catch (JSONException e) {
            json = new JSONObject();
            json.put("fragment", s);
        }
        return json;
    }

    private static JSONObject getSeparatorProperties(UIComponent component) throws JSONException {
        if (!(component instanceof ListSelector)) {
            return null;
        }
        ListSelector selector = (ListSelector)component;
        JSONObject json = new JSONObject();
        json.put("separator", true).put("group", false).put("disabled", true);
        int numEms = selector.getSeparatorLength();
        StringBuffer labelBuffer = new StringBuffer();
        for (int em = 0; em < numEms; ++em) {
            labelBuffer.append("-");
        }
        json.put("label", labelBuffer.toString());
        return json;
    }

    private static JSONObject getImageOptionProperties(FacesContext context, UIComponent component, Option option) throws JSONException, IOException {
        Theme theme = ThemeUtilities.getTheme(context);
        if (option.getImage() == null) {
            return null;
        }
        ImageComponent image = new ImageComponent();
        image.setId(component.getId() + option.getValue() + "_image");
        image.setParent(component);
        image.setUrl(option.getImage());
        image.setAlt(option.getImageAlt());
        int imgProps = option.getImageHeight();
        if (imgProps > 0) {
            image.setHeight(imgProps);
        }
        if ((imgProps = option.getImageWidth()) > 0) {
            image.setWidth(imgProps);
        }
        return WidgetUtilities.renderComponent(context, image);
    }

    private static Writer initStringWriter(FacesContext context) {
        if (context == null) {
            return null;
        }
        ResponseWriter oldWriter = context.getResponseWriter();
        FastStringWriter strWriter = new FastStringWriter(1024);
        ResponseWriter newWriter = null;
        if (null != oldWriter) {
            newWriter = oldWriter.cloneWithWriter(strWriter);
        } else {
            ExternalContext extContext = context.getExternalContext();
            newWriter = context.getRenderKit().createResponseWriter(strWriter, null, extContext.getRequestCharacterEncoding());
        }
        context.setResponseWriter(newWriter);
        return strWriter;
    }
}

