/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.core;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import javax.servlet.RequestDispatcher;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletRequestWrapper;
import javax.servlet.http.HttpSession;
import org.apache.catalina.Context;
import org.apache.catalina.Manager;
import org.apache.catalina.Session;
import org.apache.catalina.connector.SessionTracker;
import org.apache.catalina.core.ApplicationRequest;
import org.apache.catalina.session.StandardSession;
import org.apache.catalina.util.Enumerator;
import org.apache.catalina.util.RequestUtil;
import org.apache.catalina.util.StringManager;

public class ApplicationHttpRequest
extends HttpServletRequestWrapper {
    protected static final StringManager sm = StringManager.getManager("org.apache.catalina.core");
    private String requestedSessionVersion = null;
    private boolean isSessionVersioningSupported = false;
    protected Context context = null;
    protected String contextPath = null;
    protected boolean crossContext = false;
    protected Object dispatcherType = null;
    protected static final String info = "org.apache.catalina.core.ApplicationHttpRequest/1.0";
    protected Map parameters = null;
    private boolean parsedParams = false;
    protected String pathInfo = null;
    private String queryParamString = null;
    protected String queryString = null;
    protected Object requestDispatcherPath = null;
    protected String requestURI = null;
    protected String servletPath = null;
    protected Session session = null;
    private HashMap specialAttributes = null;
    private boolean isIncludeDispatch = false;

    public ApplicationHttpRequest(HttpServletRequest request, Context context, boolean crossContext) {
        super(request);
        this.context = context;
        this.crossContext = crossContext;
        this.setRequest(request);
        if (context.getManager() != null) {
            HashMap sessionVersions;
            this.isSessionVersioningSupported = context.getManager().isSessionVersioningSupported();
            if (this.isSessionVersioningSupported && (sessionVersions = (HashMap)this.getAttribute("com.sun.enterprise.http.sessionVersions")) != null) {
                this.requestedSessionVersion = (String)sessionVersions.get(context.getPath());
            }
        }
    }

    public Object getAttribute(String name) {
        if (name.equals("org.apache.catalina.core.DISPATCHER_TYPE")) {
            return this.dispatcherType;
        }
        if (name.equals("org.apache.catalina.core.DISPATCHER_REQUEST_PATH")) {
            if (this.requestDispatcherPath != null) {
                return this.requestDispatcherPath.toString();
            }
            return null;
        }
        if (!ApplicationRequest.isSpecial(name)) {
            return this.getRequest().getAttribute(name);
        }
        Object value = null;
        if (this.specialAttributes != null) {
            value = this.specialAttributes.get(name);
        }
        if (value == null && this.specialAttributes != null && name.startsWith("javax.servlet.forward")) {
            return this.getRequest().getAttribute(name);
        }
        return value;
    }

    public Enumeration getAttributeNames() {
        return new AttributeNamesEnumerator();
    }

    public void removeAttribute(String name) {
        if (ApplicationRequest.isSpecial(name)) {
            if (this.specialAttributes != null) {
                this.specialAttributes.remove(name);
            }
        } else {
            this.getRequest().removeAttribute(name);
        }
    }

    public void setAttribute(String name, Object value) {
        if (name.equals("org.apache.catalina.core.DISPATCHER_TYPE")) {
            this.dispatcherType = value;
            return;
        }
        if (name.equals("org.apache.catalina.core.DISPATCHER_REQUEST_PATH")) {
            this.requestDispatcherPath = value;
            return;
        }
        if (ApplicationRequest.isSpecial(name)) {
            if (this.specialAttributes != null) {
                this.specialAttributes.put(name, value);
            }
        } else {
            this.getRequest().setAttribute(name, value);
        }
    }

    public RequestDispatcher getRequestDispatcher(String path) {
        if (this.context == null) {
            return null;
        }
        if (path == null) {
            return null;
        }
        if (path.startsWith("/")) {
            return this.context.getServletContext().getRequestDispatcher(path);
        }
        String servletPath = (String)this.getAttribute("javax.servlet.include.servlet_path");
        if (servletPath == null) {
            servletPath = this.getServletPath();
        }
        String pathInfo = this.getPathInfo();
        String requestPath = null;
        requestPath = pathInfo == null ? servletPath : servletPath + pathInfo;
        int pos = requestPath.lastIndexOf(47);
        String relative = null;
        relative = pos >= 0 ? RequestUtil.normalize(requestPath.substring(0, pos + 1) + path) : RequestUtil.normalize(requestPath + path);
        return this.context.getServletContext().getRequestDispatcher(relative);
    }

    public String getContextPath() {
        return this.contextPath;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getParameter(String name) {
        this.parseParameters();
        Map map = this.parameters;
        synchronized (map) {
            Object value = this.parameters.get(name);
            if (value == null) {
                return null;
            }
            if (value instanceof String[]) {
                return ((String[])value)[0];
            }
            if (value instanceof String) {
                return (String)value;
            }
            return value.toString();
        }
    }

    public Map getParameterMap() {
        this.parseParameters();
        return this.parameters;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Enumeration getParameterNames() {
        this.parseParameters();
        Map map = this.parameters;
        synchronized (map) {
            return new Enumerator(this.parameters.keySet());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String[] getParameterValues(String name) {
        this.parseParameters();
        Map map = this.parameters;
        synchronized (map) {
            Object value = this.parameters.get(name);
            if (value == null) {
                return null;
            }
            if (value instanceof String[]) {
                return (String[])value;
            }
            if (value instanceof String) {
                String[] values = new String[]{(String)value};
                return values;
            }
            String[] values = new String[]{value.toString()};
            return values;
        }
    }

    public String getPathInfo() {
        return this.pathInfo;
    }

    public String getQueryString() {
        return this.queryString;
    }

    public String getRequestURI() {
        return this.requestURI;
    }

    public StringBuffer getRequestURL() {
        StringBuffer url = new StringBuffer();
        String scheme = this.getScheme();
        int port = this.getServerPort();
        if (port < 0) {
            port = 80;
        }
        url.append(scheme);
        url.append("://");
        url.append(this.getServerName());
        if (scheme.equals("http") && port != 80 || scheme.equals("https") && port != 443) {
            url.append(':');
            url.append(port);
        }
        url.append(this.getRequestURI());
        return url;
    }

    public String getServletPath() {
        return this.servletPath;
    }

    public HttpSession getSession() {
        return this.getSession(true);
    }

    public HttpSession getSession(boolean create) {
        if (this.crossContext) {
            if (this.context == null) {
                return null;
            }
            if (this.session != null && this.session.isValid()) {
                return this.session.getSession();
            }
            HttpSession other = super.getSession(false);
            if (create && other == null) {
                other = super.getSession(true);
            }
            if (other != null) {
                Session localSession = null;
                try {
                    if (this.isSessionVersioningSupported) {
                        localSession = this.context.getManager().findSession(other.getId(), this.requestedSessionVersion);
                        this.incrementSessionVersion((StandardSession)localSession, this.context);
                    } else {
                        localSession = this.context.getManager().findSession(other.getId());
                    }
                }
                catch (IOException e) {
                    // empty catch block
                }
                if (localSession != null && !localSession.isValid()) {
                    localSession = null;
                } else if (localSession == null && create) {
                    localSession = this.context.getManager().createSession(other.getId());
                    if (this.isSessionVersioningSupported) {
                        this.incrementSessionVersion((StandardSession)localSession, this.context);
                    }
                    SessionTracker tracker = (SessionTracker)this.getAttribute("com.sun.enterprise.http.sessionTracker");
                    tracker.track(localSession);
                }
                if (localSession != null) {
                    localSession.access();
                    this.session = localSession;
                    return this.session.getSession();
                }
            }
            return null;
        }
        return super.getSession(create);
    }

    public boolean isRequestedSessionIdValid() {
        if (this.crossContext) {
            String requestedSessionId = this.getRequestedSessionId();
            if (requestedSessionId == null) {
                return false;
            }
            if (this.context == null) {
                return false;
            }
            if (this.session != null && requestedSessionId.equals(this.session.getIdInternal())) {
                return this.session.isValid();
            }
            Manager manager = this.context.getManager();
            if (manager == null) {
                return false;
            }
            Session localSession = null;
            try {
                localSession = this.isSessionVersioningSupported ? manager.findSession(requestedSessionId, this.requestedSessionVersion) : manager.findSession(requestedSessionId);
            }
            catch (IOException e) {
                localSession = null;
            }
            return localSession != null && localSession.isValid();
        }
        return super.isRequestedSessionIdValid();
    }

    public void recycle() {
        if (this.session != null) {
            this.session.endAccess();
        }
    }

    public String getInfo() {
        return info;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Map copyMap(Map orig) {
        if (orig == null) {
            return new HashMap();
        }
        HashMap dest = new HashMap();
        Map map = orig;
        synchronized (map) {
            for (String key : orig.keySet()) {
                dest.put(key, orig.get(key));
            }
        }
        return dest;
    }

    void setContextPath(String contextPath) {
        this.contextPath = contextPath;
    }

    void setPathInfo(String pathInfo) {
        this.pathInfo = pathInfo;
    }

    void setQueryString(String queryString) {
        this.queryString = queryString;
    }

    void setRequest(HttpServletRequest request) {
        super.setRequest(request);
        this.dispatcherType = request.getAttribute("org.apache.catalina.core.DISPATCHER_TYPE");
        this.requestDispatcherPath = request.getAttribute("org.apache.catalina.core.DISPATCHER_REQUEST_PATH");
        this.contextPath = request.getContextPath();
        this.pathInfo = request.getPathInfo();
        this.queryString = request.getQueryString();
        this.requestURI = request.getRequestURI();
        this.servletPath = request.getServletPath();
    }

    void setRequestURI(String requestURI) {
        this.requestURI = requestURI;
    }

    void setServletPath(String servletPath) {
        this.servletPath = servletPath;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void parseParameters() {
        if (this.parsedParams) {
            return;
        }
        this.parameters = new HashMap();
        Map map = this.parameters;
        synchronized (map) {
            this.parameters = this.copyMap(this.getRequest().getParameterMap());
            this.mergeParameters();
            this.parsedParams = true;
        }
    }

    void setQueryParams(String queryString) {
        this.queryParamString = queryString;
    }

    void initSpecialAttributes(boolean isIncludeDispatch, String requestUri, String contextPath, String servletPath, String pathInfo, String queryString) {
        this.isIncludeDispatch = isIncludeDispatch;
        this.specialAttributes = new HashMap(5);
        if (isIncludeDispatch) {
            this.specialAttributes.put("javax.servlet.include.request_uri", requestUri);
            this.specialAttributes.put("javax.servlet.include.context_path", contextPath);
            this.specialAttributes.put("javax.servlet.include.servlet_path", servletPath);
            this.specialAttributes.put("javax.servlet.include.path_info", pathInfo);
            this.specialAttributes.put("javax.servlet.include.query_string", queryString);
        } else {
            this.specialAttributes.put("javax.servlet.forward.request_uri", requestUri);
            this.specialAttributes.put("javax.servlet.forward.context_path", contextPath);
            this.specialAttributes.put("javax.servlet.forward.servlet_path", servletPath);
            this.specialAttributes.put("javax.servlet.forward.path_info", pathInfo);
            this.specialAttributes.put("javax.servlet.forward.query_string", queryString);
        }
    }

    protected String[] mergeValues(Object values1, Object values2) {
        int i;
        String[] values;
        ArrayList<Object> results = new ArrayList<Object>();
        if (values1 != null) {
            if (values1 instanceof String) {
                results.add(values1);
            } else if (values1 instanceof String[]) {
                values = (String[])values1;
                for (i = 0; i < values.length; ++i) {
                    results.add(values[i]);
                }
            } else {
                results.add(values1.toString());
            }
        }
        if (values2 != null) {
            if (values2 instanceof String) {
                results.add(values2);
            } else if (values2 instanceof String[]) {
                values = (String[])values2;
                for (i = 0; i < values.length; ++i) {
                    results.add(values[i]);
                }
            } else {
                results.add(values2.toString());
            }
        }
        values = new String[results.size()];
        return results.toArray(values);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void mergeParameters() {
        if (this.queryParamString == null || this.queryParamString.length() < 1) {
            return;
        }
        HashMap<String, Object> queryParameters = new HashMap<String, Object>();
        String encoding = this.getCharacterEncoding();
        if (encoding == null) {
            encoding = "ISO-8859-1";
        }
        try {
            RequestUtil.parseParameters(queryParameters, this.queryParamString, encoding);
        }
        catch (Exception exception) {
            // empty catch block
        }
        Map map = this.parameters;
        synchronized (map) {
            for (String key : this.parameters.keySet()) {
                Object value = queryParameters.get(key);
                if (value == null) {
                    queryParameters.put(key, this.parameters.get(key));
                    continue;
                }
                queryParameters.put(key, this.mergeValues(value, this.parameters.get(key)));
            }
            this.parameters = queryParameters;
        }
    }

    private void incrementSessionVersion(StandardSession ss, Context context) {
        String path;
        if (ss == null || context == null) {
            return;
        }
        ss.incrementVersion();
        String versionString = Long.toString(ss.getVersion());
        HashMap<String, String> sessionVersions = (HashMap<String, String>)this.getAttribute("com.sun.enterprise.http.sessionVersions");
        if (sessionVersions == null) {
            sessionVersions = new HashMap<String, String>();
            this.setAttribute("com.sun.enterprise.http.sessionVersions", sessionVersions);
        }
        if ("".equals(path = context.getPath())) {
            path = "/";
        }
        sessionVersions.put(path, versionString);
    }

    protected class AttributeNamesEnumerator
    implements Enumeration {
        protected Enumeration parentEnumeration = null;
        protected String next = null;
        private Iterator<String> specialNames = null;

        public AttributeNamesEnumerator() {
            this.parentEnumeration = ApplicationHttpRequest.this.getRequest().getAttributeNames();
            if (ApplicationHttpRequest.this.specialAttributes != null) {
                this.specialNames = ApplicationHttpRequest.this.specialAttributes.keySet().iterator();
            }
        }

        public boolean hasMoreElements() {
            return this.specialNames != null && this.specialNames.hasNext() || this.next != null || (this.next = this.findNext()) != null;
        }

        public Object nextElement() {
            if (this.specialNames != null && this.specialNames.hasNext()) {
                return this.specialNames.next();
            }
            String result = this.next;
            if (this.next == null) {
                throw new NoSuchElementException();
            }
            this.next = this.findNext();
            return result;
        }

        protected String findNext() {
            String result = null;
            while (result == null && this.parentEnumeration.hasMoreElements()) {
                String current = (String)this.parentEnumeration.nextElement();
                if (ApplicationRequest.isSpecial(current) && (!ApplicationHttpRequest.this.isIncludeDispatch || !current.startsWith("javax.servlet.forward") || ApplicationHttpRequest.this.getAttribute(current) == null)) continue;
                result = current;
            }
            return result;
        }
    }
}

