/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.core;

import java.io.Serializable;
import java.lang.reflect.Method;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Stack;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.management.Notification;
import javax.management.NotificationBroadcasterSupport;
import javax.management.ObjectName;
import javax.servlet.Servlet;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.SingleThreadModel;
import javax.servlet.UnavailableException;
import javax.servlet.http.HttpServlet;
import org.apache.catalina.Container;
import org.apache.catalina.ContainerServlet;
import org.apache.catalina.Context;
import org.apache.catalina.InstanceEvent;
import org.apache.catalina.InstanceListener;
import org.apache.catalina.LifecycleException;
import org.apache.catalina.Loader;
import org.apache.catalina.Wrapper;
import org.apache.catalina.core.ContainerBase;
import org.apache.catalina.core.DummyRequest;
import org.apache.catalina.core.DummyResponse;
import org.apache.catalina.core.StandardContext;
import org.apache.catalina.core.StandardWrapperFacade;
import org.apache.catalina.core.StandardWrapperValve;
import org.apache.catalina.security.SecurityUtil;
import org.apache.catalina.util.Enumerator;
import org.apache.catalina.util.InstanceSupport;
import org.apache.commons.modeler.Registry;
import org.apache.tomcat.util.IntrospectionUtils;
import org.glassfish.web.valve.GlassFishValve;

public class StandardWrapper
extends ContainerBase
implements ServletConfig,
Wrapper {
    private static Logger log = Logger.getLogger(StandardWrapper.class.getName());
    private static final String[] DEFAULT_SERVLET_METHODS = new String[]{"GET", "HEAD", "POST"};
    private long available = 0L;
    private NotificationBroadcasterSupport broadcaster = null;
    private int countAllocated = 0;
    private int debug = 0;
    private StandardWrapperFacade facade = new StandardWrapperFacade(this);
    private static final String info = "org.apache.catalina.core.StandardWrapper/1.0";
    private Servlet instance = null;
    private InstanceSupport instanceSupport = new InstanceSupport(this);
    private String jspFile = null;
    private int loadOnStartup = -1;
    private ArrayList mappings = new ArrayList();
    private HashMap parameters = new HashMap();
    private HashMap references = new HashMap();
    private String runAs = null;
    private long sequenceNumber = 0L;
    private String servletClass = null;
    private boolean singleThreadModel = false;
    private boolean unloading = false;
    private int maxInstances = 20;
    private int nInstances = 0;
    private Stack instancePool = null;
    private boolean isJspServlet;
    private ObjectName jspMonitorON;
    private StandardWrapperValve swValve = new StandardWrapperValve();
    private long loadTime = 0L;
    private int classLoadTime = 0;
    private String description;
    private static Class[] classType = new Class[]{ServletConfig.class};
    private static Class[] classTypeUsedInService = new Class[]{ServletRequest.class, ServletResponse.class};

    public StandardWrapper() {
        this.pipeline.setBasic(this.swValve);
        this.broadcaster = new NotificationBroadcasterSupport();
    }

    public long getAvailable() {
        return this.available;
    }

    public void setAvailable(long available) {
        long oldAvailable = this.available;
        this.available = available > System.currentTimeMillis() ? available : 0L;
        this.support.firePropertyChange("available", oldAvailable, this.available);
    }

    public int getCountAllocated() {
        return this.countAllocated;
    }

    public int getDebug() {
        return this.debug;
    }

    public void setDebug(int debug) {
        int oldDebug = this.debug;
        this.debug = debug;
        this.support.firePropertyChange("debug", (Object)oldDebug, (Object)this.debug);
    }

    public String getEngineName() {
        return ((StandardContext)this.getParent()).getEngineName();
    }

    public String getInfo() {
        return info;
    }

    public InstanceSupport getInstanceSupport() {
        return this.instanceSupport;
    }

    public String getJspFile() {
        return this.jspFile;
    }

    public void setJspFile(String jspFile) {
        String oldJspFile = this.jspFile;
        this.jspFile = jspFile;
        this.support.firePropertyChange("jspFile", oldJspFile, this.jspFile);
        this.isJspServlet = true;
    }

    public int getLoadOnStartup() {
        if (this.isJspServlet && this.loadOnStartup < 0) {
            return Integer.MAX_VALUE;
        }
        return this.loadOnStartup;
    }

    public void setLoadOnStartup(int value) {
        int oldLoadOnStartup = this.loadOnStartup;
        this.loadOnStartup = value;
        this.support.firePropertyChange("loadOnStartup", (Object)oldLoadOnStartup, (Object)this.loadOnStartup);
    }

    public void setLoadOnStartupString(String value) {
        try {
            this.setLoadOnStartup(Integer.parseInt(value));
        }
        catch (NumberFormatException e) {
            this.setLoadOnStartup(0);
        }
    }

    public String getLoadOnStartupString() {
        return Integer.toString(this.getLoadOnStartup());
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getDescription() {
        return this.description;
    }

    public int getMaxInstances() {
        return this.maxInstances;
    }

    public void setMaxInstances(int maxInstances) {
        int oldMaxInstances = this.maxInstances;
        this.maxInstances = maxInstances;
        this.support.firePropertyChange("maxInstances", oldMaxInstances, this.maxInstances);
    }

    public void setParent(Container container) {
        if (container != null && !(container instanceof Context)) {
            throw new IllegalArgumentException(sm.getString("standardWrapper.notContext"));
        }
        if (container instanceof StandardContext) {
            this.notifyContainerListeners = ((StandardContext)container).isNotifyContainerListeners();
        }
        super.setParent(container);
    }

    public String getRunAs() {
        return this.runAs;
    }

    public void setRunAs(String runAs) {
        String oldRunAs = this.runAs;
        this.runAs = runAs;
        this.support.firePropertyChange("runAs", oldRunAs, this.runAs);
    }

    public String getServletClass() {
        return this.servletClass;
    }

    public void setServletClass(String servletClass) {
        String oldServletClass = this.servletClass;
        this.servletClass = servletClass;
        this.support.firePropertyChange("servletClass", oldServletClass, this.servletClass);
        if ("org.apache.jasper.servlet.JspServlet".equals(servletClass)) {
            this.isJspServlet = true;
        }
    }

    public void setServletName(String name) {
        this.setName(name);
    }

    public boolean isSingleThreadModel() {
        try {
            this.loadServlet();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return this.singleThreadModel;
    }

    public boolean isUnavailable() {
        if (this.available == 0L) {
            return false;
        }
        if (this.available <= System.currentTimeMillis()) {
            this.available = 0L;
            return false;
        }
        return true;
    }

    public String[] getServletMethods() throws ServletException {
        Class<?> servletClazz = this.loadServlet().getClass();
        if (!HttpServlet.class.isAssignableFrom(servletClazz)) {
            return DEFAULT_SERVLET_METHODS;
        }
        HashSet<String> allow = new HashSet<String>();
        allow.add("TRACE");
        allow.add("OPTIONS");
        Method[] methods = this.getAllDeclaredMethods(servletClazz);
        for (int i = 0; methods != null && i < methods.length; ++i) {
            Method m = methods[i];
            if (m.getName().equals("doGet")) {
                allow.add("GET");
                allow.add("HEAD");
                continue;
            }
            if (m.getName().equals("doPost")) {
                allow.add("POST");
                continue;
            }
            if (m.getName().equals("doPut")) {
                allow.add("PUT");
                continue;
            }
            if (!m.getName().equals("doDelete")) continue;
            allow.add("DELETE");
        }
        String[] methodNames = new String[allow.size()];
        return allow.toArray(methodNames);
    }

    public synchronized void addValve(GlassFishValve valve) {
        throw new UnsupportedOperationException("Adding valves to wrappers not supported");
    }

    public static Throwable getRootCause(ServletException e) {
        Throwable rootCauseCheck;
        Throwable rootCause = e;
        do {
            try {
                rootCauseCheck = (Throwable)IntrospectionUtils.getProperty(rootCause, "rootCause");
                if (rootCauseCheck == null) continue;
                rootCause = rootCauseCheck;
            }
            catch (ClassCastException ex) {
                rootCauseCheck = null;
            }
        } while (rootCauseCheck != null);
        return rootCause;
    }

    public void addChild(Container child) {
        throw new IllegalStateException(sm.getString("standardWrapper.notChild"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addInitParameter(String name, String value) {
        HashMap hashMap = this.parameters;
        synchronized (hashMap) {
            this.parameters.put(name, value);
        }
        if (this.notifyContainerListeners) {
            this.fireContainerEvent("addInitParameter", name);
        }
    }

    public void addInstanceListener(InstanceListener listener) {
        this.instanceSupport.addInstanceListener(listener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addMapping(String mapping) {
        ArrayList arrayList = this.mappings;
        synchronized (arrayList) {
            this.mappings.add(mapping);
        }
        if (this.notifyContainerListeners) {
            this.fireContainerEvent("addMapping", mapping);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addSecurityReference(String name, String link) {
        HashMap hashMap = this.references;
        synchronized (hashMap) {
            this.references.put(name, link);
        }
        if (this.notifyContainerListeners) {
            this.fireContainerEvent("addSecurityReference", name);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Servlet allocate() throws ServletException {
        Serializable serializable;
        if (this.unloading) {
            throw new ServletException(sm.getString("standardWrapper.unloading", this.getName()));
        }
        if (!this.singleThreadModel) {
            if (this.instance == null) {
                serializable = this;
                synchronized (serializable) {
                    if (this.instance == null) {
                        try {
                            if (log.isLoggable(Level.FINEST)) {
                                log.finest("Allocating non-STM instance");
                            }
                            this.instance = this.loadServlet();
                        }
                        catch (ServletException e) {
                            throw e;
                        }
                        catch (Throwable e) {
                            throw new ServletException(sm.getString("standardWrapper.allocate"), e);
                        }
                    }
                }
            }
            if (!this.singleThreadModel) {
                if (log.isLoggable(Level.FINEST)) {
                    log.finest("Returning non-STM instance");
                }
                ++this.countAllocated;
                return this.instance;
            }
        }
        serializable = this.instancePool;
        synchronized (serializable) {
            while (this.countAllocated >= this.nInstances) {
                if (this.nInstances < this.maxInstances) {
                    try {
                        this.instancePool.push(this.loadServlet());
                        ++this.nInstances;
                        continue;
                    }
                    catch (ServletException e) {
                        throw e;
                    }
                    catch (Throwable e) {
                        throw new ServletException(sm.getString("standardWrapper.allocate"), e);
                    }
                }
                try {
                    this.instancePool.wait();
                }
                catch (InterruptedException interruptedException) {}
            }
            if (log.isLoggable(Level.FINEST)) {
                log.finest("Returning allocated STM instance");
            }
            ++this.countAllocated;
            return (Servlet)this.instancePool.pop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deallocate(Servlet servlet) throws ServletException {
        if (!this.singleThreadModel) {
            --this.countAllocated;
            return;
        }
        Stack stack = this.instancePool;
        synchronized (stack) {
            --this.countAllocated;
            this.instancePool.push(servlet);
            this.instancePool.notify();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String findInitParameter(String name) {
        HashMap hashMap = this.parameters;
        synchronized (hashMap) {
            return (String)this.parameters.get(name);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String[] findInitParameters() {
        HashMap hashMap = this.parameters;
        synchronized (hashMap) {
            String[] results = new String[this.parameters.size()];
            return this.parameters.keySet().toArray(results);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String[] findMappings() {
        ArrayList arrayList = this.mappings;
        synchronized (arrayList) {
            return this.mappings.toArray(new String[this.mappings.size()]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String findSecurityReference(String name) {
        HashMap hashMap = this.references;
        synchronized (hashMap) {
            return (String)this.references.get(name);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String[] findSecurityReferences() {
        HashMap hashMap = this.references;
        synchronized (hashMap) {
            String[] results = new String[this.references.size()];
            return this.references.keySet().toArray(results);
        }
    }

    public Wrapper findMappingObject() {
        return (Wrapper)this.getMappingObject();
    }

    public synchronized void load() throws ServletException {
        this.instance = this.loadServlet();
    }

    public synchronized Servlet loadServlet() throws ServletException {
        Wrapper jspWrapper;
        if (!this.singleThreadModel && this.instance != null) {
            return this.instance;
        }
        long t1 = System.currentTimeMillis();
        String actualClass = this.servletClass;
        if (actualClass == null && this.jspFile != null && (jspWrapper = (Wrapper)((Context)this.getParent()).findChild("jsp")) != null) {
            String[] paramNames;
            actualClass = jspWrapper.getServletClass();
            for (String paramName : paramNames = jspWrapper.findInitParameters()) {
                if (this.parameters.get(paramName) != null) continue;
                this.parameters.put(paramName, jspWrapper.findInitParameter(paramName));
            }
        }
        if (actualClass == null) {
            this.unavailable(null);
            throw new ServletException(sm.getString("standardWrapper.notClass", this.getName()));
        }
        Loader loader = this.getLoader();
        if (loader == null) {
            this.unavailable(null);
            throw new ServletException(sm.getString("standardWrapper.missingLoader", this.getName()));
        }
        ClassLoader classLoader = loader.getClassLoader();
        if (this.isContainerProvidedServlet(actualClass) && !((Context)this.getParent()).getPrivileged()) {
            classLoader = this.getClass().getClassLoader();
        }
        Class<Object> classClass = null;
        try {
            if (SecurityUtil.isPackageProtectionEnabled()) {
                final ClassLoader fclassLoader = classLoader;
                final String factualClass = actualClass;
                try {
                    classClass = (Class<Object>)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                        public Object run() throws Exception {
                            if (fclassLoader != null) {
                                return fclassLoader.loadClass(factualClass);
                            }
                            return Class.forName(factualClass);
                        }
                    });
                }
                catch (PrivilegedActionException pax) {
                    Exception ex = pax.getException();
                    if (ex instanceof ClassNotFoundException) {
                        throw (ClassNotFoundException)ex;
                    }
                    this.getServletContext().log("Error loading " + fclassLoader + " " + factualClass, ex);
                }
            } else {
                classClass = classLoader != null ? classLoader.loadClass(actualClass) : Class.forName(actualClass);
            }
        }
        catch (ClassNotFoundException e) {
            this.unavailable(null);
            this.getServletContext().log("Error loading " + classLoader + " " + actualClass, e);
            throw new ServletException(sm.getString("standardWrapper.missingClass", actualClass), e);
        }
        if (classClass == null) {
            this.unavailable(null);
            throw new ServletException(sm.getString("standardWrapper.missingClass", actualClass));
        }
        Servlet servlet = null;
        try {
            servlet = (Servlet)classClass.newInstance();
        }
        catch (ClassCastException e) {
            this.unavailable(null);
            throw new ServletException(sm.getString("standardWrapper.notServlet", actualClass), e);
        }
        catch (Throwable e) {
            this.unavailable(null);
            throw new ServletException(sm.getString("standardWrapper.instantiate", actualClass), e);
        }
        if (!this.isServletAllowed(servlet)) {
            throw new SecurityException(sm.getString("standardWrapper.privilegedServlet", actualClass));
        }
        if (servlet instanceof ContainerServlet && (this.isContainerProvidedServlet(actualClass) || ((Context)this.getParent()).getPrivileged())) {
            ((ContainerServlet)((Object)servlet)).setWrapper(this);
        }
        this.classLoadTime = (int)(System.currentTimeMillis() - t1);
        try {
            this.instanceSupport.fireInstanceEvent(InstanceEvent.EventType.BEFORE_INIT_EVENT, servlet);
            if (SecurityUtil.executeUnderSubjectDoAs()) {
                Object[] initType = new Object[]{this.facade};
                SecurityUtil.doAsPrivilege("init", servlet, classType, initType);
                initType = null;
            } else {
                servlet.init(this.facade);
            }
            if (this.loadOnStartup >= 0 && this.jspFile != null) {
                String[] s;
                DummyRequest req = new DummyRequest();
                req.setServletPath(this.jspFile);
                req.setQueryString("jsp_precompile=true");
                String allowedMethods = (String)this.parameters.get("httpMethods");
                if (allowedMethods != null && allowedMethods.length() > 0 && (s = allowedMethods.split(",")) != null && s.length > 0) {
                    req.setMethod(s[0].trim());
                }
                DummyResponse res = new DummyResponse();
                if (SecurityUtil.executeUnderSubjectDoAs()) {
                    Object[] serviceType = new Object[]{req, res};
                    SecurityUtil.doAsPrivilege("service", servlet, classTypeUsedInService, serviceType);
                    serviceType = null;
                } else {
                    servlet.service(req, res);
                }
            }
            this.instanceSupport.fireInstanceEvent(InstanceEvent.EventType.AFTER_INIT_EVENT, servlet);
        }
        catch (UnavailableException f) {
            this.instanceSupport.fireInstanceEvent(InstanceEvent.EventType.AFTER_INIT_EVENT, servlet, (Throwable)f);
            this.unavailable(f);
            throw f;
        }
        catch (ServletException f) {
            this.instanceSupport.fireInstanceEvent(InstanceEvent.EventType.AFTER_INIT_EVENT, servlet, (Throwable)f);
            throw f;
        }
        catch (Throwable f) {
            this.getServletContext().log("StandardWrapper.Throwable", f);
            this.instanceSupport.fireInstanceEvent(InstanceEvent.EventType.AFTER_INIT_EVENT, servlet, f);
            throw new ServletException(sm.getString("standardWrapper.initException", this.getName()), f);
        }
        this.singleThreadModel = servlet instanceof SingleThreadModel;
        if (this.singleThreadModel && this.instancePool == null) {
            this.instancePool = new Stack();
        }
        if (this.notifyContainerListeners) {
            this.fireContainerEvent("load", this);
        }
        this.loadTime = System.currentTimeMillis() - t1;
        return servlet;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeInitParameter(String name) {
        HashMap hashMap = this.parameters;
        synchronized (hashMap) {
            this.parameters.remove(name);
        }
        if (this.notifyContainerListeners) {
            this.fireContainerEvent("removeInitParameter", name);
        }
    }

    public void removeInstanceListener(InstanceListener listener) {
        this.instanceSupport.removeInstanceListener(listener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeMapping(String mapping) {
        ArrayList arrayList = this.mappings;
        synchronized (arrayList) {
            this.mappings.remove(mapping);
        }
        if (this.notifyContainerListeners) {
            this.fireContainerEvent("removeMapping", mapping);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeSecurityReference(String name) {
        HashMap hashMap = this.references;
        synchronized (hashMap) {
            this.references.remove(name);
        }
        if (this.notifyContainerListeners) {
            this.fireContainerEvent("removeSecurityReference", name);
        }
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        if (this.getParent() != null) {
            sb.append(this.getParent().toString());
            sb.append(".");
        }
        sb.append("StandardWrapper[");
        sb.append(this.getName());
        sb.append("]");
        return sb.toString();
    }

    public void unavailable(UnavailableException unavailable) {
        this.getServletContext().log(sm.getString("standardWrapper.unavailable", this.getName()));
        if (unavailable == null) {
            this.setAvailable(Long.MAX_VALUE);
        } else if (unavailable.isPermanent()) {
            this.setAvailable(Long.MAX_VALUE);
        } else {
            int unavailableSeconds = unavailable.getUnavailableSeconds();
            if (unavailableSeconds <= 0) {
                unavailableSeconds = 60;
            }
            this.setAvailable(System.currentTimeMillis() + (long)unavailableSeconds * 1000L);
        }
    }

    public synchronized void unload() throws ServletException {
        if (!this.singleThreadModel && this.instance == null) {
            return;
        }
        this.unloading = true;
        if (this.countAllocated > 0) {
            for (int nRetries = 0; nRetries < 21 && this.countAllocated > 0; ++nRetries) {
                if (nRetries % 10 == 0) {
                    log.fine(sm.getString("standardWrapper.waiting", (Object)this.countAllocated, this.instance.getClass().getName()));
                }
                try {
                    Thread.sleep(100L);
                    continue;
                }
                catch (InterruptedException e) {
                    // empty catch block
                }
            }
        }
        ClassLoader oldCtxClassLoader = Thread.currentThread().getContextClassLoader();
        ClassLoader classLoader = this.instance.getClass().getClassLoader();
        try {
            this.instanceSupport.fireInstanceEvent(InstanceEvent.EventType.BEFORE_DESTROY_EVENT, this.instance);
            Thread.currentThread().setContextClassLoader(classLoader);
            if (SecurityUtil.executeUnderSubjectDoAs()) {
                SecurityUtil.doAsPrivilege("destroy", this.instance);
                SecurityUtil.remove(this.instance);
            } else {
                this.instance.destroy();
            }
            this.instanceSupport.fireInstanceEvent(InstanceEvent.EventType.AFTER_DESTROY_EVENT, this.instance);
        }
        catch (Throwable t) {
            this.instanceSupport.fireInstanceEvent(InstanceEvent.EventType.AFTER_DESTROY_EVENT, this.instance, t);
            this.instance = null;
            this.instancePool = null;
            this.nInstances = 0;
            if (this.notifyContainerListeners) {
                this.fireContainerEvent("unload", this);
            }
            this.unloading = false;
            throw new ServletException(sm.getString("standardWrapper.destroyException", this.getName()), t);
        }
        finally {
            Thread.currentThread().setContextClassLoader(oldCtxClassLoader);
        }
        this.instance = null;
        if (this.singleThreadModel && this.instancePool != null) {
            try {
                Thread.currentThread().setContextClassLoader(classLoader);
                while (!this.instancePool.isEmpty()) {
                    if (SecurityUtil.executeUnderSubjectDoAs()) {
                        SecurityUtil.doAsPrivilege("destroy", (Servlet)this.instancePool.pop());
                        SecurityUtil.remove(this.instance);
                        continue;
                    }
                    ((Servlet)this.instancePool.pop()).destroy();
                }
            }
            catch (Throwable t) {
                this.instancePool = null;
                this.nInstances = 0;
                this.unloading = false;
                if (this.notifyContainerListeners) {
                    this.fireContainerEvent("unload", this);
                }
                throw new ServletException(sm.getString("standardWrapper.destroyException", this.getName()), t);
            }
            finally {
                Thread.currentThread().setContextClassLoader(oldCtxClassLoader);
            }
            this.instancePool = null;
            this.nInstances = 0;
        }
        this.singleThreadModel = false;
        this.unloading = false;
        if (this.notifyContainerListeners) {
            this.fireContainerEvent("unload", this);
        }
    }

    public String getInitParameter(String name) {
        return this.findInitParameter(name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Enumeration getInitParameterNames() {
        HashMap hashMap = this.parameters;
        synchronized (hashMap) {
            return new Enumerator(this.parameters.keySet());
        }
    }

    public ServletContext getServletContext() {
        if (this.parent == null) {
            return null;
        }
        if (!(this.parent instanceof Context)) {
            return null;
        }
        return ((Context)this.parent).getServletContext();
    }

    public String getServletName() {
        return this.getName();
    }

    public long getProcessingTimeMillis() {
        return this.swValve.getProcessingTimeMillis();
    }

    public void setProcessingTimeMillis(long processingTimeMillis) {
        this.swValve.setProcessingTimeMillis(processingTimeMillis);
    }

    public long getMaxTimeMillis() {
        return this.swValve.getMaxTimeMillis();
    }

    public void setMaxTimeMillis(long maxTimeMillis) {
        this.swValve.setMaxTimeMillis(maxTimeMillis);
    }

    public long getMinTimeMillis() {
        return this.swValve.getMinTimeMillis();
    }

    public void setMinTimeMillis(long minTimeMillis) {
        this.swValve.setMinTimeMillis(minTimeMillis);
    }

    public int getRequestCount() {
        return this.swValve.getRequestCount();
    }

    public void setRequestCount(int requestCount) {
        this.swValve.setRequestCount(requestCount);
    }

    public int getErrorCount() {
        return this.swValve.getErrorCount();
    }

    public void setErrorCount(int errorCount) {
        this.swValve.setErrorCount(errorCount);
    }

    public void incrementErrorCount() {
        this.swValve.setErrorCount(this.swValve.getErrorCount() + 1);
    }

    public long getLoadTime() {
        return this.loadTime;
    }

    public void setLoadTime(long loadTime) {
        this.loadTime = loadTime;
    }

    public int getClassLoadTime() {
        return this.classLoadTime;
    }

    protected void addDefaultMapper(String mapperClass) {
    }

    private boolean isContainerProvidedServlet(String classname) {
        if (classname.startsWith("org.apache.catalina.")) {
            return true;
        }
        try {
            Class<?> clazz = this.getClass().getClassLoader().loadClass(classname);
            return ContainerServlet.class.isAssignableFrom(clazz);
        }
        catch (Throwable t) {
            return false;
        }
    }

    private boolean isServletAllowed(Object servlet) {
        if (servlet instanceof ContainerServlet) {
            return ((Context)this.getParent()).getPrivileged() || servlet.getClass().getName().equals("org.apache.catalina.servlets.InvokerServlet");
        }
        return true;
    }

    protected String logName() {
        StringBuffer sb = new StringBuffer("StandardWrapper[");
        if (this.getParent() != null) {
            sb.append(this.getParent().getName());
        } else {
            sb.append("null");
        }
        sb.append(':');
        sb.append(this.getName());
        sb.append(']');
        return sb.toString();
    }

    private Method[] getAllDeclaredMethods(Class c) {
        if (c.equals(HttpServlet.class)) {
            return null;
        }
        Method[] parentMethods = this.getAllDeclaredMethods(c.getSuperclass());
        Method[] thisMethods = c.getDeclaredMethods();
        if (thisMethods == null) {
            return parentMethods;
        }
        if (parentMethods != null && parentMethods.length > 0) {
            Method[] allMethods = new Method[parentMethods.length + thisMethods.length];
            System.arraycopy(parentMethods, 0, allMethods, 0, parentMethods.length);
            System.arraycopy(thisMethods, 0, allMethods, parentMethods.length, thisMethods.length);
            thisMethods = allMethods;
        }
        return thisMethods;
    }

    public void start() throws LifecycleException {
        Notification notification;
        if (this.getObjectName() != null) {
            notification = new Notification("j2ee.state.starting", this.getObjectName(), this.sequenceNumber++);
            this.broadcaster.sendNotification(notification);
        }
        super.start();
        if (this.oname != null) {
            this.registerJMX((StandardContext)this.getParent());
        }
        this.setAvailable(0L);
        if (this.getObjectName() != null) {
            notification = new Notification("j2ee.state.running", this.getObjectName(), this.sequenceNumber++);
            this.broadcaster.sendNotification(notification);
        }
    }

    public void stop() throws LifecycleException {
        Notification notification;
        this.setAvailable(Long.MAX_VALUE);
        if (this.getObjectName() != null) {
            notification = new Notification("j2ee.state.stopping", this.getObjectName(), this.sequenceNumber++);
            this.broadcaster.sendNotification(notification);
        }
        try {
            this.unload();
        }
        catch (ServletException e) {
            this.getServletContext().log(sm.getString("standardWrapper.unloadException", this.getName()), e);
        }
        super.stop();
        if (this.getObjectName() != null) {
            notification = new Notification("j2ee.state.stopped", this.getObjectName(), this.sequenceNumber++);
            this.broadcaster.sendNotification(notification);
        }
        if (this.oname != null) {
            Registry.getRegistry().unregisterComponent(this.oname);
            notification = new Notification("j2ee.object.deleted", this.getObjectName(), this.sequenceNumber++);
            this.broadcaster.sendNotification(notification);
        }
        if (this.isJspServlet && this.jspMonitorON != null) {
            Registry.getRegistry(null, null).unregisterComponent(this.jspMonitorON);
        }
    }

    protected void registerJMX(StandardContext ctx) {
        block7: {
            String onameStr;
            String webMod;
            String domain;
            block6: {
                String parentName = ctx.getEncodedPath();
                parentName = "".equals(parentName) ? "/" : parentName;
                String hostName = ctx.getParent().getName();
                hostName = hostName == null ? "DEFAULT" : hostName;
                domain = ctx.getDomain();
                webMod = "//" + hostName + parentName;
                onameStr = domain + ":j2eeType=Servlet,name=" + this.getName() + ",WebModule=" + webMod + ",J2EEApplication=" + ctx.getJ2EEApplication() + ",J2EEServer=" + ctx.getJ2EEServer();
                try {
                    this.controller = this.oname = new ObjectName(onameStr);
                    Registry.getRegistry().registerComponent((Object)this, this.oname, null);
                    if (this.getObjectName() != null) {
                        Notification notification = new Notification("j2ee.object.created", this.getObjectName(), this.sequenceNumber++);
                        this.broadcaster.sendNotification(notification);
                    }
                }
                catch (Exception ex) {
                    if (!log.isLoggable(Level.INFO)) break block6;
                    log.log(Level.INFO, "Error registering servlet with jmx " + this, ex);
                }
            }
            if (this.isJspServlet) {
                onameStr = domain + ":type=JspMonitor,name=" + this.getName() + ",WebModule=" + webMod + ",J2EEApplication=" + ctx.getJ2EEApplication() + ",J2EEServer=" + ctx.getJ2EEServer();
                try {
                    this.jspMonitorON = new ObjectName(onameStr);
                    Registry.getRegistry(null, null).registerComponent((Object)this.instance, this.jspMonitorON, null);
                }
                catch (Exception ex) {
                    if (!log.isLoggable(Level.INFO)) break block7;
                    log.log(Level.INFO, "Error registering JSP monitoring with jmx " + this.instance, ex);
                }
            }
        }
    }

    public boolean isEventProvider() {
        return false;
    }

    public boolean isStateManageable() {
        return false;
    }

    public boolean isStatisticsProvider() {
        return false;
    }
}

