/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.helper;

import java.util.ListIterator;
import java.util.Vector;
import org.eclipse.persistence.internal.databaseaccess.DatasourceCall;
import org.eclipse.persistence.internal.helper.DatabaseField;
import org.eclipse.persistence.internal.sessions.AbstractRecord;
import org.eclipse.persistence.platform.database.DatabasePlatform;
import org.eclipse.persistence.platform.database.oracle.PLSQLargument;
import org.eclipse.persistence.sessions.DatabaseRecord;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public interface DatabaseType {
    public static final String TARGET_SUFFIX = "_TARGET";
    public static final String COMPAT_SUFFIX = "_COMPAT";

    public boolean isComplexDatabaseType();

    public boolean isJDBCType();

    public int getSqlCode();

    public int getConversionCode();

    public String getTypeName();

    public int computeInIndex(PLSQLargument var1, int var2, ListIterator<PLSQLargument> var3);

    public int computeOutIndex(PLSQLargument var1, int var2, ListIterator<PLSQLargument> var3);

    public void buildInDeclare(StringBuilder var1, PLSQLargument var2);

    public void buildOutDeclare(StringBuilder var1, PLSQLargument var2);

    public void buildBeginBlock(StringBuilder var1, PLSQLargument var2);

    public void buildOutAssignment(StringBuilder var1, PLSQLargument var2);

    public void translate(PLSQLargument var1, AbstractRecord var2, AbstractRecord var3, Vector var4, Vector var5, Vector var6);

    public void buildOutputRow(PLSQLargument var1, AbstractRecord var2, DatabaseRecord var3, Vector var4, Vector var5);

    public void logParameter(StringBuilder var1, Integer var2, PLSQLargument var3, AbstractRecord var4, DatabasePlatform var5);

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum DatabaseTypeHelper {
        databaseTypeHelper;


        public String buildTarget(PLSQLargument arg) {
            StringBuilder sb = new StringBuilder(arg.name);
            sb.append(DatabaseType.TARGET_SUFFIX);
            return sb.toString();
        }

        public String buildCompatible(PLSQLargument arg) {
            StringBuilder sb = new StringBuilder(arg.name);
            sb.append(DatabaseType.COMPAT_SUFFIX);
            return sb.toString();
        }

        public void declareTarget(StringBuilder sb, PLSQLargument arg, DatabaseType databaseType) {
            sb.append("  ");
            sb.append(this.buildTarget(arg));
            sb.append(" ");
            sb.append(databaseType.getTypeName());
        }

        public int computeInIndex(PLSQLargument inArg, int newIndex) {
            inArg.inIndex = newIndex++;
            return newIndex;
        }

        public int computeOutIndex(PLSQLargument outArg, int newIndex) {
            outArg.outIndex = newIndex++;
            return newIndex;
        }

        public void buildOutAssignment(StringBuilder sb, PLSQLargument outArg) {
            sb.append("  :");
            sb.append(outArg.outIndex);
            sb.append(" := ");
            sb.append(this.buildTarget(outArg));
            sb.append(";\n");
        }

        public void translate(PLSQLargument arg, AbstractRecord translationRow, AbstractRecord copyOfTranslationRow, Vector copyOfTranslationFields, Vector translationRowFields, Vector translationRowValues) {
            DatabaseField field = null;
            for (DatabaseField f : copyOfTranslationFields) {
                if (!f.getName().equals(arg.name)) continue;
                field = f;
                break;
            }
            if (arg.length != Integer.MIN_VALUE) {
                field.setLength(arg.length);
            }
            if (arg.precision != Integer.MIN_VALUE) {
                field.setPrecision(arg.precision);
            }
            if (arg.scale != Integer.MIN_VALUE) {
                field.setScale(arg.scale);
            }
            translationRowFields.setElementAt(field, arg.inIndex - 1);
            Object value = copyOfTranslationRow.get(field);
            translationRowValues.setElementAt(value, arg.inIndex - 1);
        }

        public void buildOutputRow(PLSQLargument outArg, AbstractRecord outputRow, DatabaseRecord newOutputRow, Vector outputRowFields, Vector outputRowValues) {
            DatabaseField field = null;
            for (DatabaseField f : outputRowFields) {
                if (!f.getName().equals(outArg.name)) continue;
                field = f;
                break;
            }
            Object value = outputRow.get(field);
            newOutputRow.add(field, value);
        }

        public void logParameter(StringBuilder sb, Integer direction, PLSQLargument arg, AbstractRecord translationRow, DatabasePlatform platform) {
            if (direction == DatasourceCall.IN && arg.inIndex != Integer.MIN_VALUE) {
                sb.append(":");
                sb.append(arg.inIndex);
                sb.append(" => ");
                sb.append(platform.convertToDatabaseType(translationRow.get(arg.name)));
            }
            if (direction == DatasourceCall.OUT && arg.outIndex != Integer.MIN_VALUE) {
                sb.append(arg.name);
                sb.append(" => :");
                sb.append(arg.outIndex);
            }
        }
    }
}

