/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.admin.amx.dotted;

import com.sun.appserv.management.base.AMX;
import com.sun.appserv.management.base.Container;
import com.sun.appserv.management.base.Pathnames;
import com.sun.appserv.management.base.QueryMgr;
import com.sun.appserv.management.base.Util;
import com.sun.appserv.management.config.DomainConfig;
import com.sun.appserv.management.util.jmx.JMXUtil;
import com.sun.appserv.management.util.misc.ExceptionUtil;
import com.sun.appserv.management.util.misc.StringUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.management.ObjectName;
import org.glassfish.admin.amx.dotted.PathPart;
import org.glassfish.admin.amx.dotted.V3Pathname;
import org.glassfish.admin.amx.mbean.AMXNonConfigImplBase;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class PathnamesImpl
extends AMXNonConfigImplBase {
    public PathnamesImpl(ObjectName parentObjectName) {
        super("X-Pathnames", "X-Pathnames", parentObjectName, Pathnames.class, null);
        PathnamesImpl.cdebug("PathnamesImpl: " + this.getClass().getName());
    }

    @Override
    public String getGroup() {
        return "utility";
    }

    private DomainConfig getDomainConfig() {
        return this.getDomainRoot().getDomainConfig();
    }

    public Object[] pathnameGet(String[] names) {
        Object[] results = new Object[names.length];
        for (int i = 0; i < names.length; ++i) {
            results[i] = this.pathnameGet(names[i]);
        }
        return results;
    }

    private AMX findMatchingChild(AMX amx, PathPart part) {
        AMX child = null;
        if (amx instanceof Container) {
            Set containees = ((Container)amx).getContaineeSet();
            for (AMX c : containees) {
                String type = part.getType();
                String name = part.getName();
                if (type.equalsIgnoreCase(c.getPathnameType())) {
                    if (name != null && !name.equalsIgnoreCase(c.getName())) continue;
                    child = c;
                    break;
                }
                if (type.length() != 0 || name == null || !name.equalsIgnoreCase(c.getName())) continue;
                child = c;
                break;
            }
        }
        return child;
    }

    private AMX resolveToAnAMX(V3Pathname v3path) {
        AMX amx = this.getDomainRoot();
        List<PathPart> parts = v3path.getParts();
        PathnamesImpl.cdebug("Pathname: v3path = " + v3path + ",  parts = " + StringUtil.toString(v3path.getParts()) + ", attr = " + v3path.getParsed().getAttrPart());
        if (!parts.get(0).getType().equals(this.getDomainRoot().getPathnameType())) {
            throw new IllegalArgumentException("bad root: " + parts.get(0).getType() + " != " + this.getDomainRoot().getPathnameType() + " path = " + v3path.toString());
        }
        if (parts.size() > 1) {
            for (int i = 1; i < parts.size(); ++i) {
                PathPart part = parts.get(i);
                AMX child = this.findMatchingChild(amx, part);
                if (child == null) {
                    throw new IllegalArgumentException("Match failed for: " + v3path + " at " + part);
                }
                amx = child;
            }
        } else {
            amx = this.getDomainRoot();
        }
        return amx;
    }

    public ObjectName getPathnameTargetObjectName(String pathname) {
        AMX amx = this.resolveToAnAMX(new V3Pathname(pathname));
        return amx == null ? null : Util.getObjectName(amx);
    }

    public Map<String, ObjectName> getPathnameTargetObjectNameMap(String[] pathnames) {
        HashMap<String, ObjectName> m = new HashMap<String, ObjectName>();
        for (String pathname : pathnames) {
            m.put(pathname, this.getPathnameTargetObjectName(pathname));
        }
        return m;
    }

    private void getInOrderPathnames(AMX amx, List<String> pathnames) {
        if (amx instanceof Container) {
            Set containees = ((Container)amx).getContaineeSet();
            HashMap<Object, AMX> m = new HashMap<Object, AMX>();
            Object[] paths = new String[containees.size()];
            int i = 0;
            for (AMX containee : containees) {
                paths[i] = containee.getPathname();
                m.put(paths[i], containee);
                ++i;
            }
            Arrays.sort(paths);
            for (Object path : paths) {
                pathnames.add((String)path);
                this.getInOrderPathnames((AMX)m.get(path), pathnames);
            }
        }
    }

    public String[] getAllPathnames() {
        ArrayList<String> pathnames = new ArrayList<String>();
        pathnames.add(this.getDomainRoot().getPathname());
        this.getInOrderPathnames(this.getDomainRoot(), pathnames);
        return pathnames.toArray(new String[pathnames.size()]);
    }

    public String testResolve() {
        Map<String, ObjectName> all = this.getAllPathnameTargetsObjectNameMap();
        String dump = "";
        int numProblems = 0;
        for (String pathname : all.keySet()) {
            try {
                ObjectName on = this.getPathnameTargetObjectName(pathname);
                dump = dump + pathname + " => " + JMXUtil.toString(on) + StringUtil.NEWLINE();
            }
            catch (Exception e) {
                dump = dump + pathname + " => " + ExceptionUtil.toString(e) + StringUtil.NEWLINE();
                ++numProblems;
            }
        }
        dump = dump + "PROBLEMS FOUND: " + numProblems;
        return dump;
    }

    public Object pathnameGet(String nameIn) {
        PathnamesImpl.cdebug("pathnameGet: " + nameIn);
        AMX amx = this.resolveToAnAMX(new V3Pathname(nameIn));
        if (amx != null) {
            PathnamesImpl.cdebug("pathnameGet: resolved: " + nameIn + " to " + JMXUtil.toString(Util.getObjectName(amx)));
        }
        return amx == null ? null : Util.getObjectName(amx);
    }

    public Object[] pathnameList(String name) {
        Object[] results = null;
        try {
            AMX amx = this.resolveToAnAMX(new V3Pathname(name));
            if (amx instanceof Container) {
                Set containees = ((Container)amx).getContaineeSet();
                results = new String[containees.size()];
                int i = 0;
                for (AMX containee : containees) {
                    results[i++] = containee.getPathname();
                }
            } else {
                results = new String[]{};
            }
        }
        catch (Exception e) {
            results = new Exception[]{e};
        }
        return results;
    }

    public Object[] pathnameList(String[] names) {
        Object[] results = new Object[names.length];
        for (int i = 0; i < names.length; ++i) {
            results[i] = this.pathnameList(names[i]);
        }
        return results;
    }

    public Object[] pathnameSet(String[] nameValuePairs) {
        return null;
    }

    protected boolean isWriteablePathname(String name) {
        return true;
    }

    public Map<String, ObjectName> getAllPathnameTargetsObjectNameMap() {
        QueryMgr queryMgr = this.getDomainRoot().getQueryMgr();
        Set<AMX> allAMX = queryMgr.queryAllSet();
        HashMap<String, ObjectName> result = new HashMap<String, ObjectName>();
        for (AMX amx : allAMX) {
            result.put(amx.getPathname(), Util.getObjectName(amx));
        }
        return result;
    }

    public Map<String, String> getManyPathnameValues(Set<String> pathnames) {
        HashMap<String, String> results = new HashMap<String, String>();
        for (String pathname : pathnames) {
            V3Pathname p = new V3Pathname(pathname);
            AMX amx = this.resolveToAnAMX(p);
            if (amx == null) continue;
            PathnamesImpl.cdebug("Resolved " + p + " to " + Util.getObjectName(amx));
            try {
                String valueName = p.getParsed().getAttrPart().getName();
                if (valueName == null) continue;
                String value = "" + amx.getPathnameValue(valueName);
                results.put(pathname, value);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return results;
    }

    public Map<String, String> getPathnameValues(String pathname) {
        V3Pathname p = new V3Pathname(pathname);
        AMX amx = this.resolveToAnAMX(p);
        Map<String, String> items = amx.getPathnameToAttributes();
        Map<String, String> nameValuePairs = amx.getPathnameValues(items.keySet());
        return nameValuePairs;
    }

    public String pathnameGetSingleValue(String pathname) {
        Set<String> temp = Collections.singleton(pathname);
        Map<String, String> results = this.getManyPathnameValues(temp);
        String result = results.get(pathname);
        return result;
    }

    public String dumpPathnames() {
        StringBuffer buf = new StringBuffer();
        String[] all = this.getAllPathnames();
        Pathnames self = this.getSelf(Pathnames.class);
        for (String pn : all) {
            buf.append("\n" + pn + "\n");
            try {
                AMX amx = self.getPathnameTarget(pn);
                Map<String, String> allValues = self.getPathnameValues(pn);
                for (String pnAttrName : allValues.keySet()) {
                    String msg = "\t@" + pnAttrName + " = " + allValues.get(pnAttrName);
                    buf.append(msg + "\n");
                }
                if (!(amx instanceof Container)) continue;
                Set containees = ((Container)amx).getContaineeSet();
                for (AMX containee : containees) {
                    buf.append("\t/" + containee.getPathnamePart() + "\n");
                }
            }
            catch (Exception e) {
                buf.append(pn + " FAILED: " + ExceptionUtil.getRootCause(e));
            }
        }
        return buf.toString();
    }
}

