/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.admin.amx.loader;

import com.sun.appserv.management.util.jmx.JMXUtil;
import com.sun.appserv.management.util.jmx.MBeanRegistrationListener;
import com.sun.appserv.management.util.misc.GSetUtil;
import java.io.IOException;
import java.util.Set;
import javax.management.MBeanServer;
import javax.management.ObjectName;

public final class J2EELoader {
    private final MBeanServer mMBeanServer;
    private final ConfigListener mConfigListener;
    private static final Set<String> SYNC_TYPES = GSetUtil.newUnmodifiableStringSet("X-J2EEApplicationConfig", "X-WebModuleConfig", "X-EJBModuleConfig", "X-AppClientModuleConfig", "X-RARModuleConfig", "X-ClusteredServerConfig", "X-StandaloneServerConfig", "X-ResourceAdapterConfig", "X-MailResourceConfig", "X-JNDIResourceConfig", "X-JDBCResourceConfig");

    protected static void debug(String s) {
        System.out.println(s);
    }

    public J2EELoader(MBeanServer mbeanServer) {
        this.mMBeanServer = mbeanServer;
        ConfigListener configListener = null;
        try {
            configListener = new ConfigListener(mbeanServer);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        this.mConfigListener = configListener;
    }

    public synchronized void start() {
        try {
            this.mConfigListener.startListening();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private final class ConfigListener
    extends MBeanRegistrationListener {
        public ConfigListener(MBeanServer mbeanServer) throws IOException {
            super("J2EELoader.ConfigListener", mbeanServer, JMXUtil.newObjectNamePattern("amx", "*"));
        }

        protected void mbeanRegistered(ObjectName objectName) {
            String j2eeType = objectName.getKeyProperty("j2eeType");
            if (SYNC_TYPES.contains(j2eeType)) {
                // empty if block
            }
        }

        protected void mbeanUnregistered(ObjectName objectName) {
            String j2eeType = objectName.getKeyProperty("j2eeType");
            if (SYNC_TYPES.contains(j2eeType)) {
                // empty if block
            }
        }
    }
}

