/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.admin.amx.mbean;

import com.sun.appserv.management.base.AMX;
import com.sun.appserv.management.base.Extra;
import com.sun.appserv.management.util.jmx.JMXUtil;
import java.util.HashMap;
import java.util.Map;
import javax.management.MBeanAttributeInfo;
import javax.management.MBeanInfo;
import org.glassfish.admin.amx.mbean.MBeanInfoConverter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class MBeanInfoCache {
    private final Map<Class<? extends AMX>, MBeanInfo> mInfos = new HashMap<Class<? extends AMX>, MBeanInfo>();
    private final Map<Class<?>, MBeanInfo> mOtherInfos = new HashMap();
    private static final MBeanInfoCache INSTANCE = new MBeanInfoCache();
    private final MBeanAttributeInfo[] EXTRA = MBeanInfoCache.getExtraAttributeInfos();

    private MBeanInfoCache() {
    }

    public static synchronized MBeanInfo getAMXMBeanInfo(Class<? extends AMX> amxInterface) {
        MBeanInfo info = MBeanInfoCache.INSTANCE.mInfos.get(amxInterface);
        if (info == null) {
            info = MBeanInfoConverter.getInstance().convert(amxInterface, MBeanInfoCache.INSTANCE.EXTRA);
            MBeanInfoCache.INSTANCE.mInfos.put(amxInterface, info);
        }
        return info;
    }

    public static synchronized MBeanInfo getOtherMBeanInfo(Class<?> intf) {
        MBeanInfo info = MBeanInfoCache.INSTANCE.mOtherInfos.get(intf);
        if (info == null) {
            info = MBeanInfoConverter.getInstance().convert(intf, null);
            MBeanInfoCache.INSTANCE.mOtherInfos.put(intf, info);
        }
        return info;
    }

    private static MBeanAttributeInfo[] getExtraAttributeInfos() {
        String[] EXTRA_REMOVALS = new String[]{"ProxyFactory", "ConnectionSource", "MBeanInfo", "AllAttributes"};
        MBeanAttributeInfo[] extraInfos = JMXUtil.interfaceToMBeanInfo(Extra.class).getAttributes();
        Map<String, MBeanAttributeInfo> m = JMXUtil.attributeInfosToMap(extraInfos);
        for (int i = 0; i < EXTRA_REMOVALS.length; ++i) {
            m.remove(EXTRA_REMOVALS[i]);
        }
        MBeanAttributeInfo[] result = new MBeanAttributeInfo[m.values().size()];
        m.values().toArray(result);
        return result;
    }
}

