/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.admin.amx.mbean;

import com.sun.appserv.connectors.internal.api.ConnectorRuntime;
import com.sun.appserv.management.base.SystemStatus;
import com.sun.appserv.management.base.UnprocessedConfigChange;
import com.sun.appserv.management.config.JDBCConnectionPoolConfig;
import com.sun.appserv.management.util.misc.ExceptionUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.management.ObjectName;
import javax.resource.ResourceException;
import org.glassfish.admin.amx.mbean.AMXNonConfigImplBase;
import org.glassfish.admin.amx.util.Issues;
import org.glassfish.internal.api.Globals;
import org.jvnet.hk2.component.ComponentException;
import org.jvnet.hk2.component.Habitat;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class SystemStatusImpl
extends AMXNonConfigImplBase
implements SystemStatus {
    public SystemStatusImpl(ObjectName parentObjectName) {
        super("X-SystemStatus", "X-SystemStatus", parentObjectName, SystemStatus.class, null);
    }

    @Override
    public Map<String, Object> pingJDBCConnectionPool(String poolName) {
        ConnectorRuntime connRuntime;
        HashMap<String, Object> result = new HashMap<String, Object>();
        boolean pingable = false;
        Habitat habitat = Globals.getDefaultHabitat();
        JDBCConnectionPoolConfig cfg = this.getDomainRoot().getDomainConfig().getResourcesConfig().getJDBCConnectionPoolConfigMap().get(poolName);
        if (cfg == null) {
            result.put("PingSucceededKey", pingable);
            result.put("ReasonFailedKey", "The pool name " + poolName + " does not exist");
            return result;
        }
        if (habitat == null) {
            result.put("PingSucceededKey", pingable);
            result.put("ReasonFailedKey", "Habitat is null");
            return result;
        }
        try {
            connRuntime = habitat.getComponent(ConnectorRuntime.class, null);
        }
        catch (ComponentException e) {
            result.put("PingSucceededKey", pingable);
            result.put("ReasonFailedKey", ExceptionUtil.toString(e));
            return result;
        }
        try {
            pingable = connRuntime.pingConnectionPool(poolName);
        }
        catch (ResourceException e) {
            result.put("PingSucceededKey", pingable);
            result.put("ReasonFailedKey", ExceptionUtil.toString(e));
            return result;
        }
        result.put("PingSucceededKey", pingable);
        return result;
    }

    @Override
    public List<Object[]> getUnprocessedConfigChanges(int howMany) {
        Issues.getAMXIssues().notDone("SystemStatusImpl.getUnprocessedConfigChanges() needs to get all the config changes and morph them appropriately");
        ArrayList<Object[]> changes = new ArrayList<Object[]>();
        UnprocessedConfigChange test = new UnprocessedConfigChange("TEST", "old", "new", this.getObjectName(), "for testing");
        changes.add(test.toArray());
        return changes;
    }
}

