/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.admin.connector.rmi;

import java.net.InetAddress;
import java.net.MalformedURLException;
import java.net.UnknownHostException;
import java.util.logging.Logger;
import javax.management.remote.JMXServiceURL;

public class JmxServiceUrlFactory {
    public static final String RMI_JSR160_CS_JNDI_SUFFIX = "/management/rmi-jmx-connector";
    public static final String JCONSOLE_RMI_JSR160_CS_JNDI_SUFFIX = "/jmxrmi";
    private static final Logger logger = Logger.getLogger("javax.enterprise.system.tools.admin");

    private JmxServiceUrlFactory() {
    }

    public static JMXServiceURL forRmiJrmpWithoutStub(int port) {
        JMXServiceURL url;
        try {
            String s = "service:jmx:rmi://" + JmxServiceUrlFactory.localhost() + ":" + port;
            url = new JMXServiceURL(s);
            String msg = "JmxServiceUrlFactory=>JMXServiceURL is: " + url;
            logger.fine(msg);
        }
        catch (MalformedURLException m) {
            url = null;
        }
        assert (url != null) : "Something seriously wrong, can't form the JMXServiceURL";
        return url;
    }

    public static JMXServiceURL forRmiIiopWithoutIor(int port) {
        JMXServiceURL url;
        try {
            String s = "service:jmx:iiop://" + JmxServiceUrlFactory.localhost() + ":" + port;
            url = new JMXServiceURL(s);
            String msg = "JMXServiceURL is: " + url;
            logger.fine(msg);
        }
        catch (MalformedURLException m) {
            url = null;
        }
        assert (url != null) : "Something seriously wrong, can't form the JMXServiceURL";
        return url;
    }

    public static JMXServiceURL forRmiWithJndiInAppserver(String host, int port) {
        return JmxServiceUrlFactory.forRmiWithJndi(host, port, RMI_JSR160_CS_JNDI_SUFFIX, false);
    }

    public static JMXServiceURL forJconsoleOverRmiWithJndiInAppserver(String host, int port) {
        return JmxServiceUrlFactory.forRmiWithJndi(host, port, JCONSOLE_RMI_JSR160_CS_JNDI_SUFFIX, false);
    }

    private static JMXServiceURL forRmiWithJndi(String host, int port, String jn, boolean addHost) {
        JMXServiceURL url;
        String hps = "";
        if (host == null || jn == null) {
            throw new IllegalArgumentException("Null Argument");
        }
        if (!jn.startsWith("/")) {
            throw new IllegalArgumentException("jndi-name must start with a /");
        }
        if (addHost) {
            hps = host + ":" + port;
        }
        try {
            String s = "service:jmx:rmi://" + hps + "/jndi/rmi://" + host + ":" + port + jn;
            url = new JMXServiceURL(s);
            String msg = "JMXServiceURL is: " + url;
            logger.fine(msg);
        }
        catch (MalformedURLException m) {
            url = null;
        }
        assert (url != null) : "Something seriously wrong, can't form the JMXServiceURL";
        return url;
    }

    private static JMXServiceURL forRmiWithJndi(int port, String jn) {
        return JmxServiceUrlFactory.forRmiWithJndi(JmxServiceUrlFactory.localhost(), port, jn, false);
    }

    private static JMXServiceURL forRmiWithJndi(int port) {
        return JmxServiceUrlFactory.forRmiWithJndi(port, RMI_JSR160_CS_JNDI_SUFFIX);
    }

    public static JMXServiceURL forJmxmp(String host, int port) {
        JMXServiceURL url;
        if (host == null) {
            throw new IllegalArgumentException("Null Host");
        }
        try {
            url = new JMXServiceURL("jmxmp", host, port);
            String msg = "JMXServiceURL is: " + url;
            logger.fine(msg);
        }
        catch (MalformedURLException m) {
            url = null;
        }
        assert (url != null) : "Something seriously wrong, can't form the JMXServiceURL";
        return url;
    }

    public static JMXServiceURL forJmxmp(int port) {
        return JmxServiceUrlFactory.forJmxmp(JmxServiceUrlFactory.localhost(), port);
    }

    static String localhost() throws RuntimeException {
        String h;
        try {
            h = InetAddress.getLocalHost().getCanonicalHostName();
        }
        catch (UnknownHostException e) {
            h = "localhost";
        }
        return h;
    }

    private static String concat(String s1, String s2, String s3, String s4) {
        StringBuffer sb = new StringBuffer();
        if (s1 != null) {
            sb.append(s1);
        }
        if (s2 != null) {
            sb.append(s2);
        }
        if (s3 != null) {
            sb.append(s3);
        }
        if (s4 != null) {
            sb.append(s4);
        }
        return sb.toString();
    }
}

