/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.admingui.common.util;

import com.sun.appserv.management.DomainRoot;
import com.sun.appserv.management.base.AMX;
import com.sun.appserv.management.base.QueryMgr;
import com.sun.appserv.management.base.UploadDownloadMgr;
import com.sun.appserv.management.client.AMXBooter;
import com.sun.appserv.management.client.ProxyFactory;
import com.sun.appserv.management.config.AMXConfig;
import com.sun.appserv.management.config.ApplicationsConfig;
import com.sun.appserv.management.config.ClusteredServerConfig;
import com.sun.appserv.management.config.ClustersConfig;
import com.sun.appserv.management.config.ConfigConfig;
import com.sun.appserv.management.config.ConfigsConfig;
import com.sun.appserv.management.config.DomainConfig;
import com.sun.appserv.management.config.HTTPListenerConfig;
import com.sun.appserv.management.config.HTTPServiceConfig;
import com.sun.appserv.management.config.IIOPListenerConfig;
import com.sun.appserv.management.config.IIOPServiceConfig;
import com.sun.appserv.management.config.PropertiesAccess;
import com.sun.appserv.management.config.PropertyConfig;
import com.sun.appserv.management.config.ResourcesConfig;
import com.sun.appserv.management.config.ServersConfig;
import com.sun.appserv.management.config.StandaloneServerConfig;
import com.sun.appserv.management.ext.wsmgmt.WebServiceEndpointInfo;
import com.sun.appserv.management.ext.wsmgmt.WebServiceMgr;
import com.sun.appserv.management.j2ee.J2EEDomain;
import com.sun.appserv.management.j2ee.J2EEServer;
import com.sun.appserv.management.j2ee.StateManageable;
import com.sun.appserv.management.monitor.MonitoringRoot;
import com.sun.appserv.management.monitor.ServerRootMonitor;
import com.sun.appserv.management.util.misc.GSetUtil;
import com.sun.jsftemplating.layout.descriptors.handler.HandlerContext;
import java.lang.management.ManagementFactory;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javax.faces.context.FacesContext;
import javax.management.MBeanServer;
import javax.management.MBeanServerConnection;
import javax.servlet.ServletContext;
import org.glassfish.admingui.common.util.GuiUtil;
import org.glassfish.admingui.common.util.HtmlAdaptor;
import org.jvnet.hk2.component.Habitat;

public class AMXRoot {
    private static AMXRoot amxRoot = null;
    private final DomainRoot domainRoot;
    private final DomainConfig domainConfig;
    private final ApplicationsConfig applicationsConfig;
    private final ConfigsConfig configsConfig;
    private final J2EEDomain j2eeDomain;
    private final MonitoringRoot monitoringRoot;
    private final QueryMgr queryMgr;
    private final UploadDownloadMgr uploadDownloadMgr;
    private final WebServiceMgr webServiceMgr;
    private final MBeanServerConnection mbaenServerConnection;
    private final ResourcesConfig resourcesConfig;
    private final ServersConfig serversConfig;
    private final ClustersConfig clustersConfig;
    private final Set<String> APP_TYPES = GSetUtil.newUnmodifiableStringSet("X-J2EEApplicationConfig", "X-WebModuleConfig", "X-EJBModuleConfig", "X-LifecycleModuleConfig", "X-RARModuleConfig", "X-AppClientModuleConfig", "X-CustomMBeanConfig");
    private static final Map<Integer, String> stateImageMap = new HashMap<Integer, String>();
    private static final Map<Integer, String> stateMap;

    private AMXRoot(DomainRoot dd, MBeanServerConnection msc) {
        System.out.println("=========== In AMX Root constructor, DomainRoot  = " + dd);
        this.domainRoot = dd;
        this.domainConfig = dd.getDomainConfig();
        this.configsConfig = (ConfigsConfig)this.domainRoot.getQueryMgr().querySingletonJ2EEType("X-ConfigsConfig");
        this.j2eeDomain = this.domainRoot.getJ2EEDomain();
        this.monitoringRoot = this.domainRoot.getMonitoringRoot();
        this.queryMgr = this.domainRoot.getQueryMgr();
        this.uploadDownloadMgr = this.domainRoot.getUploadDownloadMgr();
        this.webServiceMgr = this.domainRoot.getWebServiceMgr();
        this.mbaenServerConnection = msc;
        this.resourcesConfig = this.domainConfig.getResourcesConfig();
        this.applicationsConfig = this.domainConfig.getApplicationsConfig();
        this.serversConfig = this.domainConfig.getServersConfig();
        this.clustersConfig = this.domainConfig.getClustersConfig();
    }

    public static AMXRoot getInstance() {
        if (amxRoot == null) {
            ServletContext servletCtx = (ServletContext)FacesContext.getCurrentInstance().getExternalContext().getContext();
            Habitat habitat = (Habitat)servletCtx.getAttribute("org.glassfish.servlet.habitat");
            MBeanServer mbs = habitat.getComponent(MBeanServer.class);
            if (mbs == null) {
                mbs = ManagementFactory.getPlatformMBeanServer();
            }
            if (mbs == null) {
                System.out.println("!!!!!!!!!!!!!!  Cannot get to MBeanServer");
            }
            AMXBooter.bootAMX(mbs);
            DomainRoot domainRoot = ProxyFactory.getInstance(mbs).getDomainRoot();
            domainRoot.waitAMXReady();
            amxRoot = new AMXRoot(domainRoot, mbs);
            HtmlAdaptor.registerHTMLAdaptor(mbs);
        }
        return amxRoot;
    }

    public MBeanServerConnection getMBeanServerConnection() {
        return this.mbaenServerConnection;
    }

    public DomainConfig getDomainConfig() {
        return this.domainConfig;
    }

    public ConfigsConfig getConfigsConfig() {
        return this.configsConfig;
    }

    public ResourcesConfig getResourcesConfig() {
        return this.resourcesConfig;
    }

    public ApplicationsConfig getApplicationsConfig() {
        return this.applicationsConfig;
    }

    public ServersConfig getServersConfig() {
        return this.serversConfig;
    }

    public ClustersConfig getClustersConfig() {
        return this.clustersConfig;
    }

    public J2EEDomain getJ2EEDomain() {
        return this.j2eeDomain;
    }

    public MonitoringRoot getMonitoringRoot() {
        return this.monitoringRoot;
    }

    public WebServiceMgr getWebServiceMgr() {
        return this.webServiceMgr;
    }

    public DomainRoot getDomainRoot() {
        return this.domainRoot;
    }

    public QueryMgr getQueryMgr() {
        return this.queryMgr;
    }

    public UploadDownloadMgr getUploadDownloadMgr() {
        return this.uploadDownloadMgr;
    }

    public ServerRootMonitor getServerRootMonitor(String instanceName) {
        if (GuiUtil.isEmpty(instanceName)) {
            return null;
        }
        return this.monitoringRoot.getServerRootMonitorMap().get(instanceName);
    }

    public ConfigConfig getConfig(String configName) {
        if (GuiUtil.isEmpty(configName)) {
            return null;
        }
        Map<String, ConfigConfig> cmap = this.configsConfig.getConfigConfigMap();
        ConfigConfig config = cmap.get(configName);
        return config;
    }

    public String getConfigName(String name) {
        Map<String, StandaloneServerConfig> sm = this.domainConfig.getServersConfig().getStandaloneServerConfigMap();
        Map<String, ClusteredServerConfig> cm = this.domainConfig.getServersConfig().getClusteredServerConfigMap();
        return "server-config";
    }

    public ConfigConfig getConfigByInstanceOrClusterName(String instanceName) {
        return this.getConfig(this.getConfigName(instanceName));
    }

    public HTTPListenerConfig getHTTPListenerConfig(String configName, String listenerName) {
        HTTPServiceConfig service;
        if (GuiUtil.isEmpty(configName) || GuiUtil.isEmpty(listenerName)) {
            return null;
        }
        ConfigConfig config = this.getConfig(configName);
        HTTPServiceConfig hTTPServiceConfig = service = config == null ? null : config.getHTTPServiceConfig();
        if (service != null) {
            Map<String, HTTPListenerConfig> listeners = service.getHTTPListenerConfigMap();
            HTTPListenerConfig listener = listeners.get(listenerName);
            return listener;
        }
        return null;
    }

    public IIOPListenerConfig getIIOPListenerConfig(String configName, String listenerName) {
        IIOPServiceConfig service;
        if (GuiUtil.isEmpty(configName) || GuiUtil.isEmpty(listenerName)) {
            return null;
        }
        ConfigConfig config = this.getConfig(configName);
        IIOPServiceConfig iIOPServiceConfig = service = config == null ? null : config.getIIOPServiceConfig();
        if (service != null) {
            Map<String, IIOPListenerConfig> listeners = service.getIIOPListenerConfigMap();
            IIOPListenerConfig listener = listeners.get(listenerName);
            return listener;
        }
        return null;
    }

    public boolean isEE() {
        return false;
    }

    public boolean supportCluster() {
        return false;
    }

    public void editProperties(HandlerContext handlerCtx, PropertiesAccess config) {
        Map addProps = (Map)handlerCtx.getInputValue("AddProps");
        ArrayList removeProps = (ArrayList)handlerCtx.getInputValue("RemoveProps");
        if (removeProps != null) {
            for (int i = 0; i < removeProps.size(); ++i) {
                config.removePropertyConfig((String)removeProps.get(i));
            }
        }
        if (addProps != null) {
            Map<String, PropertyConfig> pMap = config.getPropertyConfigMap();
            for (String key : addProps.keySet()) {
                String value = (String)addProps.get(key);
                if (pMap.containsKey(key)) {
                    pMap.get(key).setValue(value);
                    continue;
                }
                config.createPropertyConfig(key, value);
            }
        }
    }

    public WebServiceEndpointInfo getWebServiceEndpointInfo(Object webServiceKey) {
        return this.webServiceMgr.getWebServiceEndpointInfo(webServiceKey);
    }

    public String getAppType(String name) {
        Set applications = this.queryMgr.queryJ2EETypesSet(this.APP_TYPES);
        for (AMXConfig app : applications) {
            if (!app.getName().equals(name)) continue;
            return app.getJ2EEType();
        }
        return "";
    }

    public String getStatusForDisplay(AMX obj, boolean includeString) {
        boolean restart;
        if (!(obj instanceof StateManageable)) {
            return "";
        }
        int state = ((StateManageable)((Object)obj)).getstate();
        if (obj instanceof J2EEServer && state == 1 && (restart = ((J2EEServer)obj).getRestartRequired())) {
            String image = GuiUtil.getMessage("common.restartRequiredImage");
            return includeString ? image + "&nbsp;" + GuiUtil.getMessage("common.restartRequired") : image;
        }
        if (includeString) {
            return this.getStatusImage(state) + "&nbsp;" + this.getStatusString(state);
        }
        return this.getStatusImage(state);
    }

    public String getStatusImage(int state) {
        return stateImageMap.get(state);
    }

    public String getStatusString(int state) {
        return stateMap.get(state);
    }

    static {
        stateImageMap.put(4, GuiUtil.getMessage("common.failedImage"));
        stateImageMap.put(1, GuiUtil.getMessage("common.runningImage"));
        stateImageMap.put(0, GuiUtil.getMessage("common.startingImage"));
        stateImageMap.put(3, GuiUtil.getMessage("common.stoppedImage"));
        stateImageMap.put(2, GuiUtil.getMessage("common.stoppingImage"));
        stateMap = new HashMap<Integer, String>();
        stateMap.put(4, GuiUtil.getMessage("common.failedState"));
        stateMap.put(1, GuiUtil.getMessage("common.runningState"));
        stateMap.put(0, GuiUtil.getMessage("common.startingState"));
        stateMap.put(3, GuiUtil.getMessage("common.stoppedState"));
        stateMap.put(2, GuiUtil.getMessage("common.stoppingState"));
    }
}

