/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.deployment.client;

import com.sun.enterprise.admin.cli.remote.CLIRemoteCommand;
import com.sun.enterprise.util.LocalStringManagerImpl;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import java.net.URI;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import javax.enterprise.deploy.spi.Target;
import javax.enterprise.deploy.spi.TargetModuleID;
import javax.enterprise.deploy.spi.status.ClientConfiguration;
import org.glassfish.deployapi.ProgressObjectImpl;
import org.glassfish.deployapi.TargetImpl;
import org.glassfish.deployapi.TargetModuleIDImpl;
import org.glassfish.deployment.client.CommandXMLResultParser;
import org.glassfish.deployment.client.DFDeploymentStatus;
import org.glassfish.deployment.client.DFProgressObject;
import org.glassfish.deployment.client.DeploymentFacility;
import org.glassfish.deployment.client.ServerConnectionIdentifier;
import org.glassfish.deployment.client.TargetOwner;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RemoteDeploymentFacility
implements DeploymentFacility,
TargetOwner {
    private ServerConnectionIdentifier targetDAS;
    private File passwordFile;
    private TargetImpl domain;
    private boolean connected;
    private static final LocalStringManagerImpl localStrings = new LocalStringManagerImpl(RemoteDeploymentFacility.class);
    private static final String DEFAULT_SERVER_NAME = "server";

    @Override
    public boolean connect(ServerConnectionIdentifier targetDAS) {
        this.connected = true;
        this.targetDAS = targetDAS;
        this.passwordFile = this.preparePasswordFile();
        this.domain = new TargetImpl(this, "domain", localStrings.getLocalString("enterprise.deployment.client.administrative_domain", "administrative-domain"));
        return true;
    }

    @Override
    public boolean isConnected() {
        return this.connected;
    }

    @Override
    public boolean disconnect() {
        this.connected = false;
        this.passwordFile.delete();
        this.domain = null;
        this.targetDAS = null;
        return true;
    }

    @Override
    public DFProgressObject deploy(Target[] targets, URI source, URI deploymentPlan, Map deploymentOptions) {
        this.ensureConnected();
        targets = this.prepareTargets(targets);
        ProgressObjectImpl po = new ProgressObjectImpl(targets);
        if (source == null) {
            po.setupForAbnormalExit(localStrings.getLocalString("enterprise.deployment.client.archive_not_specified", "Archive to be deployed is not specified at all."), this.domain);
            return po;
        }
        File tmpFile = new File(source);
        if (!tmpFile.exists()) {
            po.setupForAbnormalExit(localStrings.getLocalString("enterprise.deployment.client.archive_not_in_location", "Unable to find the archive to be deployed in specified location."), this.domain);
            return po;
        }
        if (!tmpFile.canRead()) {
            po.setupForAbnormalExit(localStrings.getLocalString("enterprise.deployment.client.archive_no_read_permission", "Archive to be deployed does not have read permission."), this.domain);
            return po;
        }
        boolean isDirectoryDeploy = tmpFile.isDirectory();
        try {
            if (deploymentPlan != null) {
                deploymentOptions.put("deploymentplan", deploymentPlan);
            }
            String[] commandArgs = this.prepareRemoteCommandArguments("deploy", deploymentOptions, new String[]{tmpFile.getAbsolutePath()});
            ByteArrayOutputStream baos = new ByteArrayOutputStream(1024);
            CLIRemoteCommand rc = new CLIRemoteCommand(commandArgs, "xml-cli", baos);
            rc.runCommand();
            DFDeploymentStatus ds = CommandXMLResultParser.parse(new ByteArrayInputStream(baos.toByteArray()));
            DFDeploymentStatus mainStatus = ds.getMainStatus();
            if (mainStatus.getStatus() != DFDeploymentStatus.Status.FAILURE) {
                String moduleID = mainStatus.getProperty("name");
                TargetModuleIDImpl[] targetModuleIDs = new TargetModuleIDImpl[targets.length];
                int i = 0;
                for (TargetImpl ti : ProgressObjectImpl.toTargetImpl(targets)) {
                    targetModuleIDs[i++] = new TargetModuleIDImpl(ti, moduleID);
                }
                po.setupForNormalExit(localStrings.getLocalString("enterprise.deployment.client.deploy_application", "Deployment of application {0}", moduleID), this.domain, mainStatus, targetModuleIDs);
            } else {
                po.setupForAbnormalExit(localStrings.getLocalString("enterprise.deployment.client.deploy_application_failed", "Deployment of application failed - {0}", mainStatus.getStageStatusMessage()), this.domain, mainStatus);
            }
            return po;
        }
        catch (Throwable ioex) {
            po.setupForAbnormalExit(localStrings.getLocalString("enterprise.deployment.client.deploy_application_failed", "Deployment of application failed - {0} ", ioex.toString()), this.domain, ioex);
            return po;
        }
    }

    @Override
    public DFProgressObject undeploy(Target[] targets, String moduleID) {
        return this.undeploy(targets, moduleID, null);
    }

    @Override
    public DFProgressObject undeploy(Target[] targets, String moduleID, Map undeploymentOptions) {
        this.ensureConnected();
        targets = this.prepareTargets(targets);
        ProgressObjectImpl po = new ProgressObjectImpl(targets);
        try {
            String[] commandArgs = this.prepareRemoteCommandArguments("undeploy", undeploymentOptions, new String[]{moduleID});
            ByteArrayOutputStream baos = new ByteArrayOutputStream(1024);
            CLIRemoteCommand rc = new CLIRemoteCommand(commandArgs, "xml-cli", baos);
            rc.runCommand();
            DFDeploymentStatus ds = CommandXMLResultParser.parse(new ByteArrayInputStream(baos.toByteArray()));
            DFDeploymentStatus mainStatus = ds.getMainStatus();
            if (mainStatus.getStatus() != DFDeploymentStatus.Status.FAILURE) {
                TargetModuleIDImpl[] targetModuleIDs = new TargetModuleIDImpl[targets.length];
                int i = 0;
                for (TargetImpl ti : ProgressObjectImpl.toTargetImpl(targets)) {
                    targetModuleIDs[i++] = new TargetModuleIDImpl(ti, moduleID);
                }
                po.setupForNormalExit(localStrings.getLocalString("enterprise.deployment.client.undeploy_application", "Undeployment of application {0}", moduleID), this.domain, mainStatus, targetModuleIDs);
            } else {
                po.setupForAbnormalExit(localStrings.getLocalString("enterprise.deployment.client.undeploy_application_failed", "Undeployment failed - {0} ", mainStatus.getStageStatusMessage()), this.domain, mainStatus);
            }
            return po;
        }
        catch (Throwable ioex) {
            po.setupForAbnormalExit(localStrings.getLocalString("enterprise.deployment.client.undeploy_application_failed", "Undeployment failed - {0} ", ioex.toString()), this.domain, ioex);
            return po;
        }
    }

    private DFProgressObject changeState(Target[] targets, String moduleID, String commandName, String successStatusKey, String successStatusDefaultMessage, String failureStatusKey, String failureStatusDefaultMessage) {
        this.ensureConnected();
        targets = this.prepareTargets(targets);
        ProgressObjectImpl po = new ProgressObjectImpl(targets);
        try {
            String[] commandArgs = this.prepareRemoteCommandArguments(commandName, null, new String[]{moduleID});
            ByteArrayOutputStream baos = new ByteArrayOutputStream(1024);
            CLIRemoteCommand rc = new CLIRemoteCommand(commandArgs, "xml-cli", baos);
            rc.runCommand();
            DFDeploymentStatus ds = CommandXMLResultParser.parse(new ByteArrayInputStream(baos.toByteArray()));
            DFDeploymentStatus mainStatus = ds.getMainStatus();
            if (mainStatus.getStatus() != DFDeploymentStatus.Status.FAILURE) {
                TargetModuleIDImpl[] targetModuleIDs = new TargetModuleIDImpl[targets.length];
                int i = 0;
                for (TargetImpl ti : ProgressObjectImpl.toTargetImpl(targets)) {
                    targetModuleIDs[i++] = new TargetModuleIDImpl(ti, moduleID);
                }
                po.setupForNormalExit(localStrings.getLocalString(successStatusKey, successStatusDefaultMessage, moduleID), this.domain, mainStatus, targetModuleIDs);
            } else {
                po.setupForAbnormalExit(localStrings.getLocalString(failureStatusKey, failureStatusDefaultMessage, mainStatus.getStageStatusMessage()), this.domain, mainStatus);
            }
            return po;
        }
        catch (Throwable ioex) {
            po.setupForAbnormalExit(localStrings.getLocalString(failureStatusKey, failureStatusDefaultMessage, ioex.toString()), this.domain, ioex);
            return po;
        }
    }

    @Override
    public DFProgressObject enable(Target[] targets, String moduleID) {
        return this.changeState(targets, moduleID, "enable", "enterprise.deployment.client.enable_application", "Application {0} enabled successfully", "enterprise.deployment.client.enable_application_failed", "Attempt to enable application {0} failed");
    }

    @Override
    public DFProgressObject disable(Target[] targets, String moduleID) {
        return this.changeState(targets, moduleID, "disable", "enterprise.deployment.client.disable_application", "Application {0} disabled successfully", "enterprise.deployment.client.disable_application_failed", "Attempt to disable application {0} failed");
    }

    @Override
    public DFProgressObject createAppRef(Target[] targets, String moduleID, Map options) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public DFProgressObject deleteAppRef(Target[] targets, String moduleID, Map options) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public TargetModuleID[] listAppRefs(String[] targets) throws IOException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public String downloadFile(File location, String moduleID, String moduleURI) throws IOException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public DFDeploymentStatus waitFor(DFProgressObject po) {
        return po.waitFor();
    }

    @Override
    public Target[] createTargets(String[] targets) {
        Target[] result = new TargetImpl[targets.length];
        int i = 0;
        for (String name : targets) {
            result[i++] = new TargetImpl(this, name, "");
        }
        return result;
    }

    @Override
    public Target createTarget(String name) {
        return new TargetImpl(this, name, "");
    }

    @Override
    public ClientConfiguration getClientConfiguration(TargetModuleID targetModuleID) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public String getWebURL(TargetModuleID tmid) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    private void ensureConnected() {
        if (!this.isConnected()) {
            throw new IllegalStateException(localStrings.getLocalString("enterprise.deployment.client.disconnected_state", "Not connected to the Domain Admin Server"));
        }
    }

    protected String[] prepareRemoteCommandArguments(String commandName, Map<String, String> options, String[] operands) {
        ArrayList<String> result = new ArrayList<String>();
        result.add(commandName);
        if (options == null) {
            options = new HashMap<String, String>();
        }
        for (Map.Entry<String, String> entry : options.entrySet()) {
            result.add("--" + entry.getKey() + "=" + entry.getValue());
        }
        if (this.targetDAS.isSecure()) {
            result.add("--secure");
        }
        result.add("--host=" + this.targetDAS.getHostName());
        result.add("--port=" + this.targetDAS.getHostPort());
        result.add("--user=" + this.targetDAS.getUserName());
        result.add("--passwordfile=" + this.passwordFile.getAbsolutePath());
        for (String o : operands) {
            result.add(o);
        }
        return result.toArray(new String[result.size()]);
    }

    private File preparePasswordFile() {
        File pwFile = null;
        try {
            pwFile = File.createTempFile("rdf", ".dat");
            PrintStream ps = new PrintStream(pwFile);
            ps.println("AS_ADMIN_PASSWORD=" + this.targetDAS.getPassword());
            ps.close();
            return pwFile;
        }
        catch (IOException ex) {
            if (pwFile != null) {
                pwFile.delete();
            }
            throw new RuntimeException(ex);
        }
    }

    private Target[] prepareTargets(Target[] targets) {
        if (targets == null || targets.length == 0) {
            targets = new Target[]{this.targetForDefaultServer()};
        }
        return targets;
    }

    private Target targetForDefaultServer() {
        TargetImpl t = new TargetImpl(this, DEFAULT_SERVER_NAME, localStrings.getLocalString("enterprise.deployment.client.default_server_description", "default server"));
        return t;
    }
}

