/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.jdbc.admin.cli;

import com.sun.enterprise.config.serverbeans.JdbcConnectionPool;
import com.sun.enterprise.util.LocalStringManagerImpl;
import java.util.ArrayList;
import org.glassfish.api.ActionReport;
import org.glassfish.api.I18n;
import org.glassfish.api.admin.AdminCommand;
import org.glassfish.api.admin.AdminCommandContext;
import org.glassfish.jdbc.admin.cli.JDBCConnectionPoolManager;
import org.jvnet.hk2.annotations.Inject;
import org.jvnet.hk2.annotations.Scoped;
import org.jvnet.hk2.annotations.Service;
import org.jvnet.hk2.component.PerLookup;

@Service(name="list-jdbc-connection-pools")
@Scoped(value=PerLookup.class)
@I18n(value="list.jdbc.connection.pools")
public class ListJdbcConnectionPools
implements AdminCommand {
    private static final LocalStringManagerImpl localStrings = new LocalStringManagerImpl(ListJdbcConnectionPools.class);
    @Inject
    JdbcConnectionPool[] connPools;

    public void execute(AdminCommandContext context) {
        ActionReport report = context.getActionReport();
        try {
            JDBCConnectionPoolManager connPoolMgr = new JDBCConnectionPoolManager();
            ArrayList list = connPoolMgr.list(this.connPools);
            for (String cpName : list) {
                ActionReport.MessagePart part = report.getTopMessagePart().addChild();
                part.setMessage(cpName);
            }
        }
        catch (Exception e) {
            report.setMessage(localStrings.getLocalString("list.jdbc.connection.pools.failed", "List JDBC connection pools failed"));
            report.setActionExitCode(ActionReport.ExitCode.FAILURE);
            report.setFailureCause(e);
            return;
        }
        report.setActionExitCode(ActionReport.ExitCode.SUCCESS);
    }
}

