/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.persistence.jpa;

import java.io.IOException;
import java.io.InputStream;
import java.lang.annotation.Annotation;
import java.util.Enumeration;
import javax.persistence.PersistenceContext;
import javax.persistence.PersistenceContexts;
import javax.persistence.PersistenceUnit;
import javax.persistence.PersistenceUnits;
import org.glassfish.api.container.Sniffer;
import org.glassfish.api.deployment.archive.ReadableArchive;
import org.glassfish.internal.deployment.GenericSniffer;
import org.jvnet.hk2.annotations.Scoped;
import org.jvnet.hk2.annotations.Service;
import org.jvnet.hk2.component.Singleton;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Service(name="jpa")
@Scoped(value=Singleton.class)
public class JPASniffer
extends GenericSniffer
implements Sniffer {
    private static final String[] containers = new String[]{"org.glassfish.persistence.jpa.JPAContainer"};
    private static final Class[] handledAnnotations = new Class[]{PersistenceContext.class, PersistenceContexts.class, PersistenceUnit.class, PersistenceUnits.class};

    public JPASniffer() {
        super("jpa", null, null);
    }

    @Override
    public boolean handles(ReadableArchive location, ClassLoader loader) {
        boolean isJPAArchive = false;
        isJPAArchive = this.isEntryPresent(location, "WEB-INF/classes/META-INF/persistence.xml");
        if (!isJPAArchive) {
            Enumeration<String> entries = location.entries("WEB-INF/lib");
            while (entries.hasMoreElements() && !isJPAArchive) {
                String entryName = entries.nextElement();
                if (!entryName.endsWith(".jar")) continue;
                try {
                    ReadableArchive jarInLib = location.getSubArchive(entryName);
                    isJPAArchive = this.isEntryPresent(jarInLib, "META-INF/persistence.xml");
                    jarInLib.close();
                }
                catch (IOException e) {}
            }
        }
        return isJPAArchive;
    }

    public boolean isEntryPresent(ReadableArchive location, String entry) {
        boolean entryPresent = false;
        try {
            InputStream is = location.getEntry(entry);
            if (is != null) {
                is.close();
                entryPresent = true;
            }
        }
        catch (IOException e) {
            // empty catch block
        }
        return entryPresent;
    }

    @Override
    public Class<? extends Annotation>[] getAnnotationTypes() {
        return handledAnnotations;
    }

    @Override
    public String[] getContainersNames() {
        return containers;
    }
}

