/*
 * Decompiled with CFR 0.152.
 */
package com.sun.appserv.management.util.jmx;

import com.sun.appserv.management.util.jmx.AttributeFilter;
import com.sun.appserv.management.util.jmx.MBeanAttributeInfoComparator;
import com.sun.appserv.management.util.jmx.MBeanOperationInfoComparator;
import com.sun.appserv.management.util.jmx.stringifier.ObjectNameStringifier;
import com.sun.appserv.management.util.misc.ArrayConversion;
import com.sun.appserv.management.util.misc.ArrayUtil;
import com.sun.appserv.management.util.misc.GSetUtil;
import com.sun.appserv.management.util.misc.MapUtil;
import com.sun.appserv.management.util.misc.RegexUtil;
import com.sun.appserv.management.util.misc.TypeCast;
import com.sun.appserv.management.util.stringifier.SmartStringifier;
import java.io.IOException;
import java.io.Serializable;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import javax.management.Attribute;
import javax.management.AttributeChangeNotification;
import javax.management.AttributeList;
import javax.management.AttributeNotFoundException;
import javax.management.InstanceNotFoundException;
import javax.management.IntrospectionException;
import javax.management.MBeanAttributeInfo;
import javax.management.MBeanConstructorInfo;
import javax.management.MBeanException;
import javax.management.MBeanFeatureInfo;
import javax.management.MBeanInfo;
import javax.management.MBeanNotificationInfo;
import javax.management.MBeanOperationInfo;
import javax.management.MBeanParameterInfo;
import javax.management.MBeanRegistrationException;
import javax.management.MBeanServer;
import javax.management.MBeanServerConnection;
import javax.management.MBeanServerDelegateMBean;
import javax.management.MBeanServerInvocationHandler;
import javax.management.MalformedObjectNameException;
import javax.management.Notification;
import javax.management.NotificationFilter;
import javax.management.NotificationListener;
import javax.management.ObjectName;
import javax.management.QueryExp;
import javax.management.ReflectionException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class JMXUtil {
    public static final String MBEAN_SERVER_DELEGATE = "JMImplementation:type=MBeanServerDelegate";
    public static final String MBEAN_SERVER_ID_ATTRIBUTE_NAME = "MBeanServerId";
    public static final String WILD_PROP = ",*";
    public static final String WILD_ALL = "*";
    public static final String GET = "get";
    public static final String SET = "set";
    public static final String IS = "is";

    public static MBeanServerDelegateMBean getMBeanServerDelegateMBean(MBeanServerConnection server) {
        MBeanServerDelegateMBean delegate = (MBeanServerDelegateMBean)MBeanServerDelegateMBean.class.cast(MBeanServerInvocationHandler.newProxyInstance(server, JMXUtil.newObjectName(MBEAN_SERVER_DELEGATE), MBeanServerDelegateMBean.class, true));
        return delegate;
    }

    public static ObjectName getMBeanServerDelegateObjectName() {
        return JMXUtil.newObjectName(MBEAN_SERVER_DELEGATE);
    }

    public static String getMBeanServerDelegateInfo(MBeanServer server) {
        MBeanServerDelegateMBean delegate = JMXUtil.getMBeanServerDelegateMBean(server);
        String mbeanServerInfo = "MBeanServerDelegate: {MBeanServerId = " + delegate.getMBeanServerId() + ", ImplementationMame = " + delegate.getImplementationName() + ", ImplementationVendor = " + delegate.getImplementationVendor() + ", ImplementationVersion = " + delegate.getImplementationVersion() + ", SpecificationName = " + delegate.getSpecificationName() + ", SpecificationVendor = " + delegate.getSpecificationVendor() + ", SpecificationVersion = " + delegate.getSpecificationVersion() + " }";
        return mbeanServerInfo;
    }

    public static void listenToMBeanServerDelegate(MBeanServerConnection conn, NotificationListener listener, NotificationFilter filter, Object handback) throws IOException, InstanceNotFoundException {
        conn.addNotificationListener(JMXUtil.getMBeanServerDelegateObjectName(), listener, filter, handback);
    }

    public static String getMBeanServerID(MBeanServerConnection conn) throws IOException, ReflectionException, InstanceNotFoundException, AttributeNotFoundException, MBeanException {
        return (String)conn.getAttribute(JMXUtil.getMBeanServerDelegateObjectName(), MBEAN_SERVER_ID_ATTRIBUTE_NAME);
    }

    public static ObjectName newObjectName(String name) {
        try {
            return new ObjectName(name);
        }
        catch (Exception e) {
            throw new RuntimeException(e.getMessage(), e);
        }
    }

    public static ObjectName newObjectName(ObjectName objectName, String props) {
        String domain = objectName.getDomain();
        String existingProps = objectName.getKeyPropertyListString();
        String allProps = JMXUtil.concatenateProps(existingProps, props);
        return JMXUtil.newObjectName(domain, allProps);
    }

    public static ObjectName newObjectName(String domain, String props) {
        return JMXUtil.newObjectName(domain + ":" + props);
    }

    public static ObjectName newObjectNamePattern(String domain, String props) {
        String actualProps = null;
        actualProps = props.endsWith(WILD_PROP) || props.equals(WILD_ALL) ? props : (props.length() == 0 ? WILD_ALL : props + WILD_PROP);
        return JMXUtil.newObjectName(domain + ":" + actualProps);
    }

    public static ObjectName newObjectNamePattern(String domain, Map<String, String> props) {
        String propsString = JMXUtil.mapToProps(props);
        return JMXUtil.newObjectNamePattern(domain, propsString);
    }

    public static String mapToProps(Map<String, String> propsMap) {
        return MapUtil.toString(propsMap, ",");
    }

    public static ObjectName removeProperty(ObjectName objectName, String key) {
        ObjectName nameWithoutKey = objectName;
        if (objectName.getKeyProperty(key) != null) {
            String domain = objectName.getDomain();
            Hashtable<String, String> props = TypeCast.asHashtable(objectName.getKeyPropertyList());
            props.remove(key);
            if (objectName.isPropertyPattern()) {
                String propsString = JMXUtil.mapToProps(props);
                nameWithoutKey = JMXUtil.newObjectNamePattern(domain, nameWithoutKey.getKeyPropertyListString());
            } else {
                try {
                    nameWithoutKey = new ObjectName(domain, props);
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }
        }
        return nameWithoutKey;
    }

    private JMXUtil() {
    }

    public static String makeProp(String name, String value) {
        return name + "=" + value;
    }

    public static String concatenateProps(String props1, String props2) {
        String result = null;
        result = props1.length() == 0 ? props2 : (props2.length() == 0 ? props1 : props1 + "," + props2);
        return result;
    }

    public static String concatenateProps(String props1, String props2, String props3) {
        return JMXUtil.concatenateProps(JMXUtil.concatenateProps(props1, props2), props3);
    }

    public static ObjectName[] objectNameSetToArray(Set<ObjectName> objectNameSet) {
        ObjectName[] objectNames = new ObjectName[objectNameSet.size()];
        objectNameSet.toArray(objectNames);
        return objectNames;
    }

    public static String[] getKeyProperty(String key, ObjectName[] objectNames) {
        String[] values = new String[objectNames.length];
        for (int i = 0; i < objectNames.length; ++i) {
            values[i] = objectNames[i].getKeyProperty(key);
        }
        return values;
    }

    public static String getProp(ObjectName objectName, String key) {
        String value = objectName.getKeyProperty(key);
        if (value == null) {
            return null;
        }
        return JMXUtil.makeProp(key, value);
    }

    public static String getProps(ObjectName objectName, Set<String> propKeys) {
        return JMXUtil.getProps(objectName, propKeys, false);
    }

    public static String getProps(ObjectName objectName, Set<String> propKeys, boolean ignoreMissing) {
        String props = "";
        for (String key : propKeys) {
            String pair = JMXUtil.getProp(objectName, key);
            if (pair != null) {
                props = JMXUtil.concatenateProps(props, pair);
                continue;
            }
            if (ignoreMissing) continue;
            throw new IllegalArgumentException("key not found: " + key + " in " + objectName);
        }
        return props;
    }

    public static String[] getKeyProperty(String key, Set<ObjectName> objectNameSet) {
        ObjectName[] objectNames = JMXUtil.objectNameSetToArray(objectNameSet);
        return JMXUtil.getKeyProperty(key, objectNames);
    }

    public static Set<String> getKeyPropertySet(String key, Set<ObjectName> objectNameSet) {
        ObjectName[] objectNames = JMXUtil.objectNameSetToArray(objectNameSet);
        String[] values = JMXUtil.getKeyProperty(key, objectNames);
        return ArrayConversion.arrayToSet(values);
    }

    public static String findKey(Set<String> candidateKeys, ObjectName objectName) {
        Iterator<String> iter = candidateKeys.iterator();
        String match = null;
        while (iter.hasNext()) {
            String key = iter.next();
            if (objectName.getKeyProperty(key) == null) continue;
            match = key;
            break;
        }
        return match;
    }

    public static Set<ObjectName> findByProperty(Set<ObjectName> objectNames, String propertyKey, String propertyValue) {
        HashSet<ObjectName> result = new HashSet<ObjectName>();
        for (ObjectName objectName : objectNames) {
            String value = objectName.getKeyProperty(propertyKey);
            if (!propertyValue.equals(value)) continue;
            result.add(objectName);
        }
        return result;
    }

    public static ObjectName setKeyProperty(ObjectName objectName, String key, String value) {
        String domain = objectName.getDomain();
        Hashtable<String, String> props = TypeCast.asHashtable(objectName.getKeyPropertyList());
        props.put(key, value);
        ObjectName newObjectName = null;
        try {
            newObjectName = new ObjectName(domain, props);
        }
        catch (MalformedObjectNameException e) {
            throw new RuntimeException(e);
        }
        return newObjectName;
    }

    private static String toString(Object o) {
        return SmartStringifier.toString(o);
    }

    public static void unregisterAll(MBeanServerConnection conn, Set<ObjectName> allNames) throws IOException, MalformedObjectNameException, MBeanRegistrationException {
        for (ObjectName name : allNames) {
            try {
                conn.unregisterMBean(name);
            }
            catch (Exception e) {}
        }
    }

    public static void unregisterAll(MBeanServerConnection conn) throws IOException, MalformedObjectNameException, MBeanRegistrationException {
        JMXUtil.unregisterAll(conn, JMXUtil.queryNames(conn, new ObjectName("*:*"), null));
    }

    public static String[] getAllAttributeNames(MBeanServerConnection conn, ObjectName objectName) throws IOException, ReflectionException, IntrospectionException, InstanceNotFoundException {
        return JMXUtil.getAttributeNames(JMXUtil.getAttributeInfos(conn, objectName));
    }

    public static MBeanAttributeInfo[] filterAttributeInfos(MBeanAttributeInfo[] infos, AttributeFilter filter) {
        ArrayList<MBeanAttributeInfo> matches = new ArrayList<MBeanAttributeInfo>();
        for (int i = 0; i < infos.length; ++i) {
            if (!filter.filterAttribute(infos[i])) continue;
            matches.add(infos[i]);
        }
        MBeanAttributeInfo[] results = new MBeanAttributeInfo[matches.size()];
        matches.toArray(results);
        return results;
    }

    public static String[] getAttributeNames(MBeanAttributeInfo[] infos) {
        String[] names = new String[infos.length];
        for (int i = 0; i < infos.length; ++i) {
            names[i] = infos[i].getName();
        }
        return names;
    }

    public static MBeanAttributeInfo getMBeanAttributeInfo(MBeanAttributeInfo[] infos, String attrName) {
        MBeanAttributeInfo info = null;
        for (int i = 0; i < infos.length; ++i) {
            if (!infos[i].getName().equals(attrName)) continue;
            info = infos[i];
            break;
        }
        return info;
    }

    public static MBeanAttributeInfo getMBeanAttributeInfo(MBeanInfo mbeanInfo, String attrName) {
        return JMXUtil.getMBeanAttributeInfo(mbeanInfo.getAttributes(), attrName);
    }

    public static MBeanAttributeInfo[] getAttributeInfos(MBeanServerConnection conn, ObjectName objectName) throws IOException, ReflectionException, IntrospectionException, InstanceNotFoundException {
        MBeanAttributeInfo[] infos = conn.getMBeanInfo(objectName).getAttributes();
        return infos;
    }

    public static Map<String, Attribute> attributeListToAttributeMap(AttributeList attrs) {
        HashMap<String, Attribute> map = new HashMap<String, Attribute>();
        for (int i = 0; i < attrs.size(); ++i) {
            Attribute attr = (Attribute)attrs.get(i);
            map.put(attr.getName(), attr);
        }
        return map;
    }

    public static Map<String, Object> attributeListToValueMap(AttributeList attrs) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        for (int i = 0; i < attrs.size(); ++i) {
            Attribute attr = (Attribute)attrs.get(i);
            Object value = attr.getValue();
            map.put(attr.getName(), value);
        }
        return map;
    }

    public static Map<String, String> attributeListToStringMap(AttributeList attrs) {
        HashMap<String, String> map = new HashMap<String, String>();
        for (int i = 0; i < attrs.size(); ++i) {
            Attribute attr = (Attribute)attrs.get(i);
            Object value = attr.getValue();
            String s = (String)(value == null ? value : "" + value);
            map.put(attr.getName(), s);
        }
        return map;
    }

    public static Map<String, MBeanAttributeInfo> attributeInfosToMap(MBeanAttributeInfo[] attrInfos) {
        HashMap<String, MBeanAttributeInfo> map = new HashMap<String, MBeanAttributeInfo>();
        for (int i = 0; i < attrInfos.length; ++i) {
            MBeanAttributeInfo attrInfo = attrInfos[i];
            map.put(attrInfo.getName(), attrInfo);
        }
        return map;
    }

    public static MBeanInfo removeAttributes(MBeanInfo origInfo, String[] attributeNames) {
        MBeanInfo result = origInfo;
        if (attributeNames.length != 0) {
            Map<String, MBeanAttributeInfo> infos = JMXUtil.attributeInfosToMap(origInfo.getAttributes());
            for (int i = 0; i < attributeNames.length; ++i) {
                infos.remove(attributeNames[i]);
            }
            MBeanAttributeInfo[] newInfos = new MBeanAttributeInfo[infos.keySet().size()];
            infos.values().toArray(newInfos);
            result = new MBeanInfo(origInfo.getClassName(), origInfo.getDescription(), newInfos, origInfo.getConstructors(), origInfo.getOperations(), origInfo.getNotifications());
        }
        return result;
    }

    public static Set<MBeanFeatureInfo> findInfoByName(MBeanFeatureInfo[] infos, String name) {
        HashSet<MBeanFeatureInfo> s = new HashSet<MBeanFeatureInfo>();
        for (int i = 0; i < infos.length; ++i) {
            MBeanFeatureInfo info = infos[i];
            if (!info.getName().equals(name)) continue;
            s.add(info);
        }
        return s;
    }

    public static AttributeList mapToAttributeList(Map<String, Object> m) {
        AttributeList attrList = new AttributeList();
        for (String key : m.keySet()) {
            Object value = m.get(key);
            Attribute attr = new Attribute(key, value);
            attrList.add(attr);
        }
        return attrList;
    }

    public static List<String> objectNamesToStrings(Collection<ObjectName> objectNames) {
        ArrayList<String> result = new ArrayList<String>();
        for (ObjectName objectName : objectNames) {
            result.add(ObjectNameStringifier.DEFAULT.stringify(objectName));
        }
        return result;
    }

    public static String[] objectNamesToStrings(ObjectName[] objectNames) {
        String[] strings = new String[objectNames.length];
        for (int i = 0; i < strings.length; ++i) {
            strings[i] = ObjectNameStringifier.DEFAULT.stringify(objectNames[i]);
        }
        return strings;
    }

    private static boolean connectionIsDead(MBeanServerConnection conn) {
        boolean isDead = false;
        try {
            conn.isRegistered(new ObjectName(MBEAN_SERVER_DELEGATE));
        }
        catch (MalformedObjectNameException e) {
            assert (false);
        }
        catch (IOException e) {
            isDead = true;
        }
        return isDead;
    }

    private static AttributeList getAttributesSingly(MBeanServerConnection conn, ObjectName objectName, String[] attrNames, Set<String> problemNames) throws InstanceNotFoundException {
        AttributeList attrs = new AttributeList();
        for (int i = 0; i < attrNames.length; ++i) {
            String name = attrNames[i];
            try {
                Object value = conn.getAttribute(objectName, name);
                attrs.add(new Attribute(name, value));
                continue;
            }
            catch (Exception e) {
                if (e instanceof InstanceNotFoundException) {
                    throw (InstanceNotFoundException)e;
                }
                if (problemNames == null) continue;
                problemNames.add(name);
            }
        }
        return attrs;
    }

    public static AttributeList getAttributesRobust(MBeanServerConnection conn, ObjectName objectName, String[] attrNames, Set<String> problemNames) throws InstanceNotFoundException, IOException {
        AttributeList attrs = null;
        if (problemNames != null) {
            problemNames.clear();
        }
        try {
            attrs = conn.getAttributes(objectName, attrNames);
            if (attrs == null) {
                attrs = new AttributeList();
            }
        }
        catch (InstanceNotFoundException e) {
            throw e;
        }
        catch (IOException e) {
            if (JMXUtil.connectionIsDead(conn)) {
                throw e;
            }
            attrs = JMXUtil.getAttributesSingly(conn, objectName, attrNames, problemNames);
        }
        catch (Exception e) {
            attrs = JMXUtil.getAttributesSingly(conn, objectName, attrNames, problemNames);
        }
        return attrs;
    }

    boolean sameAttributes(MBeanAttributeInfo[] infos1, MBeanAttributeInfo[] infos2) {
        boolean equal = false;
        if (infos1.length == infos2.length) {
            equal = ArrayUtil.arraysEqual(infos1, infos2);
            if (!equal) {
                Arrays.sort(infos1, MBeanAttributeInfoComparator.INSTANCE);
                Arrays.sort(infos2, MBeanAttributeInfoComparator.INSTANCE);
                equal = true;
                for (int i = 0; i < infos1.length; ++i) {
                    if (infos1[i].equals(infos2[i])) continue;
                    equal = false;
                    break;
                }
            } else {
                equal = true;
            }
        }
        return equal;
    }

    boolean sameOperations(MBeanOperationInfo[] infos1, MBeanOperationInfo[] infos2) {
        boolean equal = false;
        if (infos1.length == infos2.length && !(equal = ArrayUtil.arraysEqual(infos1, infos2))) {
            Arrays.sort(infos1, MBeanOperationInfoComparator.INSTANCE);
            Arrays.sort(infos2, MBeanOperationInfoComparator.INSTANCE);
            equal = true;
            for (int i = 0; i < infos1.length; ++i) {
                if (infos1[i].equals(infos2[i])) continue;
                equal = false;
                break;
            }
        }
        return equal;
    }

    boolean sameInterface(MBeanInfo info1, MBeanInfo info2) {
        return this.sameAttributes(info1.getAttributes(), info2.getAttributes()) && this.sameOperations(info1.getOperations(), info2.getOperations());
    }

    public static boolean isIs(Method method) {
        return method.getName().startsWith(IS) && method.getParameterTypes().length == 0;
    }

    public static boolean isGetter(Method method) {
        return method.getName().startsWith(GET) && method.getParameterTypes().length == 0;
    }

    public static boolean isGetter(MBeanOperationInfo info) {
        return info.getName().startsWith(GET) && info.getSignature().length == 0 && !info.getReturnType().equals("void");
    }

    public static MBeanOperationInfo[] findOperations(MBeanOperationInfo[] operations, String operationName) {
        HashSet<MBeanOperationInfo> items = new HashSet<MBeanOperationInfo>();
        for (int i = 0; i < operations.length; ++i) {
            if (!operations[i].getName().equals(operationName)) continue;
            items.add(operations[i]);
        }
        MBeanOperationInfo[] itemsArray = new MBeanOperationInfo[items.size()];
        items.toArray(itemsArray);
        return itemsArray;
    }

    public static MBeanOperationInfo findOperation(MBeanOperationInfo[] operations, String operationName, String[] types) {
        MBeanOperationInfo result = null;
        block0: for (int i = 0; i < operations.length; ++i) {
            MBeanParameterInfo[] sig;
            MBeanOperationInfo info = operations[i];
            if (!info.getName().equals(operationName) || (sig = info.getSignature()).length != types.length) continue;
            result = info;
            for (int j = 0; j < sig.length; ++j) {
                if (types[j].equals(sig[j].getType())) continue;
                result = null;
                continue block0;
            }
        }
        return result;
    }

    public static boolean isIsOrGetter(Method method) {
        return JMXUtil.isGetter(method) || JMXUtil.isIs(method);
    }

    public static String getAttributeName(Method method) {
        String methodName = method.getName();
        Object attrName = null;
        int prefixLength = 0;
        prefixLength = methodName.startsWith(GET) || methodName.startsWith(SET) ? 3 : 2;
        return methodName.substring(prefixLength, methodName.length());
    }

    public static boolean isSetter(Method method) {
        return method.getName().startsWith(SET) && method.getParameterTypes().length == 1 && method.getParameterTypes()[0] != Attribute.class && method.getReturnType().getName().equals("void");
    }

    public static boolean isGetAttribute(Method m) {
        return m.getName().equals("getAttribute") && m.getParameterTypes().length == 1 && m.getParameterTypes()[0] == String.class;
    }

    public static boolean isGetAttributes(Method m) {
        return m.getName().equals("getAttributes") && m.getParameterTypes().length == 1 && m.getParameterTypes()[0] == String[].class;
    }

    public static boolean isSetAttribute(Method m) {
        return m.getName().equals("setAttribute") && m.getParameterTypes().length == 1 && m.getParameterTypes()[0] == Attribute.class;
    }

    public static boolean isSetAttributes(Method m) {
        return m.getName().equals("setAttributes") && m.getParameterTypes().length == 1 && m.getParameterTypes()[0] == AttributeList.class;
    }

    public static ArrayList<MBeanAttributeInfo> generateAttributeInfos(Collection<Method> methodSet, boolean read, boolean write) {
        ArrayList<MBeanAttributeInfo> infos = new ArrayList<MBeanAttributeInfo>();
        assert (methodSet != null);
        for (Method m : methodSet) {
            String methodName = m.getName();
            assert (read || write && methodName.startsWith(SET));
            MBeanAttributeInfo info = new MBeanAttributeInfo(JMXUtil.getAttributeName(m), m.getReturnType().getName(), methodName, read, write, methodName.startsWith(IS));
            infos.add(info);
        }
        return infos;
    }

    public static MBeanAttributeInfo[] generateMBeanAttributeInfos(Collection<Method> getterSetters, Collection<Method> getters, Collection<Method> setters) {
        ArrayList<MBeanAttributeInfo> attrsList = new ArrayList<MBeanAttributeInfo>();
        attrsList.addAll(JMXUtil.generateAttributeInfos(getterSetters, true, true));
        attrsList.addAll(JMXUtil.generateAttributeInfos(getters, true, false));
        attrsList.addAll(JMXUtil.generateAttributeInfos(setters, false, true));
        MBeanAttributeInfo[] attrs = new MBeanAttributeInfo[attrsList.size()];
        attrsList.toArray(attrs);
        return attrs;
    }

    public static String[] getSignature(MBeanParameterInfo[] infos) {
        String[] sig = new String[infos.length];
        int i = 0;
        for (MBeanParameterInfo info : infos) {
            sig[i] = info.getType();
            ++i;
        }
        return sig;
    }

    public static MBeanParameterInfo[] generateSignature(Class[] sig) {
        MBeanParameterInfo[] infos = new MBeanParameterInfo[sig.length];
        for (int i = 0; i < sig.length; ++i) {
            MBeanParameterInfo info;
            Class paramClass = sig[i];
            String name = "p" + i;
            String type = paramClass.getName();
            String description = paramClass.getName();
            infos[i] = info = new MBeanParameterInfo(name, type, description);
        }
        return infos;
    }

    public static MBeanOperationInfo[] generateMBeanOperationInfos(Collection<Method> methodSet) {
        MBeanOperationInfo[] infos = new MBeanOperationInfo[methodSet.size()];
        Iterator<Method> iter = methodSet.iterator();
        int i = 0;
        while (iter.hasNext()) {
            MBeanOperationInfo info;
            Method m = iter.next();
            String methodName = m.getName();
            infos[i] = info = new MBeanOperationInfo(methodName, methodName, JMXUtil.generateSignature(m.getParameterTypes()), m.getReturnType().getName(), 3);
            ++i;
        }
        return infos;
    }

    public static MBeanInfo interfaceToMBeanInfo(Class theInterface) {
        Method[] methods = theInterface.getMethods();
        HashMap<String, Method> getters = new HashMap<String, Method>();
        HashMap<String, Method> setters = new HashMap<String, Method>();
        HashMap<String, Method> getterSetters = new HashMap<String, Method>();
        HashSet<Method> operations = new HashSet<Method>();
        for (int i = 0; i < methods.length; ++i) {
            Class<?> setterType;
            Method method = methods[i];
            String methodName = method.getName();
            String attrName = null;
            if (JMXUtil.isIsOrGetter(method)) {
                attrName = JMXUtil.getAttributeName(method);
                getters.put(attrName, method);
            } else if (JMXUtil.isSetter(method)) {
                attrName = JMXUtil.getAttributeName(method);
                setters.put(attrName, method);
            } else {
                operations.add(method);
            }
            if (attrName == null || !getters.containsKey(attrName) || !setters.containsKey(attrName)) continue;
            Method getter = (Method)getters.get(attrName);
            Class<?> getterType = getter.getReturnType();
            if (getterType == (setterType = ((Method)setters.get(attrName)).getParameterTypes()[0])) {
                getters.remove(attrName);
                setters.remove(attrName);
                getterSetters.put(attrName, getter);
                continue;
            }
            throw new IllegalArgumentException("Attribute " + attrName + "has type " + getterType.getName() + " as getter but type " + setterType.getName() + " as setter");
        }
        MBeanAttributeInfo[] attrInfos = JMXUtil.generateMBeanAttributeInfos(getterSetters.values(), getters.values(), setters.values());
        MBeanOperationInfo[] operationInfos = JMXUtil.generateMBeanOperationInfos(operations);
        MBeanConstructorInfo[] constructorInfos = null;
        MBeanNotificationInfo[] notificationInfos = null;
        MBeanInfo mbeanInfo = new MBeanInfo(theInterface.getName(), theInterface.getName(), attrInfos, constructorInfos, operationInfos, notificationInfos);
        return mbeanInfo;
    }

    public static MBeanAttributeInfo[] mergeMBeanAttributeInfos(MBeanAttributeInfo[] infos1, MBeanAttributeInfo[] infos2) {
        HashSet<String> names = new HashSet<String>();
        for (MBeanAttributeInfo info : infos1) {
            names.add(info.getName());
        }
        Set<MBeanAttributeInfo> merged = GSetUtil.newSet(infos1);
        for (MBeanAttributeInfo info2 : infos2) {
            String info2Name = info2.getName();
            if (names.contains(info2Name)) continue;
            merged.add(info2);
        }
        MBeanAttributeInfo[] infosArray = new MBeanAttributeInfo[merged.size()];
        merged.toArray(infosArray);
        return infosArray;
    }

    public static MBeanNotificationInfo[] mergeMBeanNotificationInfos(MBeanNotificationInfo[] infos1, MBeanNotificationInfo[] infos2) {
        if (infos1 == null) {
            return infos2;
        }
        if (infos2 == null) {
            return infos1;
        }
        Set<MBeanNotificationInfo> all = GSetUtil.newSet(infos1);
        all.addAll(GSetUtil.newSet(infos2));
        MBeanNotificationInfo[] merged = new MBeanNotificationInfo[all.size()];
        return all.toArray(merged);
    }

    public static MBeanInfo addNotificationInfos(MBeanInfo origInfo, MBeanNotificationInfo[] notifs) {
        MBeanInfo result = origInfo;
        if (notifs != null && notifs.length != 0) {
            result = new MBeanInfo(origInfo.getClassName(), origInfo.getDescription(), origInfo.getAttributes(), origInfo.getConstructors(), origInfo.getOperations(), JMXUtil.mergeMBeanNotificationInfos(origInfo.getNotifications(), notifs));
        }
        return result;
    }

    public static MBeanOperationInfo[] mergeMBeanOperationInfos(MBeanOperationInfo[] infos1, MBeanOperationInfo[] infos2) {
        if (infos1 == null) {
            return infos2;
        }
        if (infos2 == null) {
            return infos1;
        }
        Set<MBeanOperationInfo> all = GSetUtil.newSet(infos1);
        all.addAll(GSetUtil.newSet(infos2));
        MBeanOperationInfo[] merged = new MBeanOperationInfo[all.size()];
        return all.toArray(merged);
    }

    public static MBeanConstructorInfo[] mergeMBeanConstructorInfos(MBeanConstructorInfo[] infos1, MBeanConstructorInfo[] infos2) {
        if (infos1 == null) {
            return infos2;
        }
        if (infos2 == null) {
            return infos1;
        }
        Set<MBeanConstructorInfo> all = GSetUtil.newSet(infos1);
        all.addAll(GSetUtil.newSet(infos2));
        MBeanConstructorInfo[] merged = new MBeanConstructorInfo[all.size()];
        return all.toArray(merged);
    }

    public static MBeanInfo mergeMBeanInfos(MBeanInfo info1, MBeanInfo info2) {
        if (info1 == null) {
            return info2;
        }
        if (info2 == null) {
            return info1;
        }
        return new MBeanInfo(info1.getClassName(), info1.getDescription(), JMXUtil.mergeMBeanAttributeInfos(info1.getAttributes(), info2.getAttributes()), JMXUtil.mergeMBeanConstructorInfos(info1.getConstructors(), info2.getConstructors()), JMXUtil.mergeMBeanOperationInfos(info1.getOperations(), info2.getOperations()), JMXUtil.mergeMBeanNotificationInfos(info1.getNotifications(), info2.getNotifications()));
    }

    public static MBeanInfo newMBeanInfo(MBeanInfo origMBeanInfo, MBeanAttributeInfo[] newAttrInfos) {
        MBeanInfo info = new MBeanInfo(origMBeanInfo.getClassName(), origMBeanInfo.getDescription(), newAttrInfos, origMBeanInfo.getConstructors(), origMBeanInfo.getOperations(), origMBeanInfo.getNotifications());
        return info;
    }

    public static MBeanInfo newMBeanInfo(MBeanInfo origMBeanInfo, MBeanOperationInfo[] newOps) {
        MBeanInfo info = new MBeanInfo(origMBeanInfo.getClassName(), origMBeanInfo.getDescription(), origMBeanInfo.getAttributes(), origMBeanInfo.getConstructors(), newOps, origMBeanInfo.getNotifications());
        return info;
    }

    public static int findMBeanOperationInfo(MBeanInfo info, String methodName, String[] parameterTypes) {
        int resultIdx = -1;
        MBeanOperationInfo[] ops = info.getOperations();
        for (int i = 0; i < ops.length; ++i) {
            MBeanOperationInfo op = ops[i];
            if (!op.getName().equals(methodName) || parameterTypes != null && !ArrayUtil.arraysEqual(parameterTypes, op.getSignature())) continue;
            resultIdx = i;
            break;
        }
        return resultIdx;
    }

    public static boolean domainMatches(String defaultDomain, ObjectName pattern, ObjectName candidate) {
        boolean matches = false;
        String candidateDomain = candidate.getDomain();
        if (pattern.isDomainPattern()) {
            String regex = RegexUtil.wildcardToJavaRegex(pattern.getDomain());
            matches = Pattern.matches(regex, candidateDomain);
        } else {
            String patternDomain = pattern.getDomain();
            if (patternDomain.length() == 0) {
                patternDomain = defaultDomain;
            }
            matches = patternDomain.equals(candidateDomain);
        }
        return matches;
    }

    public static boolean matchesPattern(String defaultDomain, ObjectName pattern, ObjectName candidate) {
        boolean matches = false;
        if (JMXUtil.domainMatches(defaultDomain, pattern, candidate)) {
            String patternProps = pattern.getCanonicalKeyPropertyListString();
            String candidateProps = candidate.getCanonicalKeyPropertyListString();
            assert (patternProps.indexOf(WILD_ALL) < 0);
            assert (candidateProps.indexOf(WILD_ALL) < 0);
            if (candidateProps.indexOf(patternProps) >= 0) {
                matches = true;
            }
        }
        return matches;
    }

    public static String toString(ObjectName objectName) {
        return ObjectNameStringifier.DEFAULT.stringify(objectName);
    }

    public static Notification cloneNotification(Notification in, Object source) {
        Notification out = null;
        if (in.getClass() == AttributeChangeNotification.class) {
            AttributeChangeNotification a = (AttributeChangeNotification)in;
            out = new AttributeChangeNotification(source, a.getSequenceNumber(), a.getTimeStamp(), a.getMessage(), a.getAttributeName(), a.getAttributeType(), a.getOldValue(), a.getNewValue());
        } else if (in.getClass() == Notification.class) {
            out = new Notification(in.getType(), source, in.getSequenceNumber(), in.getTimeStamp(), in.getMessage());
        } else {
            throw new IllegalArgumentException("Not supporting cloning of: " + in.getClass());
        }
        return out;
    }

    public static Set<ObjectName> queryNames(MBeanServerConnection conn, ObjectName pattern, QueryExp exp) throws IOException {
        return TypeCast.asSet(conn.queryNames(pattern, exp));
    }

    public static Set<ObjectName> queryNames(MBeanServer server, ObjectName pattern, QueryExp exp) {
        try {
            return JMXUtil.queryNames((MBeanServerConnection)server, pattern, exp);
        }
        catch (IOException iOException) {
            return null;
        }
    }

    public static final <T extends Serializable> Map<String, T> getUserDataMapString_Serializable(Notification notif) {
        Object userData = notif.getUserData();
        if (!(userData instanceof Map)) {
            throw new IllegalArgumentException();
        }
        Map<String, Serializable> result = TypeCast.asMap((Map)userData);
        if (result != null) {
            for (String testKey : result.keySet()) {
                Serializable testValue = (Serializable)result.get(testKey);
                result.put(testKey, testValue);
            }
        }
        return result;
    }
}

