/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.admin.cli;

import com.sun.enterprise.admin.cli.remote.CLIRemoteCommand;
import com.sun.enterprise.cli.framework.CLILogger;
import com.sun.enterprise.cli.framework.CLIMain;
import com.sun.enterprise.cli.framework.CommandException;
import com.sun.enterprise.cli.framework.CommandValidationException;
import com.sun.enterprise.cli.framework.InvalidCommandException;
import com.sun.enterprise.universal.i18n.LocalStringsImpl;

public class AsadminMain {
    private static final int ERROR = 1;
    private static final int SUCCESS = 0;
    private static final LocalStringsImpl strings = new LocalStringsImpl(AsadminMain.class);

    public static void main(String[] args) {
        AsadminMain main = new AsadminMain();
        int exitCode = 1;
        if (args.length <= 0) {
            String msg = "Usage: asadmin <command-name> [options]\nMultimode not available for TP2 release.\nStart the server using \"asadmin start-domain\" or \"startserv\" script\nand run \"asadmin list-commands\" to get a complete list of commands";
            System.out.println(msg);
            System.exit(0);
        }
        try {
            exitCode = main.local(args);
        }
        catch (InvalidCommandException e) {
            CLILogger.getInstance().printDebugMessage(e.getMessage());
            exitCode = main.remote(args);
        }
        if (exitCode == 0) {
            CLILogger.getInstance().printDetailMessage(strings.get("CommandSuccessful", args[0]));
        }
        if (exitCode == 1) {
            try {
                CLIMain.displayClosestMatch(args[0]);
            }
            catch (InvalidCommandException invalidCommandException) {
                // empty catch block
            }
            CLILogger.getInstance().printDetailMessage(strings.get("CommandUnSuccessful", args[0]));
        }
        System.exit(exitCode);
    }

    private int local(String[] args) throws InvalidCommandException {
        try {
            CLIMain cli = new CLIMain();
            cli.invokeCommand(args);
            return 0;
        }
        catch (CommandException ce) {
            CLILogger.getInstance().printError(ce.getMessage());
            return 1;
        }
        catch (CommandValidationException cve) {
            CLILogger.getInstance().printError(cve.getMessage());
            return 1;
        }
        catch (NoClassDefFoundError ncdfe) {
            CLILogger.getInstance().printError(ncdfe.toString());
            return 1;
        }
        catch (InvalidCommandException ice) {
            throw ice;
        }
        catch (Throwable ex) {
            CLILogger.getInstance().printExceptionStackTrace(ex);
            CLILogger.getInstance().printError(ex.toString());
            return 1;
        }
    }

    private int remote(String[] args) {
        try {
            CLIRemoteCommand rc = new CLIRemoteCommand(args);
            rc.runCommand();
            return 0;
        }
        catch (Throwable ex) {
            CLILogger.getInstance().printExceptionStackTrace(ex);
            CLILogger.getInstance().printMessage(ex.getMessage());
            return 1;
        }
    }
}

