/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.admin.launcher;

import com.sun.enterprise.admin.launcher.GFLauncher;
import com.sun.enterprise.admin.launcher.GFLauncherException;
import com.sun.enterprise.admin.launcher.GFLauncherInfo;
import com.sun.enterprise.universal.io.SmartFile;
import java.io.File;
import java.io.FilenameFilter;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class GFDomainLauncher
extends GFLauncher {
    private static final String MAIN_CLASS = "com.sun.enterprise.glassfish.bootstrap.ASMain";
    private static final Pattern BOOTSTRAP_JAR = Pattern.compile("glassfish-\\d.*\\.jar");

    GFDomainLauncher(GFLauncherInfo info) {
        super(info);
    }

    @Override
    void internalLaunch() throws GFLauncherException {
        try {
            this.launchInstance();
        }
        catch (GFLauncherException ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new GFLauncherException(ex);
        }
    }

    @Override
    List<File> getMainClasspath() throws GFLauncherException {
        ArrayList<File> list = new ArrayList<File>();
        File dir = new File(this.getEnvProps().get("com.sun.aas.installRoot"), "modules");
        File[] matches = dir.listFiles(new FilenameFilter(){

            public boolean accept(File dir, String name) {
                return BOOTSTRAP_JAR.matcher(name).matches();
            }
        });
        if (!(matches != null && matches.length != 0 || this.isFakeLaunch())) {
            throw new GFLauncherException("nobootjar", dir.getPath());
        }
        if (matches != null) {
            for (File m : matches) {
                list.add(SmartFile.sanitize(m));
            }
        }
        return list;
    }

    @Override
    String getMainClass() throws GFLauncherException {
        return MAIN_CLASS;
    }
}

