/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.admin.monitor.stats;

import com.sun.enterprise.admin.monitor.stats.MutableTimeStatistic;
import com.sun.enterprise.admin.monitor.stats.StatisticImpl;
import com.sun.enterprise.admin.monitor.stats.TimeStatisticImpl;
import javax.management.j2ee.statistics.Statistic;
import javax.management.j2ee.statistics.TimeStatistic;

public class MutableTimeStatisticImpl
implements TimeStatistic,
MutableTimeStatistic {
    private final TimeStatistic initial;
    private long methodCount;
    private long min;
    private long max;
    private long total;
    private long lastSampleTime;

    public MutableTimeStatisticImpl(TimeStatistic initial) {
        boolean minTot;
        this.initial = initial;
        this.methodCount = initial.getCount();
        this.min = initial.getMinTime();
        this.max = initial.getMaxTime();
        this.total = initial.getTotalTime();
        boolean minMax = this.min == this.max;
        boolean bl = minTot = this.min == this.total;
        if (!minMax || !minTot) {
            throw new IllegalArgumentException("Invalid initial values: " + this.min + ", " + this.max + ", " + this.total);
        }
        this.lastSampleTime = initial.getLastSampleTime();
    }

    public void incrementCount(long current) {
        if (this.methodCount == 0L) {
            this.max = this.min = current;
            this.total = this.min;
        } else {
            this.total += current;
            this.max = current >= this.max ? current : this.max;
            this.min = current >= this.min ? this.min : current;
        }
        ++this.methodCount;
        this.lastSampleTime = System.currentTimeMillis();
    }

    public void reset() {
        this.methodCount = this.initial.getCount();
        this.min = this.initial.getMinTime();
        this.max = this.initial.getMaxTime();
        this.total = this.initial.getTotalTime();
        this.lastSampleTime = this.initial.getLastSampleTime();
    }

    public Statistic unmodifiableView() {
        return new TimeStatisticImpl(this.methodCount, this.max, this.min, this.total, this.initial.getName(), this.initial.getUnit(), this.initial.getDescription(), this.initial.getStartTime(), this.lastSampleTime);
    }

    public Statistic modifiableView() {
        return this;
    }

    public long getCount() {
        return this.methodCount;
    }

    public String getDescription() {
        return this.initial.getDescription();
    }

    public long getLastSampleTime() {
        return this.lastSampleTime;
    }

    public long getMaxTime() {
        return this.max;
    }

    public long getMinTime() {
        return this.min;
    }

    public String getName() {
        return this.initial.getName();
    }

    public long getStartTime() {
        return this.initial.getStartTime();
    }

    public long getTotalTime() {
        return this.total;
    }

    public String getUnit() {
        return this.initial.getUnit();
    }

    public void setDescription(String s) {
        try {
            ((StatisticImpl)((Object)this.initial)).setDescription(s);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

