/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.admin.util;

import com.sun.enterprise.admin.util.IllegalEscapeSequenceException;
import com.sun.enterprise.admin.util.MalformedUnicodeSequenceException;
import com.sun.enterprise.admin.util.UnterminatedLiteralStringException;
import java.text.StringCharacterIterator;
import java.util.ArrayList;

final class TokenizerInternal {
    final String mInput;
    final String mDelimiters;
    final char mEscapeChar;
    final String mEscapableChars;
    final StringCharacterIterator mIter;
    static final Delim DELIM = Delim.getInstance();
    private static final char QUOTE_CHAR = '\"';
    private static final char TAB_CHAR = '\t';

    public TokenizerInternal(String input, String delimiters, char escapeChar, String escapableChars) {
        this.mInput = input;
        this.mDelimiters = delimiters;
        this.mEscapeChar = escapeChar;
        this.mEscapableChars = escapableChars;
        this.mIter = new StringCharacterIterator(input);
    }

    static boolean isSpecialEscapeChar(char theChar) {
        return theChar == 'n' || theChar == 'r' || theChar == 't' || theChar == '\"';
    }

    boolean isCallerProvidedEscapableChar(char theChar) {
        return this.mEscapableChars.indexOf(theChar) >= 0 || theChar == this.mEscapeChar;
    }

    boolean isEscapableChar(char theChar) {
        return this.isCallerProvidedEscapableChar(theChar) || TokenizerInternal.isSpecialEscapeChar(theChar);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    boolean isDelim(String delims, char theChar) {
        if (delims.indexOf(theChar) >= 0) return true;
        if (theChar != '\uffff') return false;
        return true;
    }

    static boolean isDigit(char theChar) {
        return theChar >= '0' && theChar <= '9';
    }

    static boolean isHexDigit(char theChar) {
        return TokenizerInternal.isDigit(theChar) || theChar >= 'a' && theChar <= 'f' || TokenizerInternal.isUpper(theChar);
    }

    static boolean isUpper(char c) {
        return c >= 'A' && c <= 'F';
    }

    boolean hasMoreChars() {
        return this.mIter.current() != '\uffff';
    }

    char nextChar() {
        char theChar = this.mIter.current();
        this.mIter.next();
        return theChar;
    }

    char decodeUnicodeSequence() throws MalformedUnicodeSequenceException {
        int value = 0;
        try {
            for (int i = 0; i < 4; ++i) {
                value = value << 4 | TokenizerInternal.hexValue(this.nextChar());
            }
        }
        catch (Exception e) {
            throw new MalformedUnicodeSequenceException("");
        }
        return (char)value;
    }

    static int hexValue(char c) {
        if (!TokenizerInternal.isHexDigit(c)) {
            throw new IllegalArgumentException();
        }
        int value = 0;
        value = TokenizerInternal.isDigit(c) ? c - 48 : (TokenizerInternal.isUpper(c) ? c - 65 : c - 97);
        return value;
    }

    char getEscapedChar(char inputChar) throws MalformedUnicodeSequenceException, IllegalEscapeSequenceException {
        int outChar = '\u0000';
        if (this.isCallerProvidedEscapableChar((char)inputChar)) {
            outChar = inputChar;
        } else {
            switch (inputChar) {
                default: {
                    throw new IllegalEscapeSequenceException("" + (char)inputChar);
                }
                case 110: {
                    outChar = 10;
                    break;
                }
                case 114: {
                    outChar = 13;
                    break;
                }
                case 116: {
                    outChar = 9;
                    break;
                }
                case 34: {
                    outChar = 34;
                    break;
                }
                case 117: {
                    outChar = this.decodeUnicodeSequence();
                }
            }
        }
        return (char)outChar;
    }

    ArrayList parseTokens() throws UnterminatedLiteralStringException, MalformedUnicodeSequenceException, IllegalEscapeSequenceException {
        StringBuffer tok = new StringBuffer();
        ArrayList<Object> tokens = new ArrayList<Object>();
        boolean insideStringLiteral = false;
        while (this.hasMoreChars()) {
            char theChar = this.nextChar();
            if (theChar == this.mEscapeChar) {
                tok.append(this.getEscapedChar(this.nextChar()));
                continue;
            }
            if (theChar == '\"') {
                if (insideStringLiteral && tok.length() == 0 && tokens.size() == 0) {
                    tokens.add("");
                }
                insideStringLiteral = !insideStringLiteral;
                continue;
            }
            if (insideStringLiteral) {
                tok.append(theChar);
                continue;
            }
            if (this.isDelim(this.mDelimiters, theChar)) {
                if (tok.length() != 0) {
                    tokens.add(tok.toString());
                    tok.setLength(0);
                }
                tokens.add(DELIM);
                continue;
            }
            tok.append(theChar);
        }
        if (tok.length() != 0) {
            tokens.add(tok.toString());
        }
        if (insideStringLiteral) {
            throw new UnterminatedLiteralStringException(tok.toString());
        }
        return tokens;
    }

    private static class Delim {
        private Delim() {
        }

        public static Delim getInstance() {
            return new Delim();
        }

        public String toString() {
            return "<DELIM>";
        }
    }
}

