/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.backup;

import com.sun.enterprise.backup.BackupRequest;
import com.sun.enterprise.backup.LoggerHelper;
import com.sun.enterprise.backup.StringHelper;
import com.sun.enterprise.backup.util.FileUtils;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Date;
import java.util.Properties;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;

class Status {
    private BackupRequest request;
    private File statusFile;
    private Properties props;

    Status() {
    }

    String write(BackupRequest req) {
        this.props = new Properties();
        this.request = req;
        this.statusFile = new File(this.request.domainDir, "backup.properties");
        try {
            this.setProps();
            FileOutputStream out = new FileOutputStream(this.statusFile);
            this.props.store(out, "Backup Status");
            return this.propsToString(false);
        }
        catch (Exception e) {
            return StringHelper.get("backup-res.CantWriteStatus", this.statusFile);
        }
    }

    String read(File file) {
        return this.read(file, true);
    }

    String read(File file, boolean terse) {
        this.props = null;
        this.setPropsFromFile(file);
        if (this.props == null) {
            return this.badStatusFileMessage(file);
        }
        return this.propsToString(terse);
    }

    long getInternalTimestamp(File f) {
        this.props = null;
        this.setPropsFromFile(f);
        try {
            String s = this.props.getProperty("timestamp.msec");
            return Long.parseLong(s);
        }
        catch (Exception e) {
            LoggerHelper.warning(this.badStatusFileMessage(f));
            return 0L;
        }
    }

    void delete() {
        if (!this.statusFile.delete()) {
            this.statusFile.deleteOnExit();
        }
    }

    String getDomainName() {
        if (this.props == null) {
            return null;
        }
        return this.props.getProperty("domain.name");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setPropsFromFile(File file) {
        this.props = null;
        ZipInputStream zis = null;
        if (file.getName().toLowerCase().endsWith(".properties")) {
            this.readPropertiesFile(file);
            return;
        }
        try {
            ZipEntry ze;
            zis = new ZipInputStream(new FileInputStream(file));
            while ((ze = zis.getNextEntry()) != null) {
                if (!ze.getName().equals("backup.properties")) continue;
                this.props = new Properties();
                this.props.load(zis);
                break;
            }
        }
        catch (Exception e) {
            this.props = null;
        }
        finally {
            if (zis != null) {
                try {
                    zis.close();
                }
                catch (Exception exception) {}
            }
        }
    }

    private void readPropertiesFile(File propsFile) {
        try {
            BufferedInputStream in = new BufferedInputStream(new FileInputStream(propsFile));
            this.props = new Properties();
            this.props.load(in);
            in.close();
        }
        catch (IOException ioe) {
            this.props = null;
        }
    }

    private void setProps() {
        this.props.setProperty("user.name", System.getProperty("user.name"));
        this.props.setProperty("timestamp.msec", "" + this.request.timestamp);
        this.props.setProperty("domains.dir", FileUtils.safeGetCanonicalPath(this.request.domainsDir));
        this.props.setProperty("domain.dir", FileUtils.safeGetCanonicalPath(this.request.domainDir));
        this.props.setProperty("backup.file", FileUtils.safeGetCanonicalPath(this.request.backupFile));
        this.props.setProperty("domain.name", this.request.domainName);
        this.props.setProperty("description", this.request.description);
        this.props.setProperty("timestamp.human", new Date(this.request.timestamp).toString());
    }

    private String propsToString(boolean terse) {
        String pre = "backup-res.Props.";
        StringBuffer sb = new StringBuffer();
        if (terse) {
            sb.append(this.props.getProperty("backup.file"));
        } else {
            sb.append(StringHelper.get("backup-res.Props.description", this.props.getProperty("description")));
            sb.append("\n");
            sb.append(StringHelper.get("backup-res.Props.backup.file", this.props.getProperty("backup.file")));
            sb.append("\n");
            sb.append(StringHelper.get("backup-res.Props.timestamp.human", this.props.getProperty("timestamp.human")));
            sb.append("\n");
            sb.append(StringHelper.get("backup-res.Props.domains.dir", this.props.getProperty("domains.dir")));
            sb.append("\n");
            sb.append(StringHelper.get("backup-res.Props.domain.dir", this.props.getProperty("domain.dir")));
            sb.append("\n");
            sb.append(StringHelper.get("backup-res.Props.domain.name", this.props.getProperty("domain.name")));
            sb.append("\n");
            sb.append(StringHelper.get("backup-res.Props.user.name", this.props.getProperty("user.name")));
        }
        return sb.toString();
    }

    private String badStatusFileMessage(File file) {
        String msg = StringHelper.get("backup-res.Props.backup.file", file);
        msg = msg + "\n";
        msg = msg + StringHelper.get("backup-res.CorruptBackupFile.NoStatusFile");
        return msg;
    }
}

