/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.connectors.util;

import com.sun.appserv.connectors.internal.api.ConnectorRuntimeException;
import com.sun.enterprise.config.serverbeans.Property;
import com.sun.enterprise.connectors.ConnectorDescriptorInfo;
import com.sun.enterprise.deploy.shared.FileArchive;
import com.sun.enterprise.deployment.ConnectionDefDescriptor;
import com.sun.enterprise.deployment.ConnectorDescriptor;
import com.sun.enterprise.deployment.EnvironmentProperty;
import com.sun.enterprise.deployment.OutboundResourceAdapter;
import com.sun.enterprise.deployment.archivist.ConnectorArchivist;
import com.sun.enterprise.deployment.deploy.shared.MemoryMappedArchive;
import com.sun.logging.LogDomains;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.xml.sax.SAXParseException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConnectorDDTransformUtils {
    static Logger _logger = LogDomains.getLogger("javax.enterprise.resource.resourceadapter");

    public static ConnectorDescriptorInfo getConnectorDescriptorInfo(ConnectionDefDescriptor connectionDefDescriptor) {
        ConnectorDescriptorInfo connectorDescInfo = new ConnectorDescriptorInfo();
        connectorDescInfo.setConnectionDefinitionName(connectionDefDescriptor.getConnectionFactoryIntf());
        connectorDescInfo.setManagedConnectionFactoryClass(connectionDefDescriptor.getManagedConnectionFactoryImpl());
        connectorDescInfo.setConnectionFactoryClass(connectionDefDescriptor.getConnectionFactoryImpl());
        connectorDescInfo.setConnectionFactoryInterface(connectionDefDescriptor.getConnectionFactoryIntf());
        connectorDescInfo.setConnectionInterface(connectionDefDescriptor.getConnectionIntf());
        connectorDescInfo.setConnectionClass(connectionDefDescriptor.getConnectionImpl());
        connectorDescInfo.setMCFConfigProperties(connectionDefDescriptor.getConfigProperties());
        return connectorDescInfo;
    }

    public static Set mergeProps(List<Property> props, Set defaultMCFProps) {
        HashSet<Object> mergedSet = new HashSet<Object>();
        if (defaultMCFProps != null) {
            Object[] defaultProps = defaultMCFProps.toArray();
            for (int i = 0; i < defaultProps.length; ++i) {
                mergedSet.add(defaultProps[i]);
            }
        }
        for (Property property : props) {
            EnvironmentProperty ep = new EnvironmentProperty(property.getName(), property.getValue(), null);
            if (defaultMCFProps.contains(ep)) {
                for (EnvironmentProperty envProp : defaultMCFProps) {
                    if (!envProp.equals(ep) || envProp.getType() == null) continue;
                    ep.setType(envProp.getType());
                }
                _logger.log(Level.FINER, "After merging props with defaultMCFProps: envPropName: " + ep.getName() + " envPropValue : " + ep.getValue());
                mergedSet.remove(ep);
            }
            mergedSet.add(ep);
        }
        return mergedSet;
    }

    public static ConnectorDescriptor getConnectorDescriptor(String moduleDir) throws ConnectorRuntimeException {
        try {
            File module = new File(moduleDir);
            FileArchive fileArchive = new FileArchive();
            fileArchive.open(module.toURI());
            ConnectorArchivist connectorArchivist = new ConnectorArchivist();
            return (ConnectorDescriptor)connectorArchivist.open(fileArchive);
        }
        catch (IOException ex) {
            ConnectorRuntimeException cre = new ConnectorRuntimeException("Failed to read the connector deployment descriptors");
            cre.initCause(ex);
            _logger.log(Level.SEVERE, "rardeployment.connector_descriptor_read_error", moduleDir);
            _logger.log(Level.SEVERE, "", cre);
            throw cre;
        }
        catch (SAXParseException ex) {
            ConnectorRuntimeException cre = new ConnectorRuntimeException("Failed to parse the connector deployment descriptors");
            cre.initCause(ex);
            _logger.log(Level.SEVERE, "rardeployment.connector_descriptor_parse_error", moduleDir);
            _logger.log(Level.SEVERE, "", cre);
            throw cre;
        }
    }

    public static ConnectionDefDescriptor[] getConnectionDefs(ConnectorDescriptor connectorDesc) {
        ConnectionDefDescriptor[] connectionDefDescs = null;
        OutboundResourceAdapter ora = connectorDesc.getOutboundResourceAdapter();
        if (ora != null) {
            Set connectionDefs = ora.getConnectionDefs();
            int size = connectionDefs.size();
            if (size == 0) {
                return null;
            }
            Iterator iter = connectionDefs.iterator();
            connectionDefDescs = new ConnectionDefDescriptor[size];
            for (int i = 0; i < size; ++i) {
                connectionDefDescs[i] = (ConnectionDefDescriptor)iter.next();
            }
        }
        return connectionDefDescs;
    }

    public static String getResourceAdapterClassName(String rarLocation) {
        try {
            FileInputStream fis = new FileInputStream(rarLocation);
            MemoryMappedArchive mma = new MemoryMappedArchive(fis);
            ConnectorArchivist ca = new ConnectorArchivist();
            ConnectorDescriptor cd = (ConnectorDescriptor)ca.open(mma);
            return cd.getResourceAdapterClass();
        }
        catch (IOException e) {
            _logger.info(e.getMessage());
            _logger.log(Level.FINE, "Error while trying to read connectordescriptor to get resource-adapter properties", e);
        }
        catch (SAXParseException e) {
            _logger.info(e.getMessage());
            _logger.log(Level.FINE, "Error while trying to read connectordescriptor to get resource-adapter properties", e);
        }
        return null;
    }
}

