/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.deployment;

import com.sun.enterprise.deploy.shared.FileArchive;
import com.sun.enterprise.deployment.ApplicationClientDescriptor;
import com.sun.enterprise.deployment.BundleDescriptor;
import com.sun.enterprise.deployment.ConnectorDescriptor;
import com.sun.enterprise.deployment.Descriptor;
import com.sun.enterprise.deployment.EjbBundleDescriptor;
import com.sun.enterprise.deployment.EjbCMPEntityDescriptor;
import com.sun.enterprise.deployment.EjbDescriptor;
import com.sun.enterprise.deployment.EjbReferenceDescriptor;
import com.sun.enterprise.deployment.JndiNameEnvironment;
import com.sun.enterprise.deployment.NamedReferencePair;
import com.sun.enterprise.deployment.OrderedSet;
import com.sun.enterprise.deployment.ResourceReferenceDescriptor;
import com.sun.enterprise.deployment.Role;
import com.sun.enterprise.deployment.Roles;
import com.sun.enterprise.deployment.RootDeploymentDescriptor;
import com.sun.enterprise.deployment.SecurityRoleDescriptor;
import com.sun.enterprise.deployment.WebBundleDescriptor;
import com.sun.enterprise.deployment.WebService;
import com.sun.enterprise.deployment.WebServicesDescriptor;
import com.sun.enterprise.deployment.annotation.introspection.EjbComponentAnnotationScanner;
import com.sun.enterprise.deployment.archivist.AppClientArchivist;
import com.sun.enterprise.deployment.archivist.ApplicationArchivist;
import com.sun.enterprise.deployment.archivist.EjbArchivist;
import com.sun.enterprise.deployment.deploy.shared.InputJarArchive;
import com.sun.enterprise.deployment.interfaces.SecurityRoleMapper;
import com.sun.enterprise.deployment.interfaces.SecurityRoleMapperFactory;
import com.sun.enterprise.deployment.runtime.common.SecurityRoleMapping;
import com.sun.enterprise.deployment.types.RoleMappingContainer;
import com.sun.enterprise.deployment.util.AnnotationDetector;
import com.sun.enterprise.deployment.util.AppClientVisitor;
import com.sun.enterprise.deployment.util.ApplicationVisitor;
import com.sun.enterprise.deployment.util.ConnectorVisitor;
import com.sun.enterprise.deployment.util.DOLUtils;
import com.sun.enterprise.deployment.util.DescriptorVisitor;
import com.sun.enterprise.deployment.util.EjbBundleVisitor;
import com.sun.enterprise.deployment.util.LogDomains;
import com.sun.enterprise.deployment.util.ModuleDescriptor;
import com.sun.enterprise.deployment.util.WebBundleVisitor;
import com.sun.enterprise.util.LocalStringManagerImpl;
import com.sun.enterprise.util.io.FileUtils;
import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.enterprise.deploy.shared.ModuleType;
import javax.persistence.EntityManagerFactory;
import org.glassfish.api.deployment.archive.ReadableArchive;
import org.glassfish.resource.common.Resource;
import org.jvnet.hk2.component.Habitat;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Application
extends RootDeploymentDescriptor
implements Roles,
RoleMappingContainer {
    private static final String LIBRARY_DIRECTORY_DEFAULT_VALUE = "lib";
    private static final String PERSISTENCE_UNIT_NAME_SEPARATOR = "#";
    private String generatedXMLDir;
    private Set<ModuleDescriptor<BundleDescriptor>> modules = new HashSet<ModuleDescriptor<BundleDescriptor>>();
    private long uniqueId;
    private boolean virtual = false;
    private Boolean passByReference = null;
    private HashMap cmpDescriptors = null;
    private String cmpDescriptorsLock = new String("cmp descriptors lock");
    private boolean isDirty;
    private SecurityRoleMapper roleMapper;
    private String registrationName;
    private String realm;
    private Map<String, EntityManagerFactory> entityManagerFactories = new HashMap<String, EntityManagerFactory>();
    private Set<String> entityManagerFactoryUnitNames = new HashSet<String>();
    private static LocalStringManagerImpl localStrings = new LocalStringManagerImpl(Application.class);
    private Set<Role> appRoles;
    private String libraryDirectory;
    private List<SecurityRoleMapping> roleMaps = new ArrayList<SecurityRoleMapping>();
    private boolean loadedFromApplicationXml = true;
    private List<Resource> resourceList = null;
    private boolean isPackagedAsSingleModule = false;
    private final Habitat habitat;
    static Logger _logger = LogDomains.getLogger("javax.enterprise.system.tools.deployment");
    private boolean isValidated;

    public Application(Habitat habitat) {
        super("", localStrings.getLocalString("enterprise.deployment.application.description", "Application description"));
        this.habitat = habitat;
    }

    @Override
    public String getDefaultSpecVersion() {
        return "5";
    }

    public static Application createApplication(Habitat habitat, String name, ModuleDescriptor<BundleDescriptor> newModule) {
        Application application = new Application(habitat);
        application.setVirtual(true);
        if (name == null && newModule.getDescriptor() != null) {
            name = newModule.getDescriptor().getDisplayName();
        }
        if (name != null) {
            application.setDisplayName(name);
            application.setName(name);
        }
        newModule.setStandalone(true);
        newModule.setArchiveUri(name);
        if (newModule.getDescriptor() != null) {
            newModule.getDescriptor().setApplication(application);
        }
        application.addModule(newModule);
        return application;
    }

    public static Application createApplication(Habitat habitat, ReadableArchive archive, boolean introspect) {
        return Application.createApplication(habitat, archive, introspect, false);
    }

    public static Application createApplication(Habitat habitat, ReadableArchive archive, boolean introspect, boolean directory) {
        if (introspect) {
            return Application.getApplicationFromIntrospection(habitat, archive, directory);
        }
        return Application.getApplicationFromAppXml(archive);
    }

    private static Application getApplicationFromAppXml(ReadableArchive archive) {
        ApplicationArchivist archivist = new ApplicationArchivist();
        archivist.setXMLValidation(false);
        Application application = null;
        try {
            application = (Application)archivist.readStandardDeploymentDescriptor(archive);
        }
        catch (Exception ex) {
            _logger.log(Level.SEVERE, "Error loading application.xml from " + archive.getURI());
            _logger.log(Level.SEVERE, ex.getMessage());
        }
        return application;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private static Application getApplicationFromIntrospection(Habitat habitat, ReadableArchive archive, boolean directory) {
        File[] files;
        String appRoot = archive.getURI().getSchemeSpecificPart();
        Application app = new Application(habitat);
        app.setLoadedFromApplicationXml(false);
        app.setVirtual(false);
        String appName = appRoot.substring(appRoot.lastIndexOf(File.separatorChar) + 1);
        app.setName(appName);
        ArrayList<ReadableArchive> unknowns = new ArrayList<ReadableArchive>();
        for (File subModule : files = Application.getEligibleEntries(new File(appRoot), directory)) {
            ReadableArchive subArchive;
            block26: {
                block29: {
                    block28: {
                        String uri;
                        block27: {
                            ModuleDescriptor<BundleDescriptor> md;
                            subArchive = null;
                            try {
                                if (!directory) {
                                    subArchive = new InputJarArchive();
                                    subArchive.open(subModule.toURI());
                                } else {
                                    subArchive = new FileArchive();
                                    subArchive.open(subModule.toURI());
                                }
                            }
                            catch (IOException ex) {
                                _logger.log(Level.WARNING, ex.getMessage());
                            }
                            String name = subModule.getName();
                            uri = Application.deriveArchiveUri(appRoot, subModule, directory);
                            if (!directory && name.endsWith(".war") || directory && (name.endsWith("_war") || name.endsWith(".war"))) {
                                String contextRoot = uri.substring(uri.lastIndexOf(47) + 1, uri.lastIndexOf(46));
                                md = new ModuleDescriptor<BundleDescriptor>();
                                md.setArchiveUri(uri);
                                md.setModuleType(ModuleType.WAR);
                                md.setContextRoot(contextRoot);
                                app.addModule(md);
                                break block26;
                            }
                            if (!directory && name.endsWith(".rar") || directory && (name.endsWith("_rar") || name.endsWith(".rar"))) {
                                ModuleDescriptor<BundleDescriptor> md2 = new ModuleDescriptor<BundleDescriptor>();
                                md2.setArchiveUri(uri);
                                md2.setModuleType(ModuleType.RAR);
                                app.addModule(md2);
                                break block26;
                            }
                            if ((directory || !name.endsWith(".jar")) && (!directory || !name.endsWith("_jar") && !name.endsWith(".jar"))) break block26;
                            AppClientArchivist acArchivist = new AppClientArchivist();
                            if (!acArchivist.hasStandardDeploymentDescriptor(subArchive) && !acArchivist.hasRuntimeDeploymentDescriptor(subArchive) && acArchivist.getMainClassName(subArchive.getManifest()) == null) break block27;
                            md = new ModuleDescriptor();
                            md.setArchiveUri(uri);
                            md.setModuleType(ModuleType.CAR);
                            md.setManifest(subArchive.getManifest());
                            app.addModule(md);
                            if (subArchive == null) continue;
                            try {
                                subArchive.close();
                            }
                            catch (IOException ioe) {
                                _logger.log(Level.WARNING, localStrings.getLocalString("enterprise.deployment.errorClosingSubArch", "Error closing subarchive {0}", subModule.getAbsolutePath()), ioe);
                            }
                            continue;
                        }
                        EjbArchivist ejbArchivist = new EjbArchivist();
                        if (!ejbArchivist.hasStandardDeploymentDescriptor(subArchive) && !ejbArchivist.hasRuntimeDeploymentDescriptor(subArchive)) break block28;
                        ModuleDescriptor<BundleDescriptor> md = new ModuleDescriptor<BundleDescriptor>();
                        md.setArchiveUri(uri);
                        md.setModuleType(ModuleType.EJB);
                        app.addModule(md);
                        if (subArchive == null) continue;
                        try {
                            subArchive.close();
                        }
                        catch (IOException ioe) {
                            _logger.log(Level.WARNING, localStrings.getLocalString("enterprise.deployment.errorClosingSubArch", "Error closing subarchive {0}", subModule.getAbsolutePath()), ioe);
                        }
                        continue;
                    }
                    break block29;
                    {
                        catch (IOException ex) {
                            _logger.log(Level.WARNING, ex.getMessage());
                        }
                    }
                }
                unknowns.add(subArchive);
            }
            if (subArchive == null) continue;
            try {
                subArchive.close();
            }
            catch (IOException ioe) {
                _logger.log(Level.WARNING, localStrings.getLocalString("enterprise.deployment.errorClosingSubArch", "Error closing subarchive {0}", subModule.getAbsolutePath()), ioe);
            }
            continue;
            catch (Throwable throwable) {
                if (subArchive != null) {
                    try {
                        subArchive.close();
                    }
                    catch (IOException ioe) {
                        _logger.log(Level.WARNING, localStrings.getLocalString("enterprise.deployment.errorClosingSubArch", "Error closing subarchive {0}", subModule.getAbsolutePath()), ioe);
                    }
                }
                throw throwable;
            }
        }
        if (unknowns.size() > 0) {
            AnnotationDetector detector = new AnnotationDetector(new EjbComponentAnnotationScanner());
            for (int i = 0; i < unknowns.size(); ++i) {
                File jarFile = new File(((ReadableArchive)unknowns.get(i)).getURI().getSchemeSpecificPart());
                try {
                    if (!detector.hasAnnotationInArchive((ReadableArchive)unknowns.get(i))) continue;
                    String uri = Application.deriveArchiveUri(appRoot, jarFile, directory);
                    ModuleDescriptor<BundleDescriptor> md = new ModuleDescriptor<BundleDescriptor>();
                    md.setArchiveUri(uri);
                    md.setModuleType(ModuleType.EJB);
                    app.addModule(md);
                    continue;
                }
                catch (IOException ex) {
                    _logger.log(Level.WARNING, ex.getMessage());
                }
            }
        }
        return app;
    }

    public void setGeneratedXMLDirectory(String xmlDir) {
        this.generatedXMLDir = xmlDir;
    }

    public String getGeneratedXMLDirectory() {
        return this.generatedXMLDir;
    }

    public void setRegistrationName(String appId) {
        SecurityRoleMapper roleMapper = null;
        try {
            roleMapper = this.getRoleMapper();
        }
        catch (IllegalArgumentException ignore) {
            // empty catch block
        }
        if (roleMapper != null) {
            SecurityRoleMapperFactory factory = this.habitat.getComponent(SecurityRoleMapperFactory.class);
            if (factory == null) {
                throw new IllegalArgumentException(localStrings.getLocalString("enterprise.deployment.norolemapperfactorydefine", "This application has no role mapper factory defined"));
            }
            factory.removeRoleMapper(this.getName());
            roleMapper.setName(appId);
            factory.setRoleMapper(appId, roleMapper);
        }
        this.registrationName = appId;
    }

    public String getRegistrationName() {
        if (this.registrationName != null) {
            return this.registrationName;
        }
        return this.getName();
    }

    public void addEntityManagerFactory(String unitName, String persistenceRootUri, EntityManagerFactory emf) {
        String fullyQualifiedUnitName = persistenceRootUri + PERSISTENCE_UNIT_NAME_SEPARATOR + unitName;
        this.entityManagerFactories.put(fullyQualifiedUnitName, emf);
        if (this.entityManagerFactoryUnitNames.contains(unitName)) {
            this.entityManagerFactories.remove(unitName);
        } else {
            this.entityManagerFactories.put(unitName, emf);
            this.entityManagerFactoryUnitNames.add(unitName);
        }
    }

    public EntityManagerFactory getEntityManagerFactory(String unitName, BundleDescriptor declaringModule) {
        String lookupString = unitName;
        int separatorIndex = unitName.lastIndexOf(PERSISTENCE_UNIT_NAME_SEPARATOR);
        if (separatorIndex != -1) {
            String unqualifiedUnitName = unitName.substring(separatorIndex + 1);
            String path = unitName.substring(0, separatorIndex);
            String persistenceRootUri = this.getTargetUri(declaringModule, path);
            lookupString = persistenceRootUri + PERSISTENCE_UNIT_NAME_SEPARATOR + unqualifiedUnitName;
        }
        return this.entityManagerFactories.get(lookupString);
    }

    public Set<EntityManagerFactory> getEntityManagerFactories() {
        return new HashSet<EntityManagerFactory>(this.entityManagerFactories.values());
    }

    @Override
    public Set<Role> getRoles() {
        HashSet<Role> roles = new HashSet<Role>();
        for (WebBundleDescriptor wbd : this.getWebBundleDescriptors()) {
            if (wbd == null) continue;
            roles.addAll(wbd.getRoles());
        }
        for (EjbBundleDescriptor ejbd : this.getEjbBundleDescriptors()) {
            if (ejbd == null) continue;
            roles.addAll(ejbd.getRoles());
        }
        return roles;
    }

    public Set<Role> getAppRoles() {
        if (this.appRoles == null) {
            this.appRoles = new OrderedSet<Role>();
        }
        return this.appRoles;
    }

    public void addAppRole(SecurityRoleDescriptor descriptor) {
        Role role = new Role(descriptor.getName());
        role.setDescription(descriptor.getDescription());
        this.getAppRoles().add(role);
    }

    @Override
    public void addRole(Role role) {
        for (WebBundleDescriptor wbd : this.getWebBundleDescriptors()) {
            wbd.addRole(role);
        }
        for (EjbBundleDescriptor ejbd : this.getEjbBundleDescriptors()) {
            ejbd.addRole(role);
        }
    }

    @Override
    public void removeRole(Role role) {
        this.getAppRoles().remove(role);
        for (WebBundleDescriptor wbd : this.getWebBundleDescriptors()) {
            wbd.removeRole(role);
        }
        for (EjbBundleDescriptor ejbd : this.getEjbBundleDescriptors()) {
            ejbd.removeRole(role);
        }
    }

    public Set<ResourceReferenceDescriptor> getResourceReferenceDescriptors() {
        HashSet<ResourceReferenceDescriptor> resourceReferences = new HashSet<ResourceReferenceDescriptor>();
        for (EjbBundleDescriptor ejbd : this.getEjbBundleDescriptors()) {
            resourceReferences.addAll(ejbd.getResourceReferenceDescriptors());
        }
        return resourceReferences;
    }

    @Override
    public void setName(String name) {
        name = name.replace('/', '-');
        name = name.replace('\\', '-');
        super.setName(name);
        if (this.getRoleMapper() != null) {
            this.getRoleMapper().setName(name);
        }
    }

    public void setLibraryDirectory(String value) {
        this.libraryDirectory = value;
    }

    public String getLibraryDirectory() {
        if (this.libraryDirectory != null) {
            return this.libraryDirectory.length() == 0 ? null : this.libraryDirectory;
        }
        return LIBRARY_DIRECTORY_DEFAULT_VALUE;
    }

    public String getLibraryDirectoryRawValue() {
        return this.libraryDirectory;
    }

    public int getWebComponentCount() {
        int count = 0;
        for (WebBundleDescriptor wbd : this.getWebBundleDescriptors()) {
            count += wbd.getWebComponentDescriptors().size();
        }
        return count;
    }

    public void removeModule(ModuleDescriptor<BundleDescriptor> descriptor) {
        if (this.modules.contains(descriptor)) {
            if (descriptor.getDescriptor() != null) {
                descriptor.getDescriptor().setApplication(null);
            }
            this.modules.remove(descriptor);
        }
    }

    public void addModule(ModuleDescriptor<BundleDescriptor> descriptor) {
        this.modules.add(descriptor);
        if (descriptor.getDescriptor() != null) {
            descriptor.getDescriptor().setApplication(this);
        }
    }

    public Set<ModuleDescriptor<BundleDescriptor>> getModules() {
        return this.modules;
    }

    public int getEjbComponentCount() {
        int count = 0;
        for (EjbBundleDescriptor ejbd : this.getEjbBundleDescriptors()) {
            count += ejbd.getEjbs().size();
        }
        return count;
    }

    public int getRarComponentCount() {
        return this.getBundleDescriptors(ConnectorDescriptor.class).size();
    }

    public Vector<Object> getEjbReferenceDescriptors() {
        Vector<Object> ejbReferenceDescriptors = new Vector<Object>();
        for (Object next : this.getNamedDescriptors()) {
            if (!(next instanceof EjbReferenceDescriptor)) continue;
            ejbReferenceDescriptors.addElement(next);
        }
        return ejbReferenceDescriptors;
    }

    public EjbBundleDescriptor getEjbBundleByName(String name) {
        for (EjbBundleDescriptor ejbd : this.getEjbBundleDescriptors()) {
            if (!ejbd.getDisplayName().equals(name)) continue;
            return ejbd;
        }
        throw new IllegalArgumentException(localStrings.getLocalString("enterprise.deployment.exceptionapphasnoejbjarnamed", "This application has no ejb jars of name {0}", name));
    }

    public String getTargetUri(BundleDescriptor origin, String relativeTargetUri) {
        String targetUri = null;
        try {
            String archiveUri = origin.getModuleDescriptor().getArchiveUri();
            URI originUri = new URI(archiveUri);
            URI resolvedUri = originUri.resolve(relativeTargetUri);
            targetUri = resolvedUri.getPath();
        }
        catch (URISyntaxException use) {
            _logger.log(Level.FINE, "origin " + origin + " has invalid syntax", use);
        }
        return targetUri;
    }

    public BundleDescriptor getRelativeBundle(BundleDescriptor origin, String relativeTargetUri) {
        String targetBundleUri = this.getTargetUri(origin, relativeTargetUri);
        BundleDescriptor targetBundle = null;
        if (targetBundleUri != null) {
            BundleDescriptor module = this.getModuleByUri(targetBundleUri);
            targetBundle = module instanceof BundleDescriptor ? module : null;
        }
        return targetBundle;
    }

    public String getRelativeUri(BundleDescriptor origin, BundleDescriptor target) {
        String originUri = origin.getModuleDescriptor().getArchiveUri();
        String targetUri = target.getModuleDescriptor().getArchiveUri();
        StringTokenizer tokenizer = new StringTokenizer(originUri, "/");
        int numTokens = tokenizer.countTokens();
        int numSeparators = numTokens > 0 ? numTokens - 1 : 0;
        StringBuffer relativeUri = new StringBuffer();
        for (int i = 0; i < numSeparators; ++i) {
            relativeUri.append("../");
        }
        relativeUri.append(targetUri);
        return relativeUri.toString();
    }

    public EjbBundleDescriptor getEjbBundleByUri(String name) {
        EjbBundleDescriptor desc = this.getModuleByTypeAndUri(EjbBundleDescriptor.class, name);
        if (desc != null) {
            return desc;
        }
        throw new IllegalArgumentException(localStrings.getLocalString("enterprise.deployment.exceptionapphasnoejbjarnamed", "This application has no ejb jars of name {0}", name));
    }

    public ModuleDescriptor<BundleDescriptor> getModuleDescriptorByUri(String uri) {
        for (ModuleDescriptor<BundleDescriptor> aModule : this.getModules()) {
            if (!aModule.getArchiveUri().equals(uri)) continue;
            return aModule;
        }
        return null;
    }

    public BundleDescriptor getModuleByUri(String uri) {
        ModuleDescriptor<BundleDescriptor> md = this.getModuleDescriptorByUri(uri);
        if (md != null) {
            return md.getDescriptor();
        }
        return null;
    }

    public <T extends BundleDescriptor> T getModuleByTypeAndUri(Class<T> type, String uri) {
        for (ModuleDescriptor<BundleDescriptor> aModule : this.getModules()) {
            try {
                BundleDescriptor descriptor = (BundleDescriptor)type.cast(aModule.getDescriptor());
                if (!descriptor.getModuleDescriptor().getArchiveUri().equals(uri)) continue;
                return (T)descriptor;
            }
            catch (ClassCastException e) {
            }
        }
        return null;
    }

    public EjbDescriptor getEjbByName(String ejbName) {
        for (EjbBundleDescriptor ejbd : this.getEjbBundleDescriptors()) {
            if (!ejbd.hasEjbByName(ejbName)) continue;
            return ejbd.getEjbByName(ejbName);
        }
        throw new IllegalArgumentException(localStrings.getLocalString("enterprise.deployment.exceptionapphasnobeannamed", "This application has no beans of name {0}", ejbName));
    }

    public boolean hasEjbByName(String ejbName) {
        for (EjbBundleDescriptor ebd : this.getBundleDescriptors(EjbBundleDescriptor.class)) {
            if (!ebd.hasEjbByName(ejbName)) continue;
            return true;
        }
        return false;
    }

    public ApplicationClientDescriptor getApplicationClientByName(String name) {
        for (ApplicationClientDescriptor acd : this.getBundleDescriptors(ApplicationClientDescriptor.class)) {
            if (!acd.getDisplayName().equals(name)) continue;
            return acd;
        }
        throw new IllegalArgumentException(localStrings.getLocalString("enterprise.deployment.exceptionapphasnoappclientname", "This application has no application clients of name {0}", name));
    }

    public ApplicationClientDescriptor getApplicationClientByUri(String name) {
        ApplicationClientDescriptor desc = this.getModuleByTypeAndUri(ApplicationClientDescriptor.class, name);
        if (desc != null) {
            return desc;
        }
        throw new IllegalArgumentException(name);
    }

    public WebBundleDescriptor getWebBundleDescriptorByName(String name) {
        for (WebBundleDescriptor wbd : this.getBundleDescriptors(WebBundleDescriptor.class)) {
            if (!wbd.getDisplayName().equals(name)) continue;
            return wbd;
        }
        throw new IllegalArgumentException(localStrings.getLocalString("enterprise.deployment.exceptionapphasnowebappname", "This application has no web app of name {0}", name));
    }

    public WebBundleDescriptor getWebBundleDescriptorByUri(String name) {
        WebBundleDescriptor desc = this.getModuleByTypeAndUri(WebBundleDescriptor.class, name);
        if (desc != null) {
            return desc;
        }
        throw new IllegalArgumentException(localStrings.getLocalString("enterprise.deployment.exceptionapphasnowebappname", "This application has no web app of name {0}", name));
    }

    public ConnectorDescriptor getRarDescriptorByUri(String name) {
        ConnectorDescriptor desc = this.getModuleByTypeAndUri(ConnectorDescriptor.class, name);
        if (desc != null) {
            return desc;
        }
        throw new IllegalArgumentException(name);
    }

    public Set<JndiNameEnvironment> getJndiNameEnvironments() {
        HashSet<JndiNameEnvironment> jndiNameEnvironments = new HashSet<JndiNameEnvironment>();
        jndiNameEnvironments.addAll(this.getWebBundleDescriptors());
        jndiNameEnvironments.addAll(this.getApplicationClientDescriptors());
        jndiNameEnvironments.addAll(this.getEjbDescriptors());
        return jndiNameEnvironments;
    }

    public Set<ResourceReferenceDescriptor> getServiceReferenceDescriptors() {
        HashSet<ResourceReferenceDescriptor> serviceRefs = new HashSet<ResourceReferenceDescriptor>();
        for (JndiNameEnvironment jndiNameEnvironment : this.getJndiNameEnvironments()) {
            serviceRefs.addAll(jndiNameEnvironment.getServiceReferenceDescriptors());
        }
        return serviceRefs;
    }

    public Set<WebService> getWebServiceDescriptors() {
        HashSet<WebService> webServiceDescriptors = new HashSet<WebService>();
        HashSet<BundleDescriptor> bundles = new HashSet<BundleDescriptor>();
        bundles.addAll(this.getEjbBundleDescriptors());
        bundles.addAll(this.getWebBundleDescriptors());
        for (BundleDescriptor next : bundles) {
            WebServicesDescriptor webServicesDesc = next.getWebServices();
            webServiceDescriptors.addAll(webServicesDesc.getWebServices());
        }
        return webServiceDescriptors;
    }

    public Set<WebBundleDescriptor> getWebBundleDescriptors() {
        return this.getBundleDescriptors(WebBundleDescriptor.class);
    }

    public BundleDescriptor getStandaloneBundleDescriptor() {
        if (this.isVirtual()) {
            if (this.getModules().size() > 1) {
                throw new IllegalStateException("Virtual application contains more than one module");
            }
            return this.getModules().iterator().next().getDescriptor();
        }
        return null;
    }

    public <T extends BundleDescriptor> Set<T> getBundleDescriptors(Class<T> type) {
        if (type == null) {
            return null;
        }
        HashSet<BundleDescriptor> bundleSet = new HashSet<BundleDescriptor>();
        for (ModuleDescriptor<BundleDescriptor> aModule : this.getModules()) {
            try {
                BundleDescriptor descriptor = (BundleDescriptor)type.cast(aModule.getDescriptor());
                bundleSet.add(descriptor);
            }
            catch (ClassCastException e) {}
        }
        return bundleSet;
    }

    public Set<BundleDescriptor> getBundleDescriptors() {
        HashSet<BundleDescriptor> bundleSet = new HashSet<BundleDescriptor>();
        for (ModuleDescriptor<BundleDescriptor> aModule : this.getModules()) {
            if (aModule.getDescriptor() != null) {
                bundleSet.add(aModule.getDescriptor());
                continue;
            }
            DOLUtils.getDefaultLogger().fine("Null descriptor for module " + aModule.getArchiveUri());
        }
        return bundleSet;
    }

    public void addBundleDescriptor(BundleDescriptor bundleDescriptor) {
        ModuleDescriptor newModule = bundleDescriptor.getModuleDescriptor();
        this.addModule(newModule);
    }

    public void removeBundleDescriptor(BundleDescriptor bundleDescriptor) {
        bundleDescriptor.setApplication(null);
        this.getWebBundleDescriptors().remove(bundleDescriptor);
    }

    public Set<EjbBundleDescriptor> getEjbBundleDescriptors() {
        return this.getBundleDescriptors(EjbBundleDescriptor.class);
    }

    public Set<ConnectorDescriptor> getRarDescriptors() {
        return this.getBundleDescriptors(ConnectorDescriptor.class);
    }

    public Set<ApplicationClientDescriptor> getApplicationClientDescriptors() {
        return this.getBundleDescriptors(ApplicationClientDescriptor.class);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public EjbCMPEntityDescriptor getCMPDescriptorFor(String className) {
        String string = this.cmpDescriptorsLock;
        synchronized (string) {
            if (this.cmpDescriptors == null) {
                this.cmpDescriptors = new HashMap();
                for (EjbBundleDescriptor bundle : this.getBundleDescriptors(EjbBundleDescriptor.class)) {
                    for (EjbDescriptor ejb : bundle.getEjbs()) {
                        if (!(ejb instanceof EjbCMPEntityDescriptor)) continue;
                        this.cmpDescriptors.put(ejb.getEjbImplClassName(), ejb);
                    }
                }
            }
            return (EjbCMPEntityDescriptor)this.cmpDescriptors.get(className);
        }
    }

    public Vector<NamedReferencePair> getNamedReferencePairs() {
        Vector<NamedReferencePair> pairs = new Vector<NamedReferencePair>();
        for (EjbBundleDescriptor ejbBundleDescriptor : this.getEjbBundleDescriptors()) {
            pairs.addAll(ejbBundleDescriptor.getNamedReferencePairs());
        }
        for (WebBundleDescriptor webBundleDescriptor : this.getWebBundleDescriptors()) {
            pairs.addAll(webBundleDescriptor.getNamedReferencePairs());
        }
        for (ApplicationClientDescriptor applicationClientDescriptor : this.getApplicationClientDescriptors()) {
            pairs.addAll(applicationClientDescriptor.getNamedReferencePairs());
        }
        return pairs;
    }

    public Collection<Object> getNamedDescriptors() {
        Vector<Object> namedDescriptors = new Vector<Object>();
        for (EjbBundleDescriptor ejbBundleDescriptor : this.getEjbBundleDescriptors()) {
            namedDescriptors.addAll(ejbBundleDescriptor.getNamedDescriptors());
        }
        for (WebBundleDescriptor webBundleDescriptor : this.getWebBundleDescriptors()) {
            namedDescriptors.addAll(webBundleDescriptor.getNamedDescriptors());
        }
        for (ApplicationClientDescriptor applicationClientDescriptor : this.getApplicationClientDescriptors()) {
            namedDescriptors.addAll(applicationClientDescriptor.getNamedDescriptors());
        }
        return namedDescriptors;
    }

    public Vector getEjbDescriptors() {
        Vector<EjbDescriptor> ejbDescriptors = new Vector<EjbDescriptor>();
        for (EjbBundleDescriptor ejbBundleDescriptor : this.getBundleDescriptors(EjbBundleDescriptor.class)) {
            ejbDescriptors.addAll(ejbBundleDescriptor.getEjbs());
        }
        return ejbDescriptors;
    }

    public boolean containsCMPEntity() {
        for (EjbBundleDescriptor ebd : this.getBundleDescriptors(EjbBundleDescriptor.class)) {
            if (!ebd.containsCMPEntity()) continue;
            return true;
        }
        return false;
    }

    public EjbDescriptor[] getSortedEjbDescriptors() {
        Vector ejbDesc = this.getEjbDescriptors();
        EjbDescriptor[] descs = ejbDesc.toArray(new EjbDescriptor[ejbDesc.size()]);
        Arrays.sort(descs, new Comparator(){

            public int compare(Object o1, Object o2) {
                EjbDescriptor desc1 = (EjbDescriptor)o1;
                EjbDescriptor desc2 = (EjbDescriptor)o2;
                String moduleUri1 = desc1.getEjbBundleDescriptor().getModuleDescriptor().getArchiveUri();
                String moduleUri2 = desc2.getEjbBundleDescriptor().getModuleDescriptor().getArchiveUri();
                return (moduleUri1 + desc1.getName()).compareTo(moduleUri2 + desc2.getName());
            }
        });
        return descs;
    }

    public void setVirtual(boolean virtual) {
        this.virtual = virtual;
    }

    public boolean isVirtual() {
        return this.virtual;
    }

    public boolean isPackagedAsSingleModule() {
        return this.isPackagedAsSingleModule;
    }

    public void setPackagedAsSingleModule(boolean status) {
        this.isPackagedAsSingleModule = status;
    }

    public void setUniqueId(long id) {
        _logger.log(Level.FINE, "[Application]uid: " + id);
        this.uniqueId = id;
        EjbDescriptor[] descs = this.getSortedEjbDescriptors();
        for (int i = 0; i < descs.length; ++i) {
            descs[i].setUniqueId(id | (long)i);
            if (!_logger.isLoggable(Level.FINE)) continue;
            _logger.log(Level.FINE, "[Application]desc name: " + descs[i].getName());
            _logger.log(Level.FINE, "[Application]desc id: " + descs[i].getUniqueId());
        }
    }

    public long getUniqueId() {
        return this.uniqueId;
    }

    public void setPassByReference(boolean passByReference) {
        this.passByReference = passByReference;
    }

    public boolean getPassByReference() {
        boolean passByReference = false;
        if (this.isPassByReferenceDefined()) {
            passByReference = this.passByReference;
        }
        return passByReference;
    }

    public boolean isPassByReferenceDefined() {
        boolean passByReferenceDefined = false;
        if (this.passByReference != null) {
            passByReferenceDefined = true;
        }
        return passByReferenceDefined;
    }

    public void addApplication(Application application) {
        for (ModuleDescriptor<BundleDescriptor> md : application.getModules()) {
            this.addModule(md);
        }
    }

    public Set getArchivableDescriptors() {
        HashSet<BundleDescriptor> archivableDescriptors = new HashSet<BundleDescriptor>();
        archivableDescriptors.addAll(this.getBundleDescriptors());
        return archivableDescriptors;
    }

    public void setRoleMapper(SecurityRoleMapper roleMapper) {
        this.roleMapper = roleMapper;
    }

    public boolean hasRuntimeInformation() {
        return true;
    }

    @Override
    public SecurityRoleMapper getRoleMapper() {
        if (this.roleMapper == null) {
            SecurityRoleMapperFactory factory = this.habitat.getComponent(SecurityRoleMapperFactory.class);
            if (factory == null) {
                _logger.log(Level.FINE, "SecurityRoleMapperFactory NOT set.");
            } else {
                this.roleMapper = factory.getRoleMapper(this.getName());
            }
        }
        return this.roleMapper;
    }

    public void setRealm(String realm) {
        this.realm = realm;
    }

    public String getRealm() {
        return this.realm;
    }

    public boolean isDirty() {
        return this.isDirty;
    }

    @Override
    public ClassLoader getClassLoader() {
        if (this.classLoader == null) {
            throw new RuntimeException("No class loader associated with application " + this.getName());
        }
        return this.classLoader;
    }

    @Override
    public void print(StringBuffer toStringBuffer) {
        toStringBuffer.append("Application");
        toStringBuffer.append("\n");
        super.print(toStringBuffer);
        toStringBuffer.append("\n smallIcon ").append(super.getSmallIconUri());
        for (ModuleDescriptor<BundleDescriptor> aModule : this.getModules()) {
            toStringBuffer.append("\n  Module : ");
            aModule.print(toStringBuffer);
        }
        toStringBuffer.append("\n EjbBundles: \n");
        if (this.getEjbBundleDescriptors() != null) {
            this.printDescriptorSet(this.getEjbBundleDescriptors(), toStringBuffer);
        }
        toStringBuffer.append("\n WebBundleDescriptors ");
        if (this.getWebBundleDescriptors() != null) {
            this.printDescriptorSet(this.getWebBundleDescriptors(), toStringBuffer);
        }
        toStringBuffer.append("\n applicationClientDescriptors ");
        if (this.getApplicationClientDescriptors() != null) {
            this.printDescriptorSet(this.getApplicationClientDescriptors(), toStringBuffer);
        }
        toStringBuffer.append("\n roles ").append(this.getRoles());
        toStringBuffer.append("\n RoleMapper ").append(this.getRoleMapper());
        toStringBuffer.append("\n Realm ").append(this.realm);
    }

    private void printDescriptorSet(Set descSet, StringBuffer sbuf) {
        for (Object obj : descSet) {
            if (obj instanceof Descriptor) {
                ((Descriptor)obj).print(sbuf);
                continue;
            }
            sbuf.append(obj);
        }
    }

    @Override
    public void visit(DescriptorVisitor aVisitor) {
        if (aVisitor instanceof ApplicationVisitor) {
            this.visit((ApplicationVisitor)((Object)aVisitor));
        } else {
            super.visit(aVisitor);
        }
    }

    public void visit(ApplicationVisitor aVisitor) {
        AppClientVisitor appclientVisitor;
        ConnectorVisitor connectorVisitor;
        WebBundleVisitor webVisitor;
        aVisitor.accept(this);
        EjbBundleVisitor ejbBundleVisitor = aVisitor.getEjbBundleVisitor();
        if (ejbBundleVisitor != null) {
            for (EjbBundleDescriptor ebd : this.getBundleDescriptors(EjbBundleDescriptor.class)) {
                ebd.visit(ejbBundleVisitor);
            }
        }
        if ((webVisitor = aVisitor.getWebBundleVisitor()) != null) {
            for (WebBundleDescriptor wbd : this.getBundleDescriptors(WebBundleDescriptor.class)) {
                if (wbd == null) continue;
                wbd.visit(webVisitor);
            }
        }
        if ((connectorVisitor = aVisitor.getConnectorVisitor()) != null) {
            for (ConnectorDescriptor cd : this.getBundleDescriptors(ConnectorDescriptor.class)) {
                cd.visit(connectorVisitor);
            }
        }
        if ((appclientVisitor = aVisitor.getAppClientVisitor()) != null) {
            for (ApplicationClientDescriptor acd : this.getBundleDescriptors(ApplicationClientDescriptor.class)) {
                acd.visit(appclientVisitor);
            }
        }
    }

    @Override
    public String getModuleID() {
        return this.moduleID;
    }

    @Override
    public boolean isApplication() {
        return true;
    }

    @Override
    public ModuleType getModuleType() {
        return ModuleType.EAR;
    }

    public void addSecurityRoleMapping(SecurityRoleMapping roleMapping) {
        this.roleMaps.add(roleMapping);
    }

    public List<SecurityRoleMapping> getSecurityRoleMappings() {
        return this.roleMaps;
    }

    public void setLoadedFromApplicationXml(boolean bool) {
        this.loadedFromApplicationXml = bool;
    }

    public boolean isLoadedFromApplicationXml() {
        return this.loadedFromApplicationXml;
    }

    public void setResourceList(List<Resource> rList) {
        this.resourceList = rList;
    }

    public List<Resource> getResourceList() {
        return this.resourceList;
    }

    private static String deriveArchiveUri(String appRoot, File subModule, boolean deploydir) {
        if (deploydir) {
            return FileUtils.revertFriendlyFilename(subModule.getName());
        }
        String uri = subModule.getAbsolutePath().substring(appRoot.length() + 1);
        return uri.replace(File.separatorChar, '/');
    }

    private static File[] getEligibleEntries(File appRoot, boolean deploydir) {
        if (deploydir) {
            return appRoot.listFiles(new DirectoryIntrospectionFilter());
        }
        Vector<File> files = new Vector<File>();
        Application.getListOfFiles(appRoot, files, new ArchiveIntrospectionFilter(appRoot.getAbsolutePath()));
        return files.toArray(new File[files.size()]);
    }

    private static void getListOfFiles(File directory, Vector<File> files, FilenameFilter filter) {
        File[] list = directory.listFiles(filter);
        for (int i = 0; i < list.length; ++i) {
            if (!list[i].isDirectory()) {
                files.add(list[i]);
                continue;
            }
            Application.getListOfFiles(list[i], files, filter);
        }
    }

    public boolean isValidated() {
        return this.isValidated;
    }

    public void setValidated(boolean newValidated) {
        this.isValidated = newValidated;
    }

    private static class DirectoryIntrospectionFilter
    implements FilenameFilter {
        DirectoryIntrospectionFilter() {
        }

        public boolean accept(File dir, String name) {
            File currentFile = new File(dir, name);
            if (!currentFile.isDirectory()) {
                return false;
            }
            return name.endsWith("_war") || name.endsWith(".war") || name.endsWith("_rar") || name.endsWith(".rar") || name.endsWith("_jar") || name.endsWith(".jar");
        }
    }

    private static class ArchiveIntrospectionFilter
    implements FilenameFilter {
        private String libDir;

        ArchiveIntrospectionFilter(String root) {
            this.libDir = root + File.separator + Application.LIBRARY_DIRECTORY_DEFAULT_VALUE + File.separator;
        }

        public boolean accept(File dir, String name) {
            File currentFile = new File(dir, name);
            if (currentFile.isDirectory()) {
                return true;
            }
            if (name.endsWith(".war") || name.endsWith(".rar")) {
                return true;
            }
            String path = currentFile.getAbsolutePath();
            return !path.startsWith(this.libDir) && path.endsWith(".jar");
        }
    }
}

