/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.deployment.node;

import com.sun.enterprise.deployment.WebServiceHandlerChain;
import com.sun.enterprise.deployment.node.DisplayableComponentNode;
import com.sun.enterprise.deployment.node.WebServiceHandlerNode;
import com.sun.enterprise.deployment.node.XMLElement;
import java.util.List;
import java.util.Map;
import org.w3c.dom.Node;

public class WebServiceHandlerChainNode
extends DisplayableComponentNode {
    private static final XMLElement tag = new XMLElement("handler-chain");

    public WebServiceHandlerChainNode() {
        this.registerElementHandler(new XMLElement("handler"), WebServiceHandlerNode.class, "addHandler");
    }

    protected XMLElement getXMLRootTag() {
        return tag;
    }

    protected Map getDispatchTable() {
        Map table = super.getDispatchTable();
        table.put("service-name-pattern", "setServiceNamePattern");
        table.put("port-name-pattern", "setPortNamePattern");
        table.put("protocol-bindings", "setProtocolBindings");
        return table;
    }

    public void setElementValue(XMLElement element, String value) {
        super.setElementValue(element, value);
    }

    public Node writeDescriptor(Node parent, String nodeName, WebServiceHandlerChain handler) {
        Node wshNode = super.writeDescriptor(parent, nodeName, handler);
        if (handler.getServiceNamePattern() != null) {
            WebServiceHandlerChainNode.appendTextChild(wshNode, "service-name-pattern", handler.getServiceNamePattern());
        }
        if (handler.getPortNamePattern() != null) {
            WebServiceHandlerChainNode.appendTextChild(wshNode, "port-name-pattern", handler.getPortNamePattern());
        }
        if (handler.getProtocolBindings() != null) {
            WebServiceHandlerChainNode.appendTextChild(wshNode, "protocol-bindings", handler.getProtocolBindings());
        }
        WebServiceHandlerNode handlerNode = new WebServiceHandlerNode();
        handlerNode.writeWebServiceHandlers(wshNode, handler.getHandlers());
        return wshNode;
    }

    public void writeWebServiceHandlerChains(Node parent, List handlerChain) {
        if (handlerChain.size() != 0) {
            parent = super.writeDescriptor(parent, "handler-chains", null);
        }
        for (WebServiceHandlerChain next : handlerChain) {
            this.writeDescriptor(parent, "handler-chain", next);
        }
    }
}

