/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.glassfish.bootstrap;

import com.sun.enterprise.glassfish.bootstrap.ASMainHelper;
import com.sun.enterprise.glassfish.bootstrap.ClassPathBuilder;
import com.sun.enterprise.module.bootstrap.StartupContext;
import com.sun.enterprise.module.bootstrap.Which;
import java.io.File;
import java.io.IOException;
import java.util.logging.Logger;

public abstract class ASMainOSGi {
    protected ClassLoader launcherCL;
    protected Logger logger;
    protected ASMainHelper helper;
    protected StartupContext context;
    protected File bootstrapFile;
    protected File glassfishDir;
    protected File domainDir;
    protected File fwDir;
    private String[] additionalJars = new String[]{"javax.xml.stream-*.jar", "wstx-asl-*.jar"};

    public ASMainOSGi(Logger logger, String ... args) {
        this.logger = logger;
        this.findBootstrapFile();
        this.glassfishDir = this.bootstrapFile.getParentFile().getParentFile();
        this.helper = new ASMainHelper(logger);
        this.context = new StartupContext(this.bootstrapFile, args);
        this.helper.parseAsEnv(this.glassfishDir);
        this.domainDir = this.helper.getDomainRoot(this.context);
        this.helper.verifyDomainRoot(this.domainDir);
        this.setFwDir();
    }

    protected abstract void setFwDir();

    public ASMainOSGi(String ... args) {
        this(Logger.getAnonymousLogger(), args);
    }

    protected abstract void addFrameworkJars(ClassPathBuilder var1) throws IOException;

    protected abstract void launchOSGiFW() throws Exception;

    public void run() {
        try {
            System.setProperty("org.jvnet.hk2.osgiadapter.contextrootdir", new File(this.glassfishDir, "modules").getAbsolutePath());
            this.setupLauncherClassLoader();
            this.launchOSGiFW();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private void setupLauncherClassLoader() throws Exception {
        ClassLoader extCL = ClassLoader.getSystemClassLoader().getParent();
        ClassPathBuilder cpb = new ClassPathBuilder(extCL);
        try {
            this.addFrameworkJars(cpb);
            this.addJDKToolsJar(cpb);
            this.findDerbyClient(cpb);
            File moduleDir = this.context.getRootDirectory().getParentFile();
            cpb.addGlob(moduleDir, this.additionalJars);
            this.launcherCL = cpb.create();
        }
        catch (IOException e) {
            throw new Error(e);
        }
        Thread.currentThread().setContextClassLoader(this.launcherCL);
    }

    protected void addJDKToolsJar(ClassPathBuilder cpb) {
        try {
            File jdkToolsJar = this.helper.getJDKToolsJar();
            if (jdkToolsJar.exists()) {
                cpb.addJar(jdkToolsJar);
            } else {
                this.logger.fine("JDK tools.jar does not exist at " + jdkToolsJar);
            }
        }
        catch (IOException e) {
            throw new Error(e);
        }
    }

    private void findDerbyClient(ClassPathBuilder cpb) throws IOException {
        String derbyHome = System.getProperty("AS_DERBY_INSTALL");
        File derbyLib = null;
        if (derbyHome != null) {
            derbyLib = new File(derbyHome, "lib");
        }
        if (!(derbyLib != null && derbyLib.exists() || System.getProperty("java.version").compareTo("1.6") <= 0)) {
            File jdkHome = new File(System.getProperty("java.home"));
            derbyLib = new File(jdkHome, "db/lib");
        }
        if (!derbyLib.exists()) {
            this.logger.info("Cannot find javadb client jar file, jdbc driver not available");
            return;
        }
        cpb.addGlob(derbyLib, "derbyclient*.jar");
    }

    private void findBootstrapFile() {
        try {
            this.bootstrapFile = Which.jarFile(this.getClass());
        }
        catch (IOException e) {
            throw new RuntimeException("Cannot get bootstrap path from " + this.getClass() + " class location, aborting");
        }
    }
}

