/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.naming.impl;

import com.sun.enterprise.naming.impl.JavaURLContext;
import com.sun.enterprise.naming.impl.NamedNamingObjectManager;
import com.sun.enterprise.naming.impl.ProviderManager;
import com.sun.enterprise.naming.impl.SerialContextProvider;
import com.sun.enterprise.naming.impl.SerialNameParser;
import com.sun.enterprise.naming.util.LogFacade;
import java.rmi.MarshalException;
import java.rmi.RemoteException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.naming.Binding;
import javax.naming.CommunicationException;
import javax.naming.CompositeName;
import javax.naming.Context;
import javax.naming.Name;
import javax.naming.NameClassPair;
import javax.naming.NameParser;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.NotContextException;
import javax.naming.OperationNotSupportedException;
import javax.naming.spi.NamingManager;
import org.glassfish.api.naming.NamingObjectProxy;
import org.jvnet.hk2.component.Habitat;
import org.omg.CORBA.COMM_FAILURE;

public class SerialContext
implements Context {
    private static Logger _logger = LogFacade.getLogger();
    private static final NameParser myParser = new SerialNameParser();
    private Hashtable myEnv = null;
    private SerialContextProvider provider;
    private static Hashtable providerCache = new Hashtable();
    private final String myName;
    private final JavaURLContext javaUrlContext;
    private static final String JAVA_URL = "java:";
    private static final String JAVA_GLOBAL_URL = "java:global";
    private static final Boolean threadlock = new Boolean(true);
    private static final ThreadLocal stickyContext = new ThreadLocal();
    private final boolean isEE;
    private final Habitat habitat;

    public static void setSticky(ThreadLocalIC var) {
        stickyContext.set(var);
    }

    public static ThreadLocalIC getSticky() {
        return (ThreadLocalIC)stickyContext.get();
    }

    public static Context getStickyContext() {
        return SerialContext.getSticky().getStickyContext();
    }

    private SerialContextProvider getProvider() throws NamingException {
        if (this.provider == null) {
            this.provider = ProviderManager.getProviderManager().getLocalProvider();
        }
        return this.provider;
    }

    public SerialContext(String name, Hashtable environment, Habitat habitat) throws NamingException {
        this.habitat = habitat;
        this.myEnv = environment != null ? (Hashtable)environment.clone() : null;
        this.myName = name;
        if (_logger.isLoggable(Level.FINE)) {
            _logger.fine("SerialContext ==> SerialContext instance created : " + this);
        }
        JavaURLContext urlContextTemp = null;
        boolean isEETemp = false;
        if (this.myEnv.get("com.sun.appserv.ee.iiop.endpointslist") != null) {
            isEETemp = true;
            urlContextTemp = new JavaURLContext(this.myEnv, this);
        } else {
            urlContextTemp = new JavaURLContext(this.myEnv, null);
        }
        this.javaUrlContext = urlContextTemp;
        this.isEE = isEETemp;
    }

    public SerialContext(Hashtable env, Habitat habitat) throws NamingException {
        this("", env, habitat);
    }

    public String getNameInNamespace() throws NamingException {
        return this.myName;
    }

    private boolean isjavaURL(String name) {
        return name.startsWith(JAVA_URL) && !name.startsWith(JAVA_GLOBAL_URL);
    }

    private void resetSticky() {
        if (SerialContext.getSticky() != null) {
            SerialContext.getSticky().decrementCount();
            if (SerialContext.getSticky().getStickyCount() == 0) {
                SerialContext.setSticky(null);
            }
        }
    }

    public Object lookup(String name) throws NamingException {
        NamedNamingObjectManager.checkAndLoadProxies(this.habitat);
        if (this.myEnv.get("com.sun.appserv.ee.iiop.endpointslist") != null) {
            if (SerialContext.getSticky() == null) {
                ThreadLocalIC threadLocal = new ThreadLocalIC(this, 1);
                SerialContext.setSticky(threadLocal);
            } else {
                SerialContext.getSticky().incrementCount();
            }
        }
        if (_logger.isLoggable(Level.FINE)) {
            _logger.fine("SerialContext ==> doing lookup with " + this);
        }
        if (name.equals("")) {
            this.resetSticky();
            return new SerialContext(this.myName, this.myEnv, this.habitat);
        }
        name = this.getRelativeName(name);
        if (_logger.isLoggable(Level.FINE)) {
            _logger.fine("SerialContext ==> looking up : " + name);
        }
        try {
            if (this.isjavaURL(name)) {
                this.resetSticky();
                return this.javaUrlContext.lookup(name);
            }
            Object obj = this.getProvider().lookup(name);
            if (obj instanceof NamingObjectProxy) {
                return ((NamingObjectProxy)obj).create(this);
            }
            if (obj instanceof Context) {
                this.resetSticky();
                return new SerialContext(name, this.myEnv, this.habitat);
            }
            Object retObj = NamingManager.getObjectInstance(obj, new CompositeName(name), null, this.myEnv);
            this.resetSticky();
            return retObj;
        }
        catch (NamingException nnfe) {
            SerialContext.setSticky(null);
            throw nnfe;
        }
        catch (Exception ex) {
            SerialContext.setSticky(null);
            _logger.log(Level.SEVERE, "enterprise_naming.serialctx_communication_exception", ex);
            if (ex instanceof MarshalException && ex.getCause() instanceof COMM_FAILURE) {
                this.provider = null;
                _logger.fine("Resetting provider to NULL. Will get new obj ref for provider since previous obj ref was stale...");
                return this.lookup(name);
            }
            CommunicationException ce = new CommunicationException("serial context communication ex");
            ce.initCause(ex);
            throw ce;
        }
    }

    public Object lookup(Name name) throws NamingException {
        return this.lookup(name.toString());
    }

    public void bind(String name, Object obj) throws NamingException {
        if (this.isjavaURL(name = this.getRelativeName(name))) {
            this.javaUrlContext.bind(name, obj);
        } else {
            try {
                this.getProvider().bind(name, obj);
            }
            catch (RemoteException ex) {
                throw new CommunicationException(ex.toString());
            }
        }
    }

    public void bind(Name name, Object obj) throws NamingException {
        this.bind(name.toString(), obj);
    }

    public void rebind(String name, Object obj) throws NamingException {
        if (this.isjavaURL(name = this.getRelativeName(name))) {
            this.javaUrlContext.rebind(name, obj);
        } else {
            try {
                this.getProvider().rebind(name, obj);
            }
            catch (RemoteException ex) {
                throw new CommunicationException(ex.toString());
            }
        }
    }

    public void rebind(Name name, Object obj) throws NamingException {
        this.rebind(name.toString(), obj);
    }

    public void unbind(String name) throws NamingException {
        if (this.isjavaURL(name = this.getRelativeName(name))) {
            this.javaUrlContext.unbind(name);
        } else {
            try {
                this.getProvider().unbind(name);
            }
            catch (RemoteException ex) {
                throw new CommunicationException(ex.toString());
            }
        }
    }

    public void unbind(Name name) throws NamingException {
        this.unbind(name.toString());
    }

    public void rename(String oldname, String newname) throws NamingException {
        oldname = this.getRelativeName(oldname);
        newname = this.getRelativeName(newname);
        if (this.isjavaURL(oldname)) {
            this.javaUrlContext.rename(oldname, newname);
        } else {
            try {
                this.getProvider().rename(oldname, newname);
            }
            catch (RemoteException ex) {
                throw new CommunicationException(ex.toString());
            }
        }
    }

    public void rename(Name oldname, Name newname) throws NamingException {
        this.rename(oldname.toString(), newname.toString());
    }

    public NamingEnumeration list(String name) throws NamingException {
        if (name.equals("")) {
            try {
                Hashtable bindings = this.getProvider().list(this.myName);
                return new RepNames(bindings);
            }
            catch (RemoteException ex) {
                throw new CommunicationException(ex.toString());
            }
        }
        if (this.isjavaURL(name = this.getRelativeName(name))) {
            return this.javaUrlContext.list(name);
        }
        Object target = this.lookup(name);
        if (target instanceof Context) {
            return ((Context)target).list("");
        }
        throw new NotContextException(name + " cannot be listed");
    }

    public NamingEnumeration list(Name name) throws NamingException {
        return this.list(name.toString());
    }

    public NamingEnumeration listBindings(String name) throws NamingException {
        if (name.equals("")) {
            try {
                Hashtable bindings = this.getProvider().list(this.myName);
                return new RepBindings(bindings);
            }
            catch (RemoteException ex) {
                CommunicationException ce = new CommunicationException(ex.toString());
                ce.initCause(ex);
                throw ce;
            }
        }
        if (this.isjavaURL(name = this.getRelativeName(name))) {
            return this.javaUrlContext.listBindings(name);
        }
        Object target = this.lookup(name);
        if (target instanceof Context) {
            return ((Context)target).listBindings("");
        }
        throw new NotContextException(name + " cannot be listed");
    }

    public NamingEnumeration listBindings(Name name) throws NamingException {
        return this.listBindings(name.toString());
    }

    public void destroySubcontext(String name) throws NamingException {
        if (this.isjavaURL(name = this.getRelativeName(name))) {
            this.javaUrlContext.destroySubcontext(name);
        } else {
            try {
                this.getProvider().destroySubcontext(name);
            }
            catch (RemoteException e) {
                CommunicationException ce = new CommunicationException(e.toString());
                ce.initCause(e);
                throw ce;
            }
        }
    }

    public void destroySubcontext(Name name) throws NamingException {
        this.destroySubcontext(name.toString());
    }

    public Context createSubcontext(String name) throws NamingException {
        Context c = null;
        if (this.isjavaURL(name = this.getRelativeName(name))) {
            return this.javaUrlContext.createSubcontext(name);
        }
        try {
            c = this.getProvider().createSubcontext(name);
            if (c instanceof Context) {
                c = new SerialContext(name, this.myEnv, this.habitat);
            }
        }
        catch (RemoteException e) {
            CommunicationException ce = new CommunicationException(e.toString());
            ce.initCause(e);
            throw ce;
        }
        return c;
    }

    public Context createSubcontext(Name name) throws NamingException {
        return this.createSubcontext(name.toString());
    }

    public Object lookupLink(String name) throws NamingException {
        if (this.isjavaURL(name = this.getRelativeName(name))) {
            return this.javaUrlContext.lookupLink(name);
        }
        return this.lookup(name);
    }

    public Object lookupLink(Name name) throws NamingException {
        return this.lookupLink(name.toString());
    }

    public NameParser getNameParser(String name) throws NamingException {
        return myParser;
    }

    public NameParser getNameParser(Name name) throws NamingException {
        return this.getNameParser(name.toString());
    }

    public String composeName(String name, String prefix) throws NamingException {
        Name result = this.composeName(new CompositeName(name), new CompositeName(prefix));
        return result.toString();
    }

    public Name composeName(Name name, Name prefix) throws NamingException {
        Name result = (Name)prefix.clone();
        result.addAll(name);
        return result;
    }

    public Object addToEnvironment(String propName, Object propVal) throws NamingException {
        if (this.myEnv == null) {
            this.myEnv = new Hashtable(5, 0.75f);
        }
        return this.myEnv.put(propName, propVal);
    }

    public Object removeFromEnvironment(String propName) throws NamingException {
        if (this.myEnv == null) {
            return null;
        }
        return this.myEnv.remove(propName);
    }

    public Hashtable getEnvironment() throws NamingException {
        if (this.myEnv == null) {
            this.myEnv = new Hashtable(3, 0.75f);
        }
        return this.myEnv;
    }

    public void close() throws NamingException {
        this.myEnv = null;
    }

    private String getRelativeName(String name) {
        if (!this.myName.equals("")) {
            name = this.myName + "/" + name;
        }
        return name;
    }

    class ThreadLocalIC {
        Context ctx;
        int count = 0;

        public ThreadLocalIC(Context ctxIn, int countIn) {
            this.ctx = ctxIn;
            this.count = countIn;
        }

        public void setStickyContext(Context ctxIn) {
            this.ctx = ctxIn;
        }

        public Context getStickyContext() {
            return this.ctx;
        }

        public void setStickyCount(int countIn) {
            this.count = countIn;
        }

        public int getStickyCount() {
            return this.count;
        }

        public void incrementCount() {
            ++this.count;
        }

        public void decrementCount() {
            --this.count;
        }
    }

    class RepBindings
    implements NamingEnumeration {
        Enumeration names;
        Hashtable bindings;

        RepBindings(Hashtable bindings) {
            this.bindings = bindings;
            this.names = bindings.keys();
        }

        public boolean hasMoreElements() {
            return this.names.hasMoreElements();
        }

        public boolean hasMore() throws NamingException {
            return this.hasMoreElements();
        }

        public Object nextElement() {
            if (this.hasMoreElements()) {
                String name = (String)this.names.nextElement();
                return new Binding(name, this.bindings.get(name));
            }
            return null;
        }

        public Object next() throws NamingException {
            return this.nextElement();
        }

        public void close() throws NamingException {
            throw new OperationNotSupportedException("close() not implemented");
        }
    }

    class RepNames
    implements NamingEnumeration {
        Hashtable bindings;
        Enumeration names;

        RepNames(Hashtable bindings) {
            this.bindings = bindings;
            this.names = bindings.keys();
        }

        public boolean hasMoreElements() {
            return this.names.hasMoreElements();
        }

        public boolean hasMore() throws NamingException {
            return this.hasMoreElements();
        }

        public Object nextElement() {
            if (this.names.hasMoreElements()) {
                String name = (String)this.names.nextElement();
                String className = this.bindings.get(name).getClass().getName();
                return new NameClassPair(name, className);
            }
            return null;
        }

        public Object next() throws NamingException {
            return this.nextElement();
        }

        public void close() throws NamingException {
            throw new OperationNotSupportedException("close() not implemented");
        }
    }
}

