/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.resource;

import com.sun.appserv.connectors.internal.api.PoolingException;
import com.sun.enterprise.connectors.ConnectorRuntime;
import com.sun.enterprise.resource.ClientSecurityInfo;
import com.sun.enterprise.resource.ResourceHandle;
import com.sun.enterprise.resource.ResourceSpec;
import com.sun.enterprise.resource.allocator.ResourceAllocator;
import com.sun.enterprise.resource.listener.ConnectionEventListener;
import com.sun.enterprise.resource.listener.LocalTxConnectionEventListener;
import com.sun.enterprise.resource.pool.PoolManager;
import com.sun.enterprise.transaction.api.JavaEETransaction;
import com.sun.enterprise.transaction.api.JavaEETransactionManager;
import com.sun.logging.LogDomains;
import java.util.Hashtable;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.resource.spi.ManagedConnection;
import javax.transaction.xa.XAException;
import javax.transaction.xa.XAResource;
import javax.transaction.xa.Xid;

public class ConnectorXAResource
implements XAResource {
    private Object userHandle = null;
    private ResourceSpec spec;
    private String poolName;
    private ResourceAllocator alloc;
    private PoolManager poolMgr = ConnectorRuntime.getRuntime().getPoolManager();
    private ManagedConnection localConnection;
    private ClientSecurityInfo info;
    private ConnectionEventListener listener;
    private ResourceHandle localHandle_;
    private static Hashtable listenerTable = new Hashtable();
    static Logger _logger = LogDomains.getLogger("javax.enterprise.resource.resourceadapter");

    public ConnectorXAResource(ResourceHandle handle, ResourceSpec spec, ResourceAllocator alloc, ClientSecurityInfo info) {
        this.spec = spec;
        this.poolName = spec.getConnectionPoolName();
        this.alloc = alloc;
        this.info = info;
        this.localConnection = (ManagedConnection)handle.getResource();
        this.localHandle_ = handle;
    }

    public void setUserHandle(Object userHandle) {
        this.userHandle = userHandle;
    }

    private void handleResourceException(Exception ex) throws XAException {
        _logger.log(Level.SEVERE, "poolmgr.system_exception", ex);
        XAException xae = new XAException(ex.toString());
        xae.errorCode = -3;
        throw xae;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void commit(Xid xid, boolean onePhase) throws XAException {
        try {
            ResourceHandle handle = this.getResourceHandle();
            ManagedConnection mc = (ManagedConnection)handle.getResource();
            mc.getLocalTransaction().commit();
        }
        catch (Exception ex) {
            this.handleResourceException(ex);
        }
        finally {
            this.resetAssociation();
        }
    }

    public void start(Xid xid, int flags) throws XAException {
        try {
            ResourceHandle handle = this.getResourceHandle();
            if (!this.localHandle_.equals(handle)) {
                ManagedConnection mc = (ManagedConnection)handle.getResource();
                mc.associateConnection(this.userHandle);
                LocalTxConnectionEventListener l = (LocalTxConnectionEventListener)handle.getListener();
                if (_logger.isLoggable(Level.FINE)) {
                    _logger.log(Level.FINE, "connection_sharing_start", this.userHandle);
                }
                l.associateHandle(this.userHandle, this.localHandle_);
            }
        }
        catch (Exception ex) {
            this.handleResourceException(ex);
        }
    }

    public void end(Xid xid, int flags) throws XAException {
        if (_logger.isLoggable(Level.FINE)) {
            _logger.log(Level.FINE, "connection_sharing_end");
        }
        try {
            LocalTxConnectionEventListener l;
            ResourceHandle handle;
            ResourceHandle handleInTransaction = this.getResourceHandle();
            if (!this.localHandle_.equals(handleInTransaction) && (handle = (l = (LocalTxConnectionEventListener)handleInTransaction.getListener()).removeAssociation(this.userHandle)) != null) {
                ManagedConnection associatedConnection = (ManagedConnection)handle.getResource();
                associatedConnection.associateConnection(this.userHandle);
                if (_logger.isLoggable(Level.FINE)) {
                    _logger.log(Level.FINE, "connection_sharing_reset_association", this.userHandle);
                }
            }
        }
        catch (Exception e) {
            this.handleResourceException(e);
        }
    }

    public void forget(Xid xid) throws XAException {
        _logger.fine("Well, forget is called for xid :" + xid);
    }

    public int getTransactionTimeout() throws XAException {
        return 0;
    }

    public boolean isSameRM(XAResource other) throws XAException {
        if (this == other) {
            return true;
        }
        if (other == null) {
            return false;
        }
        if (other instanceof ConnectorXAResource) {
            ConnectorXAResource obj = (ConnectorXAResource)other;
            return this.spec.equals(obj.spec) && this.info.equals(obj.info);
        }
        return false;
    }

    public int prepare(Xid xid) throws XAException {
        return 123456;
    }

    public Xid[] recover(int flag) throws XAException {
        return new Xid[0];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void rollback(Xid xid) throws XAException {
        try {
            ResourceHandle handle = this.getResourceHandle();
            ManagedConnection mc = (ManagedConnection)handle.getResource();
            mc.getLocalTransaction().rollback();
        }
        catch (Exception ex) {
            this.handleResourceException(ex);
        }
        finally {
            this.resetAssociation();
        }
    }

    public boolean setTransactionTimeout(int seconds) throws XAException {
        return false;
    }

    public static void freeListener(ManagedConnection mc) {
        listenerTable.remove(mc);
    }

    private ResourceHandle getResourceHandle() throws PoolingException {
        try {
            ResourceHandle h = null;
            JavaEETransactionManager txMgr = ConnectorRuntime.getRuntime().getTransactionManager();
            JavaEETransaction j2eetran = (JavaEETransaction)txMgr.getTransaction();
            h = j2eetran == null ? this.localHandle_ : (ResourceHandle)j2eetran.getNonXAResource();
            if (h.getResourceState().isUnenlisted()) {
                ManagedConnection mc = (ManagedConnection)h.getResource();
                mc.getLocalTransaction().begin();
            }
            return h;
        }
        catch (Exception ex) {
            _logger.log(Level.SEVERE, "poolmgr.system_exception", ex);
            throw new PoolingException(ex.toString(), ex);
        }
    }

    private void resetAssociation() throws XAException {
        try {
            ResourceHandle handle = this.getResourceHandle();
            LocalTxConnectionEventListener l = (LocalTxConnectionEventListener)handle.getListener();
            Map associatedHandles = l.getAssociatedHandles();
            if (associatedHandles != null) {
                Set userHandles = associatedHandles.entrySet();
                for (Map.Entry userHandleEntry : userHandles) {
                    ResourceHandle associatedHandle = (ResourceHandle)userHandleEntry.getValue();
                    ManagedConnection associatedConnection = (ManagedConnection)associatedHandle.getResource();
                    associatedConnection.associateConnection(userHandleEntry.getKey());
                    if (!_logger.isLoggable(Level.FINE)) continue;
                    _logger.log(Level.FINE, "connection_sharing_reset_association", userHandleEntry.getKey());
                }
                associatedHandles.clear();
            }
        }
        catch (Exception ex) {
            this.handleResourceException(ex);
        }
    }
}

