/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.security;

import com.sun.enterprise.security.audit.AuditManager;
import com.sun.enterprise.util.LocalStringManagerImpl;
import com.sun.logging.LogDomains;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.security.SecureRandom;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.glassfish.api.admin.ServerEnvironment;
import org.glassfish.internal.api.Globals;
import org.jvnet.hk2.annotations.Inject;
import org.jvnet.hk2.annotations.Scoped;
import org.jvnet.hk2.annotations.Service;
import org.jvnet.hk2.component.Habitat;
import org.jvnet.hk2.component.Singleton;

@Service
@Scoped(value=Singleton.class)
public class SecurityServicesUtil {
    private static Habitat habitat = Globals.getDefaultHabitat();
    private static final LocalStringManagerImpl _localStrings = new LocalStringManagerImpl(SecurityServicesUtil.class);
    private static final Logger _logger = LogDomains.getLogger("javax.enterprise.system.core.security");
    public static final SecureRandom secureRandom = new SecureRandom();
    @Inject
    ServerEnvironment env;
    @Inject
    private AuditManager auditManager;

    public void initSecureSeed() {
        File secureSeedFile = new File(this.env.getConfigDirPath(), "secure.seed");
        long seed = this.readSecureSeed(secureSeedFile);
        secureRandom.setSeed(seed);
        seed = secureRandom.nextLong();
        this.writeSecureSeed(secureSeedFile, seed);
        secureSeedFile = null;
    }

    private long readSecureSeed(File fname) {
        try {
            BufferedReader fis = new BufferedReader(new FileReader(fname));
            try {
                String line = fis.readLine();
                fis.close();
                Long lseed = new Long(line);
                return lseed;
            }
            catch (IOException e) {
                if (fis != null) {
                    fis.close();
                }
            }
        }
        catch (Throwable e) {
            // empty catch block
        }
        secureRandom.setSeed(System.currentTimeMillis());
        long newSeed = secureRandom.nextLong();
        return newSeed;
    }

    private void writeSecureSeed(File fname, long seed) {
        try {
            FileOutputStream fos = new FileOutputStream(fname);
            String sseed = Long.toString(seed);
            fos.write(sseed.getBytes());
            fos.close();
        }
        catch (IOException e) {
            String errmsg = _localStrings.getLocalString("j2ee.startupslow", "Cannot write the seed file for fast startup. The next startup will be slow.");
            _logger.log(Level.WARNING, errmsg);
        }
    }

    public Habitat getHabitat() {
        return habitat;
    }

    public AuditManager getAuditManager() {
        return this.auditManager;
    }

    public static SecurityServicesUtil getInstance() {
        return habitat.getComponent(SecurityServicesUtil.class);
    }

    static {
        secureRandom.setSeed(System.currentTimeMillis());
    }
}

