/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.security;

import com.sun.enterprise.security.util.IASSecurityException;
import com.sun.enterprise.util.LocalStringManagerImpl;
import com.sun.logging.LogDomains;
import java.security.Policy;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.security.jacc.PolicyConfiguration;
import javax.security.jacc.PolicyConfigurationFactory;
import javax.security.jacc.PolicyContextException;

public class SecurityUtil {
    public static final int APPCONTAINER_USERNAME_PASSWORD = 1;
    private static final LocalStringManagerImpl localStrings = new LocalStringManagerImpl(SecurityUtil.class);
    private static final Logger _logger = LogDomains.getLogger("javax.enterprise.system.core.security");
    public static final String VENDOR_PRESENT = "com.sun.enterprise.security.provider.jaccvendorpresent";
    private static final boolean vendorPresent = Boolean.getBoolean("com.sun.enterprise.security.provider.jaccvendorpresent");
    public static final String repository = System.getProperty("com.sun.enterprise.jaccprovider.property.repository");

    public static void generatePolicyFile(String name) throws IASSecurityException {
        assert (name != null);
        if (name == null) {
            throw new IASSecurityException("Invalid Module Name");
        }
        try {
            boolean inService = PolicyConfigurationFactory.getPolicyConfigurationFactory().inService(name);
            if (!inService) {
                PolicyConfigurationFactory pcf = PolicyConfigurationFactory.getPolicyConfigurationFactory();
                PolicyConfiguration pc = pcf.getPolicyConfiguration(name, false);
                pc.commit();
                if (_logger.isLoggable(Level.FINE)) {
                    _logger.fine("JACC: committed policy for context: " + name);
                }
            }
            Policy.getPolicy().refresh();
        }
        catch (ClassNotFoundException cnfe) {
            String msg = localStrings.getLocalString("enterprise.security.securityutil.classnotfound", "Could not find PolicyConfigurationFactory class. Check javax.security.jacc.PolicyConfigurationFactory.provider property");
            throw new IASSecurityException(msg);
        }
        catch (PolicyContextException pce) {
            throw new IASSecurityException(pce.toString());
        }
    }

    public static void removePolicy(String name) throws IASSecurityException {
        assert (name != null);
        if (name == null) {
            throw new IASSecurityException("Invalid Module Name");
        }
        try {
            boolean wasInService = PolicyConfigurationFactory.getPolicyConfigurationFactory().inService(name);
            PolicyConfiguration pc = PolicyConfigurationFactory.getPolicyConfigurationFactory().getPolicyConfiguration(name, false);
            pc.delete();
            if (wasInService) {
                Policy.getPolicy().refresh();
            }
        }
        catch (ClassNotFoundException cnfe) {
            String msg = localStrings.getLocalString("enterprise.security.securityutil.classnotfound", "Could not find PolicyConfigurationFactory class. Check javax.security.jacc.PolicyConfigurationFactory.provider property");
            throw new IASSecurityException(msg);
        }
        catch (PolicyContextException pce) {
            throw new IASSecurityException(pce.toString());
        }
    }

    public static boolean linkPolicyFile(String name, String linkName, boolean lastInService) throws IASSecurityException {
        boolean rvalue;
        block8: {
            rvalue = lastInService;
            assert (name != null);
            if (name == null) {
                throw new IASSecurityException("Invalid Module Name");
            }
            try {
                PolicyConfigurationFactory pcf = PolicyConfigurationFactory.getPolicyConfigurationFactory();
                boolean inService = pcf.inService(name);
                if (linkName == null) {
                    rvalue = inService;
                    break block8;
                }
                if (inService == lastInService) {
                    if (!inService) {
                        PolicyConfiguration pc = pcf.getPolicyConfiguration(name, false);
                        PolicyConfiguration linkPc = pcf.getPolicyConfiguration(linkName, false);
                        pc.linkConfiguration(linkPc);
                    }
                    break block8;
                }
                throw new IASSecurityException("Inconsistent Module State");
            }
            catch (ClassNotFoundException cnfe) {
                String msg = localStrings.getLocalString("enterprise.security.securityutil.classnotfound", "Could not find PolicyConfigurationFactory class. Check javax.security.jacc.PolicyConfigurationFactory.provider property");
                throw new IASSecurityException(msg);
            }
            catch (PolicyContextException pce) {
                throw new IASSecurityException(pce.toString());
            }
        }
        return rvalue;
    }
}

