/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.security.auth.realm.file;

import com.sun.enterprise.security.auth.realm.BadRealmException;
import com.sun.enterprise.security.auth.realm.IASRealm;
import com.sun.enterprise.security.auth.realm.NoSuchRealmException;
import com.sun.enterprise.security.auth.realm.NoSuchUserException;
import com.sun.enterprise.security.auth.realm.Realm;
import com.sun.enterprise.security.auth.realm.User;
import com.sun.enterprise.security.auth.realm.file.FileRealmUser;
import com.sun.enterprise.security.util.IASSecurityException;
import com.sun.enterprise.security.util.SSHA;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.security.SecureRandom;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Map;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.Vector;
import java.util.logging.Level;
import org.jvnet.hk2.annotations.Service;

@Service
public final class FileRealm
extends IASRealm {
    public static final String AUTH_TYPE = "filepassword";
    public static final String PARAM_KEYFILE = "file";
    private static final String FIELD_SEP = ";";
    private static final String GROUP_SEP = ",";
    private static final String COMMENT = "#";
    public static final String MISC_VALID_CHARS = "_-.";
    private static final int SALT_SIZE = 8;
    private Map userTable;
    private Hashtable groupSizeMap;
    private boolean constructed = false;

    public FileRealm(String keyfile) throws BadRealmException, NoSuchRealmException {
        File fp = new File(keyfile);
        if (!fp.exists()) {
            FileOutputStream fout = null;
            try {
                fout = new FileOutputStream(fp);
                fout.write("\n".getBytes());
            }
            catch (Exception e) {
                String msg = sm.getString("filerealm.noaccess", e.toString());
                throw new BadRealmException(msg);
            }
            finally {
                if (fout != null) {
                    try {
                        fout.close();
                    }
                    catch (Exception ex) {}
                }
            }
        }
        this.constructed = true;
        Properties p = new Properties();
        p.setProperty(PARAM_KEYFILE, keyfile);
        p.setProperty("jaas-context", "ignore");
        this.init(p);
    }

    public FileRealm() {
    }

    protected void init(Properties props) throws BadRealmException, NoSuchRealmException {
        super.init(props);
        String file = props.getProperty(PARAM_KEYFILE);
        if (file == null) {
            String msg = sm.getString("filerealm.nofile");
            throw new BadRealmException(msg);
        }
        this.setProperty(PARAM_KEYFILE, file);
        String jaasCtx = props.getProperty("jaas-context");
        if (jaasCtx == null) {
            String msg = sm.getString("filerealm.nomodule");
            throw new BadRealmException(msg);
        }
        this.setProperty("jaas-context", jaasCtx);
        if (_logger.isLoggable(Level.FINE)) {
            _logger.fine("FileRealm : file=" + file);
            _logger.fine("FileRealm : jaas-context=" + jaasCtx);
        }
        this.loadKeyFile();
    }

    public String getAuthType() {
        return AUTH_TYPE;
    }

    public Enumeration getUserNames() throws BadRealmException {
        return new Vector(this.userTable.keySet()).elements();
    }

    public User getUser(String name) throws NoSuchUserException {
        FileRealmUser u = (FileRealmUser)this.userTable.get(name);
        if (u == null) {
            String msg = sm.getString("filerealm.nouser", name);
            throw new NoSuchUserException(msg);
        }
        return u;
    }

    public Enumeration getGroupNames() throws BadRealmException {
        return this.groupSizeMap.keys();
    }

    public Enumeration getGroupNames(String username) throws NoSuchUserException {
        FileRealmUser ud = (FileRealmUser)this.userTable.get(username);
        if (ud == null) {
            String msg = sm.getString("filerealm.nouser", username);
            throw new NoSuchUserException(msg);
        }
        String[] groups = ud.getGroups();
        groups = this.addAssignGroups(groups);
        Vector<String> v = new Vector<String>();
        if (groups != null) {
            for (int i = 0; i < groups.length; ++i) {
                v.add(groups[i]);
            }
        }
        return v.elements();
    }

    public void refresh() throws BadRealmException {
        if (_logger.isLoggable(Level.FINE)) {
            _logger.fine("Reloading file realm data.");
        }
        FileRealm newRealm = new FileRealm();
        try {
            newRealm.init(this.getProperties());
            Realm.updateInstance(newRealm, this.getName());
        }
        catch (Exception e) {
            throw new BadRealmException(e.toString());
        }
    }

    public String[] authenticate(String user, String password) {
        FileRealmUser ud = (FileRealmUser)this.userTable.get(user);
        if (ud == null) {
            if (_logger.isLoggable(Level.FINE)) {
                _logger.fine("No such user: [" + user + "]");
            }
            return null;
        }
        boolean ok = false;
        try {
            ok = SSHA.verify(ud.getSalt(), ud.getHash(), password.getBytes());
        }
        catch (Exception e) {
            _logger.fine("File authentication failed: " + e.toString());
            return null;
        }
        if (!ok) {
            if (_logger.isLoggable(Level.FINE)) {
                _logger.fine("File authentication failed for: [" + user + "]");
            }
            return null;
        }
        String[] groups = ud.getGroups();
        groups = this.addAssignGroups(groups);
        return groups;
    }

    private static boolean isValid(String s, boolean userName) {
        for (int i = 0; i < s.length(); ++i) {
            char c = s.charAt(i);
            if (Character.isLetterOrDigit(c) || Character.isWhitespace(c) || MISC_VALID_CHARS.indexOf(c) != -1 || userName && c == '@') continue;
            return false;
        }
        return true;
    }

    public static void validateUserName(String name) throws IASSecurityException {
        if (name == null || name.length() == 0) {
            String msg = sm.getString("filerealm.noname");
            throw new IASSecurityException(msg);
        }
        if (!FileRealm.isValid(name, true)) {
            String msg = sm.getString("filerealm.badname", name);
            throw new IASSecurityException(msg);
        }
        if (!name.equals(name.trim())) {
            String msg = sm.getString("filerealm.badspaces", name);
            throw new IASSecurityException(msg);
        }
    }

    public static void validatePassword(String pwd) throws IASSecurityException {
        if (pwd == null) {
            String msg = sm.getString("filerealm.emptypwd");
            throw new IASSecurityException(msg);
        }
        if (!pwd.equals(pwd.trim())) {
            String msg = sm.getString("filerealm.badspacespwd");
            throw new IASSecurityException(msg);
        }
    }

    public static void validateGroupName(String group) throws IASSecurityException {
        if (group == null || group.length() == 0) {
            String msg = sm.getString("filerealm.nogroup");
            throw new IASSecurityException(msg);
        }
        if (!FileRealm.isValid(group, false)) {
            String msg = sm.getString("filerealm.badchars", group);
            throw new IASSecurityException(msg);
        }
        if (!group.equals(group.trim())) {
            String msg = sm.getString("filerealm.badspaces", group);
            throw new IASSecurityException(msg);
        }
    }

    public static void validateGroupList(String[] groupList) throws IASSecurityException {
        if (groupList == null || groupList.length == 0) {
            return;
        }
        for (int i = 0; i < groupList.length; ++i) {
            FileRealm.validateGroupName(groupList[i]);
        }
    }

    public synchronized void addUser(String name, String password, String[] groupList) throws BadRealmException, IASSecurityException {
        FileRealm.validateUserName(name);
        FileRealm.validatePassword(password);
        FileRealm.validateGroupList(groupList);
        if (this.userTable.containsKey(name)) {
            String msg = sm.getString("filerealm.dupuser", name);
            throw new BadRealmException(msg);
        }
        this.addGroupNames(groupList);
        FileRealmUser ud = FileRealm.createNewUser(name, password, groupList);
        this.userTable.put(name, ud);
    }

    public synchronized void removeUser(String name) throws NoSuchUserException, BadRealmException {
        if (!this.userTable.containsKey(name)) {
            String msg = sm.getString("filerealm.nouser", name);
            throw new NoSuchUserException(msg);
        }
        FileRealmUser oldUser = (FileRealmUser)this.userTable.get(name);
        this.userTable.remove(name);
        this.reduceGroups(oldUser.getGroups());
    }

    public synchronized void updateUser(String name, String password, String[] groups) throws NoSuchUserException, BadRealmException, IASSecurityException {
        this.updateUser(name, name, password, groups);
    }

    public synchronized void updateUser(String name, String newName, String password, String[] groups) throws NoSuchUserException, BadRealmException, IASSecurityException {
        FileRealm.validateUserName(name);
        if (!this.userTable.containsKey(name)) {
            String msg = sm.getString("filerealm.nouser", name);
            throw new NoSuchUserException(msg);
        }
        FileRealm.validateUserName(newName);
        FileRealm.validateGroupList(groups);
        if (password != null) {
            FileRealm.validatePassword(password);
        }
        if (!name.equals(newName) && this.userTable.containsKey(newName)) {
            String msg = sm.getString("filerealm.dupuser", name);
            throw new BadRealmException(msg);
        }
        FileRealmUser oldUser = (FileRealmUser)this.userTable.get(name);
        assert (oldUser != null);
        FileRealmUser newUser = new FileRealmUser(newName);
        this.changeGroups(oldUser.getGroups(), groups);
        newUser.setGroups(groups);
        if (password == null) {
            newUser.setSalt(oldUser.getSalt());
            newUser.setHash(oldUser.getHash());
        } else {
            FileRealm.setPassword(newUser, password);
        }
        this.userTable.remove(name);
        this.userTable.put(newName, newUser);
    }

    public boolean supportsUserManagement() {
        return true;
    }

    public void persist() throws BadRealmException {
        String file = this.getProperty(PARAM_KEYFILE);
        try {
            this.writeKeyFile(file);
        }
        catch (IOException ex) {
            throw new BadRealmException(ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeKeyFile(String filename) throws IOException {
        Class<FileRealm> clazz = FileRealm.class;
        synchronized (FileRealm.class) {
            FileOutputStream out = null;
            try {
                out = new FileOutputStream(filename);
                for (String name : this.userTable.keySet()) {
                    FileRealmUser ud = (FileRealmUser)this.userTable.get(name);
                    String entry = FileRealm.encodeUser(name, ud);
                    out.write(entry.getBytes());
                }
            }
            catch (IOException e) {
                throw e;
            }
            catch (Exception e) {
                String msg = sm.getString("filerealm.badwrite", e.toString());
                throw new IOException(msg);
            }
            finally {
                if (out != null) {
                    out.close();
                }
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            if (_logger.isLoggable(Level.FINE)) {
                _logger.fine("Done writing " + filename);
            }
            return;
        }
    }

    private void addGroupNames(String[] groupList) {
        if (groupList != null) {
            for (int i = 0; i < groupList.length; ++i) {
                Integer groupSize = (Integer)this.groupSizeMap.get(groupList[i]);
                this.groupSizeMap.put(groupList[i], groupSize != null ? new Integer(groupSize + 1) : new Integer(1));
            }
        }
    }

    private void reduceGroups(String[] groupList) {
        if (groupList != null) {
            for (int i = 0; i < groupList.length; ++i) {
                Integer groupSize = (Integer)this.groupSizeMap.get(groupList[i]);
                if (groupSize == null) continue;
                int gpSize = groupSize - 1;
                if (gpSize > 0) {
                    this.groupSizeMap.put(groupList[i], new Integer(gpSize));
                    continue;
                }
                this.groupSizeMap.remove(groupList[i]);
            }
        }
    }

    private void changeGroups(String[] oldGroupList, String[] newGroupList) {
        this.addGroupNames(newGroupList);
        this.reduceGroups(oldGroupList);
    }

    private void loadKeyFile() throws BadRealmException {
        String file = this.getProperty(PARAM_KEYFILE);
        _logger.fine("Reading file realm: " + file);
        this.userTable = new Hashtable();
        this.groupSizeMap = new Hashtable();
        BufferedReader input = null;
        try {
            input = new BufferedReader(new FileReader(file));
            while (input.ready()) {
                String line = input.readLine();
                if (line.startsWith(COMMENT) || line.indexOf(FIELD_SEP) <= 0) continue;
                FileRealmUser ud = FileRealm.decodeUser(line, this.groupSizeMap);
                this.userTable.put(ud.getName(), ud);
            }
        }
        catch (Exception e) {
            _logger.log(Level.WARNING, "filerealm.readerror", e);
            throw new BadRealmException(e.toString());
        }
        finally {
            if (input != null) {
                try {
                    input.close();
                }
                catch (Exception ex) {}
            }
        }
    }

    private static String encodeUser(String name, FileRealmUser ud) {
        StringBuffer sb = new StringBuffer();
        Object cryptPwd = null;
        sb.append(name);
        sb.append(FIELD_SEP);
        String ssha = SSHA.encode(ud.getSalt(), ud.getHash());
        sb.append(ssha);
        sb.append(FIELD_SEP);
        String[] groups = ud.getGroups();
        if (groups != null) {
            for (int grp = 0; grp < groups.length; ++grp) {
                if (grp > 0) {
                    sb.append(GROUP_SEP);
                }
                sb.append(groups[grp]);
            }
        }
        sb.append("\n");
        return sb.toString();
    }

    private static FileRealmUser decodeUser(String encodedLine, Map newGroupSizeMap) throws IASSecurityException {
        StringTokenizer st = new StringTokenizer(encodedLine, FIELD_SEP);
        String user = null;
        String pwdInfo = null;
        String groupList = null;
        try {
            user = st.nextToken();
            pwdInfo = st.nextToken();
        }
        catch (Exception e) {
            String msg = sm.getString("filerealm.syntaxerror", encodedLine);
            throw new IASSecurityException(msg);
        }
        if (st.hasMoreTokens()) {
            groupList = st.nextToken();
        }
        byte[] hash = new byte[20];
        byte[] salt = SSHA.decode(pwdInfo, hash);
        FileRealmUser ud = new FileRealmUser(user);
        ud.setHash(hash);
        ud.setSalt(salt);
        Vector<String> membership = new Vector<String>();
        if (groupList != null) {
            StringTokenizer gst = new StringTokenizer(groupList, GROUP_SEP);
            while (gst.hasMoreTokens()) {
                String g = gst.nextToken();
                membership.add(g);
                Integer groupSize = (Integer)newGroupSizeMap.get(g);
                newGroupSizeMap.put(g, groupSize != null ? new Integer(groupSize + 1) : new Integer(1));
            }
        }
        ud.setGroups(membership);
        return ud;
    }

    private static FileRealmUser createNewUser(String name, String pwd, String[] groups) throws IASSecurityException {
        FileRealmUser ud = new FileRealmUser(name);
        if (groups == null) {
            groups = new String[]{};
        }
        ud.setGroups(groups);
        FileRealm.setPassword(ud, pwd);
        return ud;
    }

    private static void setPassword(FileRealmUser user, String pwd) throws IASSecurityException {
        assert (user != null);
        byte[] pwdBytes = pwd.getBytes();
        SecureRandom rng = new SecureRandom();
        byte[] salt = new byte[8];
        rng.nextBytes(salt);
        user.setSalt(salt);
        byte[] hash = SSHA.compute(salt, pwdBytes);
        user.setHash(hash);
    }

    public static void main(String[] args) {
        if (args.length == 0) {
            FileRealm.help();
        }
        try {
            if ("-c".equals(args[0])) {
                String[] groups = new String[]{};
                if (args.length > 3) {
                    groups = new String[args.length - 3];
                    for (int i = 3; i < args.length; ++i) {
                        groups[i - 3] = args[i];
                    }
                }
                FileRealmUser ud = FileRealm.createNewUser(args[1], args[2], groups);
                String out = FileRealm.encodeUser(args[1], ud);
                System.out.println(out);
                FileRealmUser u = FileRealm.decodeUser(out, new Hashtable());
                System.out.println("verifies: " + SSHA.verify(u.getSalt(), u.getHash(), args[2].getBytes()));
            } else if ("-v".equals(args[0])) {
                FileRealmUser u = FileRealm.decodeUser(args[2], new Hashtable());
                System.out.println("user: " + u.getName());
                System.out.println("verifies: " + SSHA.verify(u.getSalt(), u.getHash(), args[1].getBytes()));
            }
        }
        catch (Exception e) {
            e.printStackTrace(System.out);
        }
    }

    private static void help() {
        System.out.println("FileRealm -c <name  <pwd  [group]*");
        System.out.println("FileRealm -v <pwd  `output of -c`");
        System.exit(1);
    }
}

