/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.security.jmac.config;

import com.sun.enterprise.config.serverbeans.MessageSecurityConfig;
import com.sun.enterprise.config.serverbeans.Property;
import com.sun.enterprise.config.serverbeans.ProviderConfig;
import com.sun.enterprise.config.serverbeans.RequestPolicy;
import com.sun.enterprise.config.serverbeans.ResponsePolicy;
import com.sun.enterprise.config.serverbeans.SecurityService;
import com.sun.enterprise.security.common.Util;
import com.sun.enterprise.security.jmac.AuthMessagePolicy;
import com.sun.enterprise.security.jmac.config.ConfigParser;
import com.sun.enterprise.security.jmac.config.GFServerConfigProvider;
import com.sun.logging.LogDomains;
import java.io.IOException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.security.auth.message.MessagePolicy;
import sun.security.util.PropertyExpander;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConfigDomainParser
implements ConfigParser {
    private static Logger _logger = null;
    private Map configMap = new HashMap();
    private Set<String> layersWithDefault = new HashSet<String>();

    ConfigDomainParser() throws IOException {
    }

    @Override
    public void initialize(Object service) throws IOException {
        if (service == null) {
            service = Util.getDefaultHabitat().getComponent(SecurityService.class);
        }
        if (!(service instanceof SecurityService)) {
            throw new IOException("invalid configBean type passed to parser");
        }
        this.processServerConfig((SecurityService)service, this.configMap);
    }

    private void processServerConfig(SecurityService service, Map newConfig) throws IOException {
        List<MessageSecurityConfig> configList = service.getMessageSecurityConfig();
        if (configList != null) {
            for (MessageSecurityConfig next : configList) {
                String intercept = this.parseInterceptEntry(next, newConfig);
                List<ProviderConfig> provList = next.getProviderConfig();
                if (provList == null) continue;
                for (ProviderConfig provider : provList) {
                    this.parseIDEntry(provider, newConfig, intercept);
                }
            }
        }
    }

    @Override
    public Map getConfigMap() {
        return this.configMap;
    }

    @Override
    public Set<String> getLayersWithDefault() {
        return this.layersWithDefault;
    }

    private String parseInterceptEntry(MessageSecurityConfig msgConfig, Map newConfig) throws IOException {
        GFServerConfigProvider.InterceptEntry intEntry;
        String intercept = null;
        String defaultServerID = null;
        String defaultClientID = null;
        intercept = msgConfig.getAuthLayer();
        defaultServerID = msgConfig.getDefaultProvider();
        defaultClientID = msgConfig.getDefaultClientProvider();
        if (_logger.isLoggable(Level.FINE)) {
            _logger.fine("Intercept Entry: \n    intercept: " + intercept + "\n    defaultServerID: " + defaultServerID + "\n    defaultClientID:  " + defaultClientID);
        }
        if (defaultServerID != null || defaultClientID != null) {
            this.layersWithDefault.add(intercept);
        }
        if ((intEntry = (GFServerConfigProvider.InterceptEntry)newConfig.get(intercept)) != null) {
            throw new IOException("found multiple MessageSecurityConfig entries with the same auth-layer");
        }
        intEntry = new GFServerConfigProvider.InterceptEntry(defaultClientID, defaultServerID, null);
        newConfig.put(intercept, intEntry);
        return intercept;
    }

    private void parseIDEntry(ProviderConfig pConfig, Map newConfig, String intercept) throws IOException {
        String id = pConfig.getProviderId();
        String type = pConfig.getProviderType();
        String moduleClass = pConfig.getClassName();
        MessagePolicy requestPolicy = this.parsePolicy(pConfig.getRequestPolicy());
        MessagePolicy responsePolicy = this.parsePolicy(pConfig.getResponsePolicy());
        HashMap<String, String> options = new HashMap<String, String>();
        List<Property> pList = pConfig.getProperty();
        if (pList != null) {
            for (Property property : pList) {
                try {
                    options.put(property.getName(), PropertyExpander.expand(property.getValue(), false));
                }
                catch (PropertyExpander.ExpandException ee) {
                    if (_logger.isLoggable(Level.WARNING)) {
                        _logger.warning("jmac.unexpandedproperty");
                    }
                    options.put(property.getName(), property.getValue());
                }
            }
        }
        if (_logger.isLoggable(Level.FINE)) {
            _logger.fine("ID Entry: \n    module class: " + moduleClass + "\n    id: " + id + "\n    type: " + type + "\n    request policy: " + requestPolicy + "\n    response policy: " + responsePolicy + "\n    options: " + options);
        }
        GFServerConfigProvider.IDEntry idEntry = new GFServerConfigProvider.IDEntry(type, moduleClass, requestPolicy, responsePolicy, options);
        GFServerConfigProvider.InterceptEntry intEntry = (GFServerConfigProvider.InterceptEntry)newConfig.get(intercept);
        if (intEntry == null) {
            throw new IOException("intercept entry for " + intercept + " must be specified before ID entries");
        }
        if (intEntry.idMap == null) {
            intEntry.idMap = new HashMap();
        }
        intEntry.idMap.put(id, idEntry);
    }

    private MessagePolicy parsePolicy(RequestPolicy policy) {
        if (policy == null) {
            return null;
        }
        String authSource = policy.getAuthSource();
        String authRecipient = policy.getAuthRecipient();
        return AuthMessagePolicy.getMessagePolicy(authSource, authRecipient);
    }

    private MessagePolicy parsePolicy(ResponsePolicy policy) {
        if (policy == null) {
            return null;
        }
        String authSource = policy.getAuthSource();
        String authRecipient = policy.getAuthRecipient();
        return AuthMessagePolicy.getMessagePolicy(authSource, authRecipient);
    }

    static {
        _logger = LogDomains.getLogger("javax.enterprise.system.core.security");
    }
}

