/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.server.logging;

import com.sun.enterprise.admin.monitor.callflow.Agent;
import com.sun.enterprise.server.logging.LogRotationTimer;
import com.sun.enterprise.server.logging.LogRotationTimerTask;
import com.sun.enterprise.server.logging.UniformLogFormatter;
import com.sun.enterprise.util.io.FileUtils;
import com.sun.enterprise.v3.common.BooleanLatch;
import com.sun.enterprise.v3.logging.AgentFormatterDelegate;
import com.sun.enterprise.v3.server.ServerEnvironmentImpl;
import com.sun.logging.LogDomains;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.text.FieldPosition;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.Iterator;
import java.util.Vector;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.logging.ErrorManager;
import java.util.logging.Formatter;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.LogManager;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import java.util.logging.StreamHandler;
import org.glassfish.api.logging.Task;
import org.glassfish.config.support.TranslatedConfigView;
import org.glassfish.internal.api.ServerContext;
import org.jvnet.hk2.annotations.ContractProvided;
import org.jvnet.hk2.annotations.Inject;
import org.jvnet.hk2.annotations.Scoped;
import org.jvnet.hk2.annotations.Service;
import org.jvnet.hk2.component.PostConstruct;
import org.jvnet.hk2.component.PreDestroy;
import org.jvnet.hk2.component.Singleton;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Service
@Scoped(value=Singleton.class)
@ContractProvided(value=Handler.class)
public class FileandSyslogHandler
extends StreamHandler
implements PostConstruct,
PreDestroy {
    @Inject
    ServerContext serverContext;
    @Inject
    ServerEnvironmentImpl env;
    @Inject(optional=true)
    Agent agent;
    private MeteredStream meter;
    private static final String LOGS_DIR = "logs";
    private String logFileName = "server.log";
    private File absoluteFile = null;
    private static final String LOGGING_MAX_HISTORY_FILES = "com.sun.enterprise.server.logging.max_history_files";
    private static final int MINIMUM_FILE_ROTATION_VALUE = 500000;
    private int limitForFileRotation = 0;
    private BlockingQueue<LogRecord> pendingRecords = new ArrayBlockingQueue<LogRecord>(5000);
    private AtomicBoolean rotationRequested = new AtomicBoolean(false);
    private static final String LOG_ROTATE_DATE_FORMAT = "yyyy-MM-dd'T'HH-mm-ss";
    private static final SimpleDateFormat logRotateDateFormatter = new SimpleDateFormat("yyyy-MM-dd'T'HH-mm-ss");
    private BooleanLatch done = new BooleanLatch();
    private Thread pump;
    private static final int MAX_RECENT_ERRORS = 4;
    private static ArrayBlockingQueue<LogRecord> recentErrors = new ArrayBlockingQueue<LogRecord>(4){

        @Override
        public void put(LogRecord logRecord) throws InterruptedException {
            if (this.remainingCapacity() == 0) {
                this.take();
            }
            super.put(logRecord);
        }
    };

    public static Iterator<LogRecord> getRecentErrorMessages() {
        Vector v = new Vector();
        recentErrors.drainTo(v);
        return v.iterator();
    }

    public static void clearRecentErrorMessages() {
        recentErrors.clear();
    }

    @Override
    public void postConstruct() {
        String cname;
        LogManager manager = LogManager.getLogManager();
        String fileName = TranslatedConfigView.getTranslatedValue(manager.getProperty((cname = this.getClass().getName()) + ".file")).toString();
        File serverLog = new File(fileName);
        if (!serverLog.isAbsolute()) {
            serverLog = new File(this.env.getDomainRoot(), fileName);
        }
        this.changeFileName(serverLog);
        Long rotationTimeLimitValue = 0L;
        try {
            rotationTimeLimitValue = Long.parseLong(manager.getProperty(cname + ".rotationTimelimitInMinutes"));
        }
        catch (NumberFormatException e) {
            Logger.getAnonymousLogger().log(Level.SEVERE, "Cannot read rotationTimelimitInMinutes property from logging config file");
        }
        if (rotationTimeLimitValue != 0L) {
            Task rotationTask = new Task(){

                public Object run() {
                    FileandSyslogHandler.this.rotate();
                    return null;
                }
            };
            LogRotationTimer.getInstance().startTimer(new LogRotationTimerTask(rotationTask, rotationTimeLimitValue));
            this.setLimitForRotation(0);
        } else {
            Integer rotationLimitAttrValue = 0;
            try {
                rotationLimitAttrValue = Integer.parseInt(manager.getProperty(cname + ".rotationLimitInBytes"));
            }
            catch (NumberFormatException e) {
                Logger.getAnonymousLogger().log(Level.SEVERE, "Cannot read rotationLimitInBytes property from logging config file");
            }
            this.setLimitForRotation(rotationLimitAttrValue);
        }
        this.setLevel(Level.ALL);
        String formatterName = manager.getProperty(cname + ".formatter");
        if (formatterName == null || UniformLogFormatter.class.getName().equals(formatterName)) {
            if (this.agent != null) {
                this.setFormatter(new UniformLogFormatter(new AgentFormatterDelegate(this.agent)));
            } else {
                this.setFormatter(new UniformLogFormatter());
            }
        } else {
            try {
                this.setFormatter((Formatter)this.getClass().getClassLoader().loadClass(formatterName).newInstance());
            }
            catch (InstantiationException e) {
                Logger.getAnonymousLogger().log(Level.SEVERE, "Cannot instantiate formatter " + formatterName, e);
            }
            catch (IllegalAccessException e) {
                Logger.getAnonymousLogger().log(Level.SEVERE, "Cannot instantiate formatter " + formatterName, e);
            }
            catch (ClassNotFoundException e) {
                Logger.getAnonymousLogger().log(Level.SEVERE, "Cannot load formatter class " + formatterName, e);
            }
        }
        this.pump = new Thread(){

            public void run() {
                try {
                    while (!FileandSyslogHandler.this.done.isSignalled()) {
                        FileandSyslogHandler.this.log();
                    }
                }
                catch (RuntimeException runtimeException) {
                    // empty catch block
                }
            }
        };
        this.pump.start();
    }

    @Override
    public void preDestroy() {
        LogDomains.getLogger("javax.enterprise.system.tools.admin").fine("Logger handler killed");
        this.done.tryReleaseShared(1);
        this.pump.interrupt();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void changeFileName(File file) {
        if (file.equals(this.absoluteFile)) {
            return;
        }
        FileandSyslogHandler fileandSyslogHandler = this;
        synchronized (fileandSyslogHandler) {
            super.flush();
            super.close();
            try {
                this.openFile(file);
                this.absoluteFile = file;
            }
            catch (IOException ix) {
                new ErrorManager().error("FATAL ERROR: COULD NOT OPEN LOG FILE. Please Check to make sure that the directory for Logfile exists. Currently reverting back to use the  default server.log", ix, 4);
                try {
                    this.openFile(this.absoluteFile);
                }
                catch (Exception e) {
                    new ErrorManager().error("FATAL ERROR: COULD NOT RE-OPEN SERVER LOG FILE. ", e, 4);
                }
            }
        }
    }

    File getCurrentLogFile() {
        return this.absoluteFile;
    }

    synchronized void setLimitForRotation(int rotationLimitInBytes) {
        if (rotationLimitInBytes == 0 || rotationLimitInBytes >= 500000) {
            this.limitForFileRotation = rotationLimitInBytes;
        }
    }

    private void openFile(File file) throws IOException {
        File parent = file.getParentFile();
        if (!parent.exists()) {
            parent.mkdirs();
        }
        FileOutputStream fout = new FileOutputStream(file, true);
        BufferedOutputStream bout = new BufferedOutputStream(fout);
        this.meter = new MeteredStream(bout, file.length());
        this.setOutputStream(this.meter);
    }

    void requestRotation() {
        this.rotationRequested.set(true);
    }

    public void cleanUpHistoryLogFiles() {
        String nStr = System.getProperty(LOGGING_MAX_HISTORY_FILES);
        if (nStr == null) {
            return;
        }
        int maxHistryFiles = 10;
        if (!"".equals(nStr)) {
            try {
                maxHistryFiles = Integer.parseInt(nStr);
            }
            catch (NumberFormatException e) {
                // empty catch block
            }
        }
        if (maxHistryFiles < 0) {
            return;
        }
        File dir = this.absoluteFile.getParentFile();
        if (dir == null) {
            return;
        }
        File[] fset = dir.listFiles();
        ArrayList<String> candidates = new ArrayList<String>();
        for (int i = 0; fset != null && i < fset.length; ++i) {
            if (this.logFileName.equals(fset[i].getName()) || !fset[i].isFile() || !fset[i].getName().startsWith(this.logFileName)) continue;
            candidates.add(fset[i].getAbsolutePath());
        }
        if (candidates.size() <= maxHistryFiles) {
            return;
        }
        Object[] pathes = candidates.toArray();
        Arrays.sort(pathes);
        try {
            for (int i = 0; i < pathes.length - maxHistryFiles; ++i) {
                new File((String)pathes[i]).delete();
            }
        }
        catch (Exception e) {
            new ErrorManager().error("FATAL ERROR: COULD NOT DELETE LOG FILE..", e, 0);
        }
    }

    private void rotate() {
        final FileandSyslogHandler thisInstance = this;
        AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                thisInstance.flush();
                thisInstance.close();
                try {
                    File oldFile = FileandSyslogHandler.this.absoluteFile;
                    StringBuffer renamedFileName = new StringBuffer(FileandSyslogHandler.this.absoluteFile + "_");
                    logRotateDateFormatter.format(new Date(), renamedFileName, new FieldPosition(0));
                    File rotatedFile = new File(renamedFileName.toString());
                    boolean renameSuccess = oldFile.renameTo(rotatedFile);
                    if (!renameSuccess) {
                        FileUtils.copy(FileandSyslogHandler.this.absoluteFile, rotatedFile);
                        File freshServerLogFile = FileandSyslogHandler.this.getLogFileName();
                        FileOutputStream fo = new FileOutputStream(freshServerLogFile);
                        fo.close();
                    }
                    FileandSyslogHandler.this.openFile(FileandSyslogHandler.this.getLogFileName());
                    LogRotationTimer.getInstance().restartTimer();
                    FileandSyslogHandler.this.cleanUpHistoryLogFiles();
                }
                catch (IOException ix) {
                    FileandSyslogHandler.this.publish(new LogRecord(Level.SEVERE, "Error, could not rotate log : " + ix.getMessage()));
                }
                return null;
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void log() {
        LogRecord record;
        try {
            record = this.pendingRecords.take();
        }
        catch (InterruptedException e) {
            return;
        }
        super.publish(record);
        this.flush();
        if (this.rotationRequested.get() || this.limitForFileRotation > 0 && this.meter.written >= (long)this.limitForFileRotation) {
            AtomicBoolean atomicBoolean = this.rotationRequested;
            synchronized (atomicBoolean) {
                this.rotate();
                this.rotationRequested.set(true);
            }
        }
        if (record.getLevel().intValue() >= Level.WARNING.intValue()) {
            recentErrors.offer(record);
        }
    }

    @Override
    public void publish(LogRecord record) {
        this.pendingRecords.add(record);
    }

    protected File getLogFileName() {
        return new File(new File(this.serverContext.getInstallRoot(), LOGS_DIR), this.logFileName);
    }

    private final class MeteredStream
    extends OutputStream {
        OutputStream out;
        long written;

        MeteredStream(OutputStream out, long written) {
            this.out = out;
            this.written = written;
        }

        public void write(int b) throws IOException {
            this.out.write(b);
            ++this.written;
        }

        public void write(byte[] buff) throws IOException {
            this.out.write(buff);
            this.written += (long)buff.length;
        }

        public void write(byte[] buff, int off, int len) throws IOException {
            this.out.write(buff, off, len);
            this.written += (long)len;
        }

        public void flush() throws IOException {
            this.out.flush();
        }

        public void close() throws IOException {
            this.out.close();
        }
    }
}

