/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.v3.admin;

import com.sun.enterprise.config.serverbeans.Domain;
import com.sun.enterprise.v3.admin.V2DottedNameSupport;
import java.util.HashMap;
import java.util.Map;
import org.glassfish.api.ActionReport;
import org.glassfish.api.Param;
import org.glassfish.api.admin.AdminCommand;
import org.glassfish.api.admin.AdminCommandContext;
import org.jvnet.hk2.annotations.Inject;
import org.jvnet.hk2.annotations.Service;
import org.jvnet.hk2.config.Dom;

@Service(name="get")
public class GetCommand
extends V2DottedNameSupport
implements AdminCommand {
    @Inject
    Domain domain;
    @Param(primary=true)
    String pattern = "";

    public void execute(AdminCommandContext context) {
        ActionReport report = context.getActionReport();
        V2DottedNameSupport.TreeNode[] parentNodes = this.getAliasedParent(this.domain, this.pattern);
        HashMap<Dom, String> dottedNames = new HashMap<Dom, String>();
        for (V2DottedNameSupport.TreeNode parentNode : parentNodes) {
            dottedNames.putAll(this.getAllDottedNodes(parentNode.node));
        }
        this.pattern = parentNodes[0].relativeName;
        Map<Dom, String> matchingNodes = this.getMatchingNodes(dottedNames, this.pattern);
        if (matchingNodes.isEmpty() && this.pattern.lastIndexOf(46) != -1) {
            matchingNodes = this.getMatchingNodes(dottedNames, this.pattern.substring(0, this.pattern.lastIndexOf(".")));
        }
        for (Map.Entry<Dom, String> node : matchingNodes.entrySet()) {
            if (node.getKey().model.targetTypeName.equals("com.sun.enterprise.config.serverbeans.Property")) {
                ActionReport.MessagePart part = report.getTopMessagePart().addChild();
                part.setChildrenType("DottedName");
                part.setMessage(node.getValue() + "=" + node.getKey().attribute("value"));
                continue;
            }
            for (Map.Entry<String, String> name : this.getNodeAttributes(node.getKey(), this.pattern).entrySet()) {
                String finalDottedName = node.getValue() + "." + name.getKey();
                if (!this.matches(finalDottedName, this.pattern)) continue;
                ActionReport.MessagePart part = report.getTopMessagePart().addChild();
                part.setChildrenType("DottedName");
                part.setMessage(node.getValue() + "." + name.getKey() + "=" + name.getValue());
            }
        }
    }
}

