/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.v3.admin.commands;

import com.sun.enterprise.config.serverbeans.JavaConfig;
import com.sun.enterprise.util.i18n.StringManager;
import com.sun.enterprise.v3.admin.commands.Joe;
import com.sun.enterprise.v3.admin.commands.ListJvmOptions;
import java.beans.PropertyVetoException;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.glassfish.api.ActionReport;
import org.glassfish.api.I18n;
import org.glassfish.api.Param;
import org.glassfish.api.admin.AdminCommand;
import org.glassfish.api.admin.AdminCommandContext;
import org.jvnet.hk2.annotations.Inject;
import org.jvnet.hk2.annotations.Scoped;
import org.jvnet.hk2.annotations.Service;
import org.jvnet.hk2.component.PerLookup;
import org.jvnet.hk2.config.ConfigSupport;
import org.jvnet.hk2.config.SingleConfigCode;
import org.jvnet.hk2.config.TransactionFailure;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Service(name="delete-jvm-options")
@Scoped(value=PerLookup.class)
@I18n(value="delete.jvm.options")
public final class DeleteJvmOptions
implements AdminCommand {
    @Param(name="target", optional=true)
    String target;
    @Inject
    JavaConfig jc;
    @Param(name="jvm_option_name", primary=true)
    String optString;
    private static final StringManager lsm = StringManager.getManager(ListJvmOptions.class);
    private static final Logger logger = Logger.getLogger(DeleteJvmOptions.class.getPackage().getName());

    @Override
    public void execute(AdminCommandContext context) {
        DeleteJvmOptions.logfh("Injected JavaConfig: " + this.jc);
        ActionReport report = context.getActionReport();
        List<Joe> joes = Joe.toJoes(this.optString);
        try {
            DeleteJvmOptions.deleteX(this.jc, Joe.toStrings(joes));
            ActionReport.MessagePart part = report.getTopMessagePart().addChild();
            part.setMessage("deleted " + joes.size() + " option(s)");
        }
        catch (Exception e) {
            String msg = e.getMessage() != null ? e.getMessage() : lsm.getStringWithDefault("delete.jvm.options.failed", "Command: delete-jvm-options failed", new String[]{e.getMessage()});
            report.setMessage(msg);
            report.setActionExitCode(ActionReport.ExitCode.FAILURE);
            report.setFailureCause(e);
            return;
        }
        report.setActionExitCode(ActionReport.ExitCode.SUCCESS);
    }

    public DeleteJvmOptions() {
        DeleteJvmOptions.logfh(this);
    }

    private static void logfh(Object o) {
        if (logger.isLoggable(Level.FINE)) {
            if (o == null) {
                logger.fine("null reference passed");
            } else {
                logger.fine("Hashcode of the given object: " + o.hashCode());
            }
        }
    }

    private static void deleteX(JavaConfig jc, final List<String> newOpts) throws Exception {
        SingleConfigCode<JavaConfig> scc = new SingleConfigCode<JavaConfig>(){

            @Override
            public Object run(JavaConfig jc) throws PropertyVetoException, TransactionFailure {
                ArrayList<String> jvmopts = new ArrayList<String>(jc.getJvmOptions());
                jvmopts.removeAll(newOpts);
                jc.setJvmOptions(jvmopts);
                return true;
            }
        };
        ConfigSupport.apply(scc, jc);
    }
}

