/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.v3.server;

import com.sun.enterprise.module.ModulesRegistry;
import com.sun.enterprise.module.bootstrap.ModuleStartup;
import com.sun.enterprise.module.bootstrap.StartupContext;
import com.sun.enterprise.util.Result;
import com.sun.enterprise.v3.admin.CommandRunner;
import com.sun.enterprise.v3.common.PlainTextActionReporter;
import com.sun.enterprise.v3.server.ServerEnvironmentImpl;
import com.sun.logging.LogDomains;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Properties;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.glassfish.api.Async;
import org.glassfish.api.FutureProvider;
import org.glassfish.api.Startup;
import org.glassfish.api.event.EventListener;
import org.glassfish.api.event.EventTypes;
import org.glassfish.api.event.Events;
import org.glassfish.internal.api.Init;
import org.jvnet.hk2.annotations.Inject;
import org.jvnet.hk2.annotations.Service;
import org.jvnet.hk2.component.Habitat;
import org.jvnet.hk2.component.Inhabitant;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Service
public class AppServerStartup
implements ModuleStartup {
    StartupContext context;
    static final Logger logger = LogDomains.getLogger("javax.enterprise.system.core");
    @Inject
    ServerEnvironmentImpl env;
    @Inject
    Habitat habitat;
    @Inject
    ModulesRegistry systemRegistry;
    @Inject
    ExecutorService executor;
    @Inject
    Events events;

    @Override
    @Inject
    public void setStartupContext(StartupContext context) {
        this.context = context;
    }

    @Override
    public void run() {
        if (this.context == null) {
            System.err.println("Startup context not provided, cannot continue");
            return;
        }
        logger.fine("Module subsystem initialized in " + (System.currentTimeMillis() - this.context.getCreationTime()) + " ms");
        if (logger.isLoggable(Level.FINE)) {
            logger.fine("Startup class : " + this.getClass().getName());
        }
        this.habitat.addComponent(null, this.systemRegistry);
        this.habitat.addComponent("javax.enterprise.system.core", logger);
        for (Inhabitant<Init> init : this.habitat.getInhabitants(Init.class)) {
            init.get();
            if (!logger.isLoggable(Level.FINE)) continue;
            logger.fine(init + " Init done in " + (System.currentTimeMillis() - this.context.getCreationTime()) + " ms");
        }
        if (logger.isLoggable(Level.FINE)) {
            logger.fine("Init done in " + (System.currentTimeMillis() - this.context.getCreationTime()) + " ms");
        }
        final Collection<Inhabitant<? extends Startup>> startups = this.habitat.getInhabitants(Startup.class);
        Future<?> result = this.executor.submit(new Runnable(){

            public void run() {
                for (Inhabitant i : startups) {
                    if (i.type().getAnnotation(Async.class) == null) continue;
                    i.get();
                }
            }
        });
        boolean shutdownRequested = false;
        ArrayList futures = new ArrayList();
        ArrayList<Inhabitant<? extends Startup>> executedStartups = new ArrayList<Inhabitant<? extends Startup>>();
        for (Inhabitant<Startup> inhabitant : startups) {
            if (inhabitant.type().getAnnotation(Async.class) != null) continue;
            try {
                Startup startup = inhabitant.get();
                if (startup instanceof FutureProvider) {
                    futures.addAll(((FutureProvider)((Object)startup)).getFutures());
                }
            }
            catch (RuntimeException e) {
                logger.info("Startup service failed to start : " + e.getMessage());
            }
            if (logger.isLoggable(Level.FINE)) {
                logger.info(inhabitant.get() + " startup done in " + (System.currentTimeMillis() - this.context.getCreationTime()) + " ms");
            }
            executedStartups.add(inhabitant);
        }
        logger.info("Glassfish v3 started in " + (Calendar.getInstance().getTimeInMillis() - this.context.getCreationTime()) + " ms");
        try {
            result.get(1000L, TimeUnit.MILLISECONDS);
        }
        catch (Exception e) {
            // empty catch block
        }
        if (shutdownRequested) {
            this.shutdown(startups, executedStartups);
        } else {
            for (Future future : futures) {
                try {
                    if (!((Result)future.get()).isFailure()) continue;
                    Throwable t = ((Result)future.get()).exception();
                    logger.log(Level.SEVERE, "Shutting down v3 due to startup exception : " + t.getMessage());
                    logger.log(Level.FINE, ((Result)future.get()).exception().getMessage(), t);
                    this.shutdown(startups, executedStartups);
                    return;
                }
                catch (Throwable t) {
                    logger.log(Level.SEVERE, t.getMessage(), t);
                }
            }
        }
        this.events.send(new EventListener.Event(EventTypes.SERVER_READY));
    }

    private final void shutdown(Collection<Inhabitant<? extends Startup>> startups, Collection<Inhabitant<? extends Startup>> executedServices) {
        CommandRunner runner = this.habitat.getByType(CommandRunner.class);
        if (runner != null) {
            Properties params = new Properties();
            if (this.context.getArguments().containsKey("--noforcedshutdown")) {
                params.put("force", "false");
            }
            runner.doCommand("stop-domain", params, new PlainTextActionReporter());
            return;
        }
    }
}

