/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.web;

import com.sun.enterprise.config.serverbeans.Property;
import com.sun.enterprise.config.serverbeans.SessionProperties;
import com.sun.enterprise.deployment.runtime.web.ManagerProperties;
import com.sun.enterprise.deployment.runtime.web.SessionManager;
import com.sun.enterprise.deployment.runtime.web.StoreProperties;
import com.sun.enterprise.deployment.runtime.web.WebProperty;
import com.sun.enterprise.web.PersistenceStrategyBuilder;
import com.sun.enterprise.web.ServerConfigLookup;
import com.sun.logging.LogDomains;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.catalina.Context;
import org.apache.catalina.core.StandardContext;

public abstract class BasePersistenceStrategyBuilder
implements PersistenceStrategyBuilder {
    protected static final Logger _logger = LogDomains.getLogger("javax.enterprise.system.container.web");
    protected String directory = null;
    protected String DEFAULT_SESSION_FILENAME;
    protected String sessionFilename = this.DEFAULT_SESSION_FILENAME = "SESSIONS.ser";
    protected String sessionIdGeneratorClassname = null;
    protected String _persistenceFrequency = null;
    protected String _persistenceScope = null;
    protected String _passedInPersistenceType = null;
    protected int maxSessions = -1;
    protected final int DEFAULT_REAP_INTERVAL = 60;
    protected int reapInterval = 60;
    protected int storeReapInterval = 60;
    protected final int DEFAULT_MAX_IDLE_BACKUP = -1;
    protected int maxIdleBackup = -1;
    protected final int DEFAULT_SESSION_TIMEOUT = 1800;
    protected int sessionMaxInactiveInterval = 1800;
    protected static final String JSF_HA_ENABLED = "com.sun.appserver.enableHighAvailability";

    public void initializePersistenceStrategy(Context ctx, SessionManager smBean, ServerConfigLookup serverConfigLookup) {
        this.setDefaultParams(ctx, smBean);
        this.readInstanceLevelParams(serverConfigLookup);
        this.readWebAppParams(ctx, smBean);
        ctx.setBackgroundProcessorDelay(this.reapInterval);
    }

    public void setDefaultParams(Context ctx, SessionManager smBean) {
        this.reapInterval = 60;
        this.maxSessions = -1;
        this.sessionFilename = this.DEFAULT_SESSION_FILENAME;
        this.storeReapInterval = 60;
        this.directory = ((StandardContext)ctx).getWorkDir();
    }

    public void readInstanceLevelParams(ServerConfigLookup serverConfigLookup) {
        SessionProperties spBean;
        com.sun.enterprise.config.serverbeans.SessionManager smBean = serverConfigLookup.getInstanceSessionManager();
        if (smBean != null) {
            com.sun.enterprise.config.serverbeans.StoreProperties storeBean;
            com.sun.enterprise.config.serverbeans.ManagerProperties mgrBean = smBean.getManagerProperties();
            if (mgrBean != null) {
                List<Property> props;
                String sessionFilenameString;
                String maxSessionsString;
                String reapIntervalInSecondsString = mgrBean.getReapIntervalInSeconds();
                if (reapIntervalInSecondsString != null) {
                    try {
                        this.reapInterval = Integer.parseInt(reapIntervalInSecondsString);
                        if (_logger.isLoggable(Level.FINEST)) {
                            _logger.finest("mgr reapInterval set = " + this.reapInterval);
                        }
                    }
                    catch (NumberFormatException e) {}
                } else if (_logger.isLoggable(Level.FINEST)) {
                    _logger.finest("no instance level value set for mgr reapInterval");
                }
                if ((maxSessionsString = mgrBean.getMaxSessions()) != null) {
                    try {
                        this.maxSessions = Integer.parseInt(maxSessionsString);
                        if (_logger.isLoggable(Level.FINEST)) {
                            _logger.finest("maxSessions set = " + this.maxSessions);
                        }
                    }
                    catch (NumberFormatException e) {}
                } else if (_logger.isLoggable(Level.FINEST)) {
                    _logger.finest("no instance level value set for maxSessions");
                }
                if ((sessionFilenameString = mgrBean.getSessionFileName()) != null) {
                    this.sessionFilename = sessionFilenameString;
                    if (_logger.isLoggable(Level.FINEST)) {
                        _logger.finest("sessionFilename set = " + this.sessionFilename);
                    }
                }
                this.sessionIdGeneratorClassname = mgrBean.getSessionIdGeneratorClassname();
                if (this.sessionIdGeneratorClassname != null && _logger.isLoggable(Level.FINEST)) {
                    _logger.finest("sessionIdGeneratorClassname set = " + this.sessionIdGeneratorClassname);
                }
                if ((props = mgrBean.getProperty()) != null) {
                    for (Property prop : props) {
                        String name = prop.getName();
                        String value = prop.getValue();
                        if (!name.equalsIgnoreCase("maxIdleBackupSeconds")) continue;
                        try {
                            this.maxIdleBackup = Integer.parseInt(value);
                        }
                        catch (NumberFormatException e) {}
                    }
                }
            }
            if ((storeBean = smBean.getStoreProperties()) != null) {
                String directoryString;
                String reapIntervalInSecondsString = storeBean.getReapIntervalInSeconds();
                if (reapIntervalInSecondsString != null) {
                    try {
                        this.storeReapInterval = Integer.parseInt(reapIntervalInSecondsString);
                        _logger.finest("storeReapInterval set = " + this.storeReapInterval);
                    }
                    catch (NumberFormatException e) {
                        // empty catch block
                    }
                }
                if ((directoryString = storeBean.getDirectory()) != null) {
                    this.directory = directoryString;
                    _logger.finest("directory set = " + directoryString);
                }
            }
        }
        if ((spBean = serverConfigLookup.getInstanceSessionProperties()) != null) {
            String timeoutSecondsString = spBean.getTimeoutInSeconds();
            if (timeoutSecondsString != null) {
                try {
                    this.sessionMaxInactiveInterval = Integer.parseInt(timeoutSecondsString);
                    _logger.finest("sessionMaxInactiveInterval set = " + this.sessionMaxInactiveInterval);
                }
                catch (NumberFormatException e) {}
            } else if (_logger.isLoggable(Level.FINEST)) {
                _logger.finest("no instance level value set for sessionMaxInactiveInterval");
            }
        }
    }

    public void readWebAppParams(Context ctx, SessionManager smBean) {
        if (smBean != null) {
            StoreProperties storeBean;
            ManagerProperties mgrBean = smBean.getManagerProperties();
            if (mgrBean != null && mgrBean.sizeWebProperty() > 0) {
                WebProperty[] props = mgrBean.getWebProperty();
                for (int i = 0; i < props.length; ++i) {
                    String name = props[i].getAttributeValue("name");
                    String value = props[i].getAttributeValue("value");
                    if (name.equalsIgnoreCase("reapIntervalSeconds")) {
                        try {
                            this.reapInterval = Integer.parseInt(value);
                        }
                        catch (NumberFormatException e) {}
                        continue;
                    }
                    if (name.equalsIgnoreCase("maxSessions")) {
                        try {
                            this.maxSessions = Integer.parseInt(value);
                        }
                        catch (NumberFormatException e) {}
                        continue;
                    }
                    if (name.equalsIgnoreCase("maxIdleBackupSeconds")) {
                        try {
                            this.maxIdleBackup = Integer.parseInt(value);
                        }
                        catch (NumberFormatException e) {}
                        continue;
                    }
                    if (name.equalsIgnoreCase("sessionFilename")) {
                        this.sessionFilename = value;
                        continue;
                    }
                    if (name.equalsIgnoreCase("persistenceFrequency")) {
                        this._persistenceFrequency = value;
                        continue;
                    }
                    Object[] params = new Object[]{name};
                    _logger.log(Level.INFO, "webcontainer.notYet", params);
                }
            }
            if ((storeBean = smBean.getStoreProperties()) != null && storeBean.sizeWebProperty() > 0) {
                WebProperty[] props = storeBean.getWebProperty();
                for (int i = 0; i < props.length; ++i) {
                    String name = props[i].getAttributeValue("name");
                    String value = props[i].getAttributeValue("value");
                    if (name.equalsIgnoreCase("reapIntervalSeconds")) {
                        try {
                            this.storeReapInterval = Integer.parseInt(value);
                        }
                        catch (NumberFormatException e) {}
                        continue;
                    }
                    if (name.equalsIgnoreCase("directory")) {
                        this.directory = value;
                        continue;
                    }
                    if (name.equalsIgnoreCase("persistenceScope")) {
                        this._persistenceScope = value;
                        continue;
                    }
                    Object[] params = new Object[]{name};
                    _logger.log(Level.INFO, "webcontainer.notYet", params);
                }
            }
        }
    }

    protected String prependContextPathTo(String str, Context ctx) {
        if (str == null) {
            return str;
        }
        String filePart = this.getFilePartOf(str);
        if (filePart == null || filePart.equals("")) {
            return null;
        }
        String strippedContextPath = this.stripNonAlphaNumericsExceptUnderscore(ctx.getPath());
        String modifiedFilePart = null;
        modifiedFilePart = strippedContextPath != null && !strippedContextPath.equals("") ? strippedContextPath + "_" + filePart : filePart;
        int lastSlashIdx = str.lastIndexOf(File.separator);
        String result = null;
        if (lastSlashIdx == -1) {
            result = modifiedFilePart;
        } else {
            String firstPart = str.substring(0, lastSlashIdx);
            result = firstPart + File.separator + modifiedFilePart;
        }
        return result;
    }

    protected String getFilePartOf(String str) {
        if (str == null) {
            return str;
        }
        int lastSlashIdx = str.lastIndexOf(File.separator);
        String result = null;
        result = lastSlashIdx == -1 ? this.cleanFileParts(str) : this.cleanFileParts(str.substring(lastSlashIdx + 1, str.length()));
        return result;
    }

    private String cleanFileParts(String fileString) {
        String fileMainPart = this.getFileMainPart(fileString);
        String fileSuffixPart = this.getFileSuffixPart(fileString);
        if (fileMainPart == null) {
            return null;
        }
        if (fileSuffixPart == null) {
            return fileMainPart;
        }
        return fileMainPart + "." + fileSuffixPart;
    }

    private String getFileMainPart(String fileString) {
        ArrayList<String> results = new ArrayList<String>();
        StringTokenizer st = new StringTokenizer(fileString, ".");
        while (st.hasMoreTokens()) {
            results.add(st.nextToken());
        }
        if (results.size() > 0) {
            return this.stripNonAlphaNumericsExceptUnderscore((String)results.get(0));
        }
        return null;
    }

    private String getFileSuffixPart(String fileString) {
        ArrayList<String> results = new ArrayList<String>();
        StringTokenizer st = new StringTokenizer(fileString, ".");
        while (st.hasMoreTokens()) {
            results.add(st.nextToken());
        }
        if (results.size() > 1) {
            return this.stripNonAlphaNumericsExceptUnderscore((String)results.get(1));
        }
        return null;
    }

    protected String stripNonAlphas(String inputString) {
        StringBuilder sb = new StringBuilder(50);
        for (int i = 0; i < inputString.length(); ++i) {
            char nextChar = inputString.charAt(i);
            if (!Character.isLetter(nextChar)) continue;
            sb.append(nextChar);
        }
        return sb.toString();
    }

    protected String stripNonAlphaNumericsExceptUnderscore(String inputString) {
        StringBuilder sb = new StringBuilder(50);
        for (int i = 0; i < inputString.length(); ++i) {
            char nextChar = inputString.charAt(i);
            if (!Character.isLetterOrDigit(nextChar) && !"_".equals(String.valueOf(nextChar))) continue;
            sb.append(nextChar);
        }
        return sb.toString();
    }

    protected String stripNonAlphaNumerics(String inputString) {
        StringBuilder sb = new StringBuilder(50);
        for (int i = 0; i < inputString.length(); ++i) {
            char nextChar = inputString.charAt(i);
            if (!Character.isLetterOrDigit(nextChar)) continue;
            sb.append(nextChar);
        }
        return sb.toString();
    }

    public String getPersistenceFrequency() {
        return this._persistenceFrequency;
    }

    public void setPersistenceFrequency(String persistenceFrequency) {
        this._persistenceFrequency = persistenceFrequency;
    }

    public String getPersistenceScope() {
        return this._persistenceScope;
    }

    public void setPersistenceScope(String persistenceScope) {
        this._persistenceScope = persistenceScope;
    }

    public String getPassedInPersistenceType() {
        return this._passedInPersistenceType;
    }

    public void setPassedInPersistenceType(String persistenceType) {
        this._passedInPersistenceType = persistenceType;
    }
}

