/*
 * Decompiled with CFR 0.152.
 */
package com.sun.faces.extensions.common.util;

import java.util.Iterator;
import java.util.List;
import javax.faces.FacesException;
import javax.faces.FactoryFinder;
import javax.faces.application.Application;
import javax.faces.component.UIComponent;
import javax.faces.component.ValueHolder;
import javax.faces.context.FacesContext;
import javax.faces.convert.Converter;
import javax.faces.convert.ConverterException;
import javax.faces.event.PhaseId;
import javax.faces.render.RenderKit;
import javax.faces.render.RenderKitFactory;

public class Util {
    private Util() {
    }

    public static String getFormattedValue(FacesContext context, UIComponent component, Object currentValue) throws ConverterException {
        String result = null;
        if (!(component instanceof ValueHolder)) {
            if (currentValue != null) {
                result = currentValue.toString();
            }
            return result;
        }
        Converter converter = null;
        converter = ((ValueHolder)((Object)component)).getConverter();
        if (converter == null && currentValue == null) {
            return "";
        }
        if (converter == null) {
            if (currentValue instanceof String) {
                return (String)currentValue;
            }
            Class<?> converterType = currentValue.getClass();
            converter = Util.getConverterForClass(converterType, context);
            if (converter == null) {
                result = currentValue.toString();
                return result;
            }
        }
        return converter.getAsString(context, component, currentValue);
    }

    public static Converter getConverterForClass(Class converterClass, FacesContext context) {
        if (converterClass == null) {
            return null;
        }
        try {
            Application application = context.getApplication();
            return application.createConverter(converterClass);
        }
        catch (Exception e) {
            return null;
        }
    }

    public static PhaseId getPhaseIdFromString(String phaseIdString) {
        PhaseId result = PhaseId.ANY_PHASE;
        List phaseIds = PhaseId.VALUES;
        for (PhaseId curPhase : phaseIds) {
            if (-1 == curPhase.toString().toLowerCase().indexOf(phaseIdString.toLowerCase())) continue;
            return curPhase;
        }
        return result;
    }

    public static RenderKit getRenderKit(FacesContext context) {
        String renderKitId = context.getViewRoot().getRenderKitId();
        renderKitId = null != renderKitId ? renderKitId : "HTML_BASIC";
        return Util.getRenderKit(context, renderKitId);
    }

    public static RenderKit getRenderKit(FacesContext context, String renderKitId) {
        RenderKitFactory fact = (RenderKitFactory)FactoryFinder.getFactory("javax.faces.render.RenderKitFactory");
        assert (null != fact);
        RenderKit curRenderKit = fact.getRenderKit(context, renderKitId);
        return curRenderKit;
    }

    public static boolean prefixViewTraversal(FacesContext context, UIComponent root, TreeTraversalCallback action) throws FacesException {
        boolean keepGoing = false;
        keepGoing = action.takeActionOnNode(context, root);
        if (keepGoing) {
            Iterator<UIComponent> kids = root.getFacetsAndChildren();
            while (kids.hasNext() && keepGoing) {
                keepGoing = Util.prefixViewTraversal(context, kids.next(), action);
            }
        }
        return keepGoing;
    }

    public static interface TreeTraversalCallback {
        public boolean takeActionOnNode(FacesContext var1, UIComponent var2) throws FacesException;
    }
}

