/*
 * Decompiled with CFR 0.152.
 */
package com.sun.grizzly.util.http;

import com.sun.grizzly.util.buf.ByteChunk;
import com.sun.grizzly.util.buf.DateTool;
import com.sun.grizzly.util.buf.MessageBytes;
import com.sun.grizzly.util.res.StringManager;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.text.FieldPosition;
import java.util.Date;
import java.util.logging.Level;
import java.util.logging.Logger;

public class ServerCookie
implements Serializable {
    private static Logger logger = Logger.getLogger("Grizzly");
    private static final StringManager sm = StringManager.getManager("com.sun.grizzly.util.http.res");
    private static final String NULL_VALUE = "null";
    private static final String ANCIENT_DATE = DateTool.formatOldCookie(new Date(10000L));
    private MessageBytes name = MessageBytes.newInstance();
    private MessageBytes value = MessageBytes.newInstance();
    private MessageBytes path = MessageBytes.newInstance();
    private MessageBytes domain = MessageBytes.newInstance();
    private boolean secure;
    private MessageBytes comment = MessageBytes.newInstance();
    private int maxAge = -1;
    private int version = 0;
    private static final String tspecials = ",; ";
    private static final String tspecials2 = "()<>@,;:\\\"/[]?={} \t";
    private static final String tspecials2NoSlash = "()<>@,;:\\\"[]?={} \t";
    static final int dbg = 1;

    public void recycle() {
        this.path.recycle();
        this.name.recycle();
        this.value.recycle();
        this.comment.recycle();
        this.maxAge = -1;
        this.path.recycle();
        this.domain.recycle();
        this.version = 0;
        this.secure = false;
    }

    public MessageBytes getComment() {
        return this.comment;
    }

    public MessageBytes getDomain() {
        return this.domain;
    }

    public void setMaxAge(int expiry) {
        this.maxAge = expiry;
    }

    public int getMaxAge() {
        return this.maxAge;
    }

    public MessageBytes getPath() {
        return this.path;
    }

    public void setSecure(boolean flag) {
        this.secure = flag;
    }

    public boolean getSecure() {
        return this.secure;
    }

    public MessageBytes getName() {
        return this.name;
    }

    public MessageBytes getValue() {
        return this.value;
    }

    public int getVersion() {
        return this.version;
    }

    public void setVersion(int v) {
        this.version = v;
    }

    public String toString() {
        return "Cookie " + this.getName() + "=" + this.getValue() + " ; " + this.getVersion() + " " + this.getPath() + " " + this.getDomain();
    }

    public static boolean isToken(String value) {
        return ServerCookie.isToken(value, null);
    }

    public static boolean isToken(String value, String literals) {
        String tspecials;
        String string = tspecials = literals == null ? tspecials : literals;
        if (value == null) {
            return true;
        }
        int len = value.length();
        for (int i = 0; i < len; ++i) {
            char c = value.charAt(i);
            if (tspecials.indexOf(c) == -1) continue;
            return false;
        }
        return true;
    }

    public static boolean containsCTL(String value, int version) {
        if (value == null) {
            return false;
        }
        int len = value.length();
        for (int i = 0; i < len; ++i) {
            char c = value.charAt(i);
            if (c >= ' ' && c < '\u007f' || c == '\t') continue;
            return true;
        }
        return false;
    }

    public static boolean isToken2(String value) {
        return ServerCookie.isToken2(value, null);
    }

    public static boolean isToken2(String value, String literals) {
        String tspecials2;
        String string = tspecials2 = literals == null ? tspecials2 : literals;
        if (value == null) {
            return true;
        }
        int len = value.length();
        for (int i = 0; i < len; ++i) {
            char c = value.charAt(i);
            if (tspecials2.indexOf(c) == -1) continue;
            return false;
        }
        return true;
    }

    public static boolean checkName(String name) {
        return ServerCookie.isToken(name) && !name.equalsIgnoreCase("Comment") && !name.equalsIgnoreCase("Discard") && !name.equalsIgnoreCase("Domain") && !name.equalsIgnoreCase("Expires") && !name.equalsIgnoreCase("Max-Age") && !name.equalsIgnoreCase("Path") && !name.equalsIgnoreCase("Secure") && !name.equalsIgnoreCase("Version");
    }

    public String getCookieHeaderName() {
        return ServerCookie.getCookieHeaderName(this.version);
    }

    public static String getCookieHeaderName(int version) {
        if (version == 1) {
            return "Set-Cookie";
        }
        return "Set-Cookie";
    }

    public static void appendCookieValue(StringBuffer buf, int version, String name, String value, String path, String domain, String comment, int maxAge, boolean isSecure) {
        ServerCookie.appendCookieValue(buf, version, name, value, path, domain, comment, maxAge, isSecure, false);
    }

    public static void appendCookieValue(StringBuffer headerBuf, int version, String name, String value, String path, String domain, String comment, int maxAge, boolean isSecure, boolean encode) {
        StringBuffer buf;
        block24: {
            buf = new StringBuffer();
            if (encode) {
                try {
                    buf.append(URLEncoder.encode(name, "UTF-8"));
                    buf.append("=");
                    if (value != null) {
                        ServerCookie.maybeQuote(version, buf, URLEncoder.encode(value, "UTF-8"));
                        break block24;
                    }
                    ServerCookie.maybeQuote(version, buf, URLEncoder.encode(NULL_VALUE, "UTF-8"));
                }
                catch (UnsupportedEncodingException e) {
                    buf.append(URLEncoder.encode(name));
                    buf.append("=");
                    if (value != null) {
                        ServerCookie.maybeQuote(version, buf, URLEncoder.encode(value));
                        break block24;
                    }
                    ServerCookie.maybeQuote(version, buf, URLEncoder.encode(NULL_VALUE));
                }
            } else {
                buf.append(name);
                buf.append("=");
                if (value != null) {
                    ServerCookie.maybeQuote(version, buf, value);
                } else {
                    ServerCookie.maybeQuote(version, buf, NULL_VALUE);
                }
            }
        }
        if (version == 1) {
            buf.append("; Version=1");
            if (comment != null) {
                buf.append("; Comment=");
                if (encode) {
                    try {
                        ServerCookie.maybeQuote(version, buf, URLEncoder.encode(comment, "UTF-8"));
                    }
                    catch (UnsupportedEncodingException e) {
                        ServerCookie.maybeQuote(version, buf, URLEncoder.encode(comment));
                    }
                } else {
                    ServerCookie.maybeQuote(version, buf, comment);
                }
            }
        }
        if (domain != null) {
            buf.append("; Domain=");
            ServerCookie.maybeQuote(version, buf, domain);
        }
        if (maxAge >= 0) {
            if (version == 0) {
                buf.append("; Expires=");
                if (maxAge == 0) {
                    buf.append(ANCIENT_DATE);
                } else {
                    DateTool.formatOldCookie(new Date(System.currentTimeMillis() + (long)maxAge * 1000L), buf, new FieldPosition(0));
                }
            } else {
                buf.append("; Max-Age=");
                buf.append(maxAge);
            }
        }
        if (path != null) {
            buf.append("; Path=");
            if (version == 0) {
                ServerCookie.maybeQuote(version, buf, path);
            } else {
                ServerCookie.maybeQuote(version, buf, path, tspecials2NoSlash);
            }
        }
        if (isSecure) {
            buf.append("; Secure");
        }
        headerBuf.append(buf);
    }

    public static void appendEncodedCookieValue(StringBuffer buf, int version, String name, String value, String path, String domain, String comment, int maxAge, boolean isSecure) {
        ServerCookie.appendCookieValue(buf, version, name, value, path, domain, comment, maxAge, isSecure, true);
    }

    public static void maybeQuote(int version, StringBuffer buf, String value) {
        ServerCookie.maybeQuote(version, buf, value, null);
    }

    public static void maybeQuote(int version, StringBuffer buf, String value, String literals) {
        if (value == null || value.length() == 0) {
            buf.append("\"\"");
        } else {
            if (ServerCookie.containsCTL(value, version)) {
                throw new IllegalArgumentException(sm.getString("servercookie.control_character"));
            }
            if (ServerCookie.alreadyQuoted(value)) {
                buf.append('\"');
                buf.append(ServerCookie.escapeDoubleQuotes(value, 1, value.length() - 1));
                buf.append('\"');
                buf.append('\"');
            } else if (version == 0 && !ServerCookie.isToken(value, literals)) {
                buf.append('\"');
                buf.append(ServerCookie.escapeDoubleQuotes(value, 0, value.length()));
                buf.append('\"');
            } else if (version == 1 && !ServerCookie.isToken2(value, literals)) {
                buf.append('\"');
                buf.append(ServerCookie.escapeDoubleQuotes(value, 0, value.length()));
                buf.append('\"');
            } else {
                buf.append(value);
            }
        }
    }

    private static void log(String s) {
        if (logger.isLoggable(Level.FINE)) {
            logger.fine("Cookies: " + s);
        }
    }

    public static boolean alreadyQuoted(String value) {
        if (value == null || value.length() == 0) {
            return false;
        }
        return value.charAt(0) == '\"' && value.charAt(value.length() - 1) == '\"';
    }

    private static String escapeDoubleQuotes(String s, int beginIndex, int endIndex) {
        if (s == null || s.length() == 0 || s.indexOf(34) == -1) {
            return s;
        }
        StringBuffer b = new StringBuffer();
        for (int i = beginIndex; i < endIndex; ++i) {
            char c = s.charAt(i);
            if (c == '\\') {
                b.append(c);
                if (++i >= endIndex) {
                    throw new IllegalArgumentException(sm.getString("servercookie.invalid_escape"));
                }
                b.append(s.charAt(i));
                continue;
            }
            if (c == '\"') {
                b.append('\\').append('\"');
                continue;
            }
            b.append(c);
        }
        return b.toString();
    }

    public static void unescapeDoubleQuotes(ByteChunk bc) {
        int src;
        if (bc == null || bc.getLength() == 0 || bc.indexOf('\"', 0) == -1) {
            return;
        }
        int end = bc.getEnd();
        int dest = src;
        byte[] buffer = bc.getBuffer();
        for (src = bc.getStart(); src < end; ++src) {
            if (buffer[src] == 92 && src < end && buffer[src + 1] == 34) {
                ++src;
            }
            buffer[dest] = buffer[src];
            ++dest;
        }
        bc.setEnd(dest);
    }
}

