/*
 * Decompiled with CFR 0.152.
 */
package com.sun.scn.client.util;

import com.sun.scn.client.util.KeyGenerator;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.InetSocketAddress;
import java.net.Proxy;
import java.net.URL;
import java.security.InvalidKeyException;
import java.security.KeyPair;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.Signature;
import java.security.SignatureException;
import java.util.ResourceBundle;
import java.util.UUID;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.commons.codec.binary.Base64;

public class SCRKClientHelper {
    private static Logger log = Logger.getLogger(SCRKClientHelper.class.getName());
    public static final String URL_PROPERTY_KEY = SCRKClientHelper.class.getName() + ".crsUrl";
    public static final String TARGET_PROPERTY_KEY = SCRKClientHelper.class.getName() + ".target";
    private static final String SCRK_SIG_ALG = "SHA1withRSA";
    private static final String DEFAULT_URL = "https://cns-services.sun.com/";
    private static final String DEFAULT_URI = "SCRK/ClientRegistrationV1_1_0";
    private final String NAME_CLIENT_REG_ID = "SC_CLIENT_REG_ID";
    private final String NAME_ASSET_ID = "ASSET_ID";
    private final String NAME_PUB_KEY = "PUBLIC_KEY";
    private final String NAME_SOA_ID = "SOA_ID";
    private final String NAME_SOA_PW = "SOA_PW";

    public String getClientRegId(KeyPair keyPair, String soaUsername, String soaPassword, String proxyHost, int proxyPort) throws Exception {
        return this.registerClient(keyPair, soaUsername, soaPassword, proxyHost, proxyPort);
    }

    public String getClientRegId(KeyPair keyPair, String soaUsername, String soaPassword) throws Exception {
        return this.registerClient(keyPair, soaUsername, soaPassword, null, -1);
    }

    public String getClientRegId(KeyPair keyPair, String soaUsername, String soaPassword, Proxy proxy) throws Exception {
        try {
            if (proxy != null && proxy.type() == Proxy.Type.HTTP) {
                InetSocketAddress addr = (InetSocketAddress)proxy.address();
                return this.registerClient(keyPair, soaUsername, soaPassword, addr.getHostName(), addr.getPort());
            }
        }
        catch (Exception ex) {
            // empty catch block
        }
        return this.registerClient(keyPair, soaUsername, soaPassword, null, -1);
    }

    public KeyPair getKeyPair() {
        try {
            return KeyGenerator.generateKeyPair();
        }
        catch (NoSuchAlgorithmException nsae) {
            throw new RuntimeException("Error Generating KeyPair for communication with Sun Inventory: ", nsae);
        }
    }

    public static byte[] signPayload(String payload, PrivateKey privateKey) {
        try {
            Signature sig = Signature.getInstance(SCRK_SIG_ALG);
            sig.initSign(privateKey);
            byte[] bytes = payload.getBytes();
            sig.update(bytes, 0, bytes.length);
            return Base64.encodeBase64(sig.sign());
        }
        catch (NoSuchAlgorithmException nsax) {
            throw new RuntimeException("Failed to construct Signature", nsax);
        }
        catch (InvalidKeyException ikx) {
            throw new RuntimeException("Failed to init Signature with PrivateKey", ikx);
        }
        catch (SignatureException sx) {
            throw new RuntimeException("Failed to generate Signature", sx);
        }
    }

    public static String getBaseUrl() {
        String baseUrl;
        String altTarget = System.getProperty(TARGET_PROPERTY_KEY);
        try {
            ResourceBundle resources = ResourceBundle.getBundle("com.sun.scn.client.resources.Connection");
            if (altTarget != null) {
                baseUrl = resources.getString(altTarget + ".scrk.url");
            } else {
                String target = resources.getString("target");
                baseUrl = resources.getString(target + ".scrk.url");
            }
        }
        catch (Exception e) {
            baseUrl = DEFAULT_URL;
        }
        String tmp = System.getProperty(URL_PROPERTY_KEY);
        if (tmp != null) {
            baseUrl = tmp;
        }
        if (!baseUrl.endsWith(DEFAULT_URI)) {
            baseUrl = baseUrl.endsWith("/") ? baseUrl + DEFAULT_URI : baseUrl + "/SCRK/ClientRegistrationV1_1_0";
        }
        return baseUrl;
    }

    private String registerClient(KeyPair keyPair, String soaUser, String soaPass, String proxyHost, int proxyPort) throws Exception {
        log.log(Level.FINER, "Registering client with scrk");
        HttpURLConnection crsClient = null;
        URL url = new URL(SCRKClientHelper.getBaseUrl());
        if (proxyHost != null && !proxyHost.equals("") && proxyPort != -1) {
            log.log(Level.FINER, "Setting proxy to " + proxyHost + ":" + proxyPort);
            Proxy proxy = new Proxy(Proxy.Type.HTTP, new InetSocketAddress(proxyHost, proxyPort));
            crsClient = (HttpURLConnection)url.openConnection(proxy);
        } else {
            crsClient = (HttpURLConnection)url.openConnection(Proxy.NO_PROXY);
        }
        String boundary = "---------------------------84028462148935";
        crsClient.setDoInput(true);
        crsClient.setDoOutput(true);
        crsClient.setUseCaches(false);
        crsClient.setAllowUserInteraction(false);
        crsClient.setRequestMethod("POST");
        crsClient.setRequestProperty("Content-Type", "multipart/form-data; boundary=" + boundary);
        String uuid = UUID.randomUUID().toString();
        String payload = this.getContent(boundary, "SOA_ID", soaUser) + this.getContent(boundary, "SOA_PW", soaPass) + this.getContent(boundary, "ASSET_ID", uuid) + this.getContent(boundary, "DESCRIPTION", "SvcTag Registration") + this.getContent(boundary, "PUBLIC_KEY", this.getPublicKeyAsX509String(keyPair.getPublic())) + "--" + boundary + "--\r\n";
        OutputStream urlOut = crsClient.getOutputStream();
        urlOut.write(payload.getBytes());
        urlOut.flush();
        urlOut.close();
        String body = null;
        crsClient.connect();
        int statusCode = crsClient.getResponseCode();
        log.log(Level.FINER, "crs response code: " + statusCode);
        if (statusCode != 200) {
            throw new Exception("Sun Inventory Authentication Error: Fatal server error encountered, status code: " + statusCode);
        }
        body = this.getResponseBodyAsString(crsClient);
        crsClient.disconnect();
        String clientRegId = null;
        String[] crsResponseBody = body.split("\n");
        log.log(Level.FINEST, "CRS Body: " + body);
        String crsCodeStr = null;
        for (int i = 0; i < crsResponseBody.length; ++i) {
            if (crsResponseBody[i].startsWith("SC_CLIENT_REG_ID=")) {
                String[] clientReg = crsResponseBody[i].split("=", 2);
                clientRegId = clientReg[1];
                break;
            }
            if (!crsResponseBody[i].startsWith("CODE=")) continue;
            String[] crsCodes = crsResponseBody[i].split("=", 2);
            crsCodeStr = crsCodes[1];
        }
        log.log(Level.FINE, "client reg id: " + clientRegId);
        if (clientRegId == null) {
            if (crsCodeStr != null) {
                int crsCode = -1;
                try {
                    crsCode = Integer.parseInt(crsCodeStr);
                }
                catch (Exception e) {
                    // empty catch block
                }
                switch (crsCode) {
                    case 1: {
                        throw new Exception("Sun Inventory Authentication Error: Missing requred element");
                    }
                    case 2: {
                        throw new Exception("Sun Inventory Authentication Error: Argument too large");
                    }
                    case 3: {
                        throw new Exception("Sun Inventory Authentication Error: Invalid XML");
                    }
                    case 4: {
                        throw new Exception("Sun Inventory Authentication Error: Invalid Sun Online Account user/password");
                    }
                    case 5: {
                        throw new Exception("Sun Inventory Authentication Error: Invalid autoregistration token");
                    }
                    case 6: {
                        throw new Exception("Sun Inventory Authentication Error: Fatal server error");
                    }
                }
            }
            throw new Exception("Sun Inventory Authentication Error: Fatal server error encountered");
        }
        return clientRegId;
    }

    private String getPublicKeyAsX509String(PublicKey publicKey) {
        String PEM_PUBKEY_HEADER = "-----BEGIN PUBLIC KEY-----\n";
        String PEM_PUBKEY_FOOTER = "\n-----END PUBLIC KEY-----";
        StringBuilder sb = new StringBuilder("-----BEGIN PUBLIC KEY-----\n");
        sb.append(new String(Base64.encodeBase64(publicKey.getEncoded())));
        sb.append("\n-----END PUBLIC KEY-----");
        return sb.toString();
    }

    private String getContent(String boundary, String key, String value) {
        return "--" + boundary + "\r\n" + "Content-Disposition: form-data; name=\"" + key + "\"\r\n\r\n" + value + "\r\n";
    }

    private String getErrorResponseBodyAsString(HttpURLConnection crsClient) {
        try {
            String line;
            BufferedReader reader = new BufferedReader(new InputStreamReader(crsClient.getErrorStream()));
            StringBuilder sb = new StringBuilder();
            while ((line = reader.readLine()) != null) {
                sb.append(line).append("\n");
            }
            reader.close();
            return sb.toString();
        }
        catch (Exception e) {
            return null;
        }
    }

    private String getResponseBodyAsString(HttpURLConnection crsClient) {
        try {
            String line;
            BufferedReader reader = new BufferedReader(new InputStreamReader(crsClient.getInputStream()));
            StringBuilder sb = new StringBuilder();
            while ((line = reader.readLine()) != null) {
                sb.append(line).append("\n");
            }
            reader.close();
            return sb.toString();
        }
        catch (Exception e) {
            return null;
        }
    }
}

