/*
 * Decompiled with CFR 0.152.
 */
package com.sun.webui.jsf.faces;

import com.sun.data.provider.RowKey;
import com.sun.data.provider.SortCriteria;
import com.sun.data.provider.TableDataProvider;
import com.sun.data.provider.impl.TableRowDataProvider;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.Map;
import javax.el.ELContext;
import javax.el.ValueExpression;
import javax.faces.context.FacesContext;

public class ValueBindingSortCriteria
extends SortCriteria {
    private transient ValueExpression valueExpression;
    private String requestMapKey = "currentRow";
    private transient TableRowDataProvider rowProvider;
    private String rowProviderLock = "rowProviderLock";

    public ValueBindingSortCriteria() {
    }

    public ValueBindingSortCriteria(ValueExpression valueExpression) {
        this.valueExpression = valueExpression;
    }

    public ValueBindingSortCriteria(ValueExpression valueExpression, boolean ascending) {
        this.valueExpression = valueExpression;
        this.setAscending(ascending);
    }

    public ValueExpression getValueExpression() {
        return this.valueExpression;
    }

    public void setValueExpression(ValueExpression valueExpression) {
        this.valueExpression = valueExpression;
    }

    public String getRequestMapKey() {
        return this.requestMapKey;
    }

    public void setRequestMapKey(String requestMapKey) {
        this.requestMapKey = requestMapKey;
    }

    public String getDisplayName() {
        String name = super.getDisplayName();
        if ((name == null || "".equals(name)) && this.valueExpression != null) {
            return this.valueExpression.getExpressionString();
        }
        return name;
    }

    public String getCriteriaKey() {
        return this.valueExpression != null ? this.valueExpression.getExpressionString() : "";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object getSortValue(TableDataProvider provider, RowKey row) {
        if (this.valueExpression == null) {
            return null;
        }
        FacesContext facesContext = FacesContext.getCurrentInstance();
        Map<String, Object> requestMap = facesContext.getExternalContext().getRequestMap();
        Object value = null;
        String string = this.rowProviderLock;
        synchronized (string) {
            Object storedRequestMapValue = null;
            if (this.requestMapKey != null && !"".equals(this.requestMapKey)) {
                storedRequestMapValue = requestMap.get(this.requestMapKey);
                if (this.rowProvider == null) {
                    this.rowProvider = new TableRowDataProvider();
                }
                this.rowProvider.setTableDataProvider(provider);
                this.rowProvider.setTableRow(row);
                requestMap.put(this.requestMapKey, this.rowProvider);
            }
            value = this.valueExpression.getValue(facesContext.getELContext());
            if (this.requestMapKey != null && !"".equals(this.requestMapKey)) {
                if (this.rowProvider != null) {
                    this.rowProvider.setTableDataProvider(null);
                    this.rowProvider.setTableRow(null);
                }
                requestMap.put(this.requestMapKey, storedRequestMapValue);
            }
        }
        return value;
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.writeObject(this.requestMapKey);
        out.writeObject(this.rowProviderLock);
        if (this.valueExpression != null) {
            out.writeObject(this.valueExpression.getExpressionString());
        } else {
            out.writeObject(null);
        }
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        this.requestMapKey = (String)in.readObject();
        this.rowProviderLock = (String)in.readObject();
        String s = (String)in.readObject();
        if (s != null) {
            FacesContext facesContext = FacesContext.getCurrentInstance();
            ELContext elContext = FacesContext.getCurrentInstance().getELContext();
            this.valueExpression = facesContext.getApplication().getExpressionFactory().createValueExpression(elContext, s, Object.class);
        } else {
            this.valueExpression = null;
        }
    }
}

