/*
 * Decompiled with CFR 0.152.
 */
package com.sun.webui.jsf.renderkit.html;

import com.sun.webui.jsf.model.Markup;
import com.sun.webui.jsf.util.RenderingUtilities;
import java.io.IOException;
import java.util.Map;
import javax.el.ValueExpression;
import javax.faces.application.Application;
import javax.faces.component.EditableValueHolder;
import javax.faces.component.UIComponent;
import javax.faces.component.ValueHolder;
import javax.faces.context.ExternalContext;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import javax.faces.convert.Converter;
import javax.faces.render.Renderer;

public abstract class AbstractRenderer
extends Renderer {
    protected static final String BUNDLE = "com.sun.webui.jsf.renderkit.html.Bundle";
    public static final String[] EVENTS_ATTRIBUTES = new String[]{"onClick", "onDblClick", "onChange", "onMouseDown", "onMouseUp", "onMouseOver", "onMouseMove", "onMouseOut", "onKeyPress", "onKeyDown", "onKeyUp"};
    public static final String[] I18N_ATTRIBUTES = new String[]{"dir", "lang"};
    private static final String[] coreAttributes = new String[]{"style", "title"};

    public void decode(FacesContext context, UIComponent component) {
        if (context == null || component == null) {
            throw new NullPointerException();
        }
        if (component instanceof EditableValueHolder) {
            this.setSubmittedValue(context, component);
        }
    }

    public void encodeBegin(FacesContext context, UIComponent component) throws IOException {
        if (context == null || component == null) {
            throw new NullPointerException();
        }
        if (component.isRendered()) {
            ResponseWriter writer = context.getResponseWriter();
            this.renderStart(context, component, writer);
            this.renderAttributes(context, component, writer);
        }
    }

    public void encodeChildren(FacesContext context, UIComponent component) throws IOException {
        if (context == null || component == null) {
            throw new NullPointerException();
        }
        if (component.isRendered()) {
            for (UIComponent kid : component.getChildren()) {
                RenderingUtilities.renderComponent(kid, context);
            }
        }
    }

    public void encodeEnd(FacesContext context, UIComponent component) throws IOException {
        if (context == null || component == null) {
            throw new NullPointerException();
        }
        if (component.isRendered()) {
            ResponseWriter writer = context.getResponseWriter();
            this.renderEnd(context, component, writer);
        }
    }

    protected void addBooleanAttributes(FacesContext context, UIComponent component, ResponseWriter writer, String[] names) throws IOException {
        if (names == null) {
            return;
        }
        Map<String, Object> attributes = component.getAttributes();
        for (int i = 0; i < names.length; ++i) {
            boolean flag;
            Object value = attributes.get(names[i]);
            if (value == null || !(flag = value instanceof String ? Boolean.valueOf((String)value).booleanValue() : Boolean.valueOf(value.toString()).booleanValue())) continue;
            writer.writeAttribute(names[i].toLowerCase(), names[i].toLowerCase(), names[i]);
            flag = false;
        }
    }

    protected void addCoreAttributes(FacesContext context, UIComponent component, ResponseWriter writer, String styles) throws IOException {
        String id = component.getId();
        writer.writeAttribute("id", component.getClientId(context), "id");
        RenderingUtilities.renderStyleClass(context, writer, component, styles);
        AbstractRenderer.addStringAttributes(context, component, writer, coreAttributes);
    }

    protected void addIntegerAttributes(FacesContext context, UIComponent component, ResponseWriter writer, String[] names) throws IOException {
        if (names == null) {
            return;
        }
        Map<String, Object> attributes = component.getAttributes();
        for (int i = 0; i < names.length; ++i) {
            Integer ivalue;
            Object value = attributes.get(names[i]);
            if (value == null || !(value instanceof Integer) || (ivalue = (Integer)value) == Integer.MIN_VALUE) continue;
            writer.writeAttribute(names[i].toLowerCase(), ivalue, names[i]);
        }
    }

    protected static void addStringAttributes(FacesContext context, UIComponent component, ResponseWriter writer, String[] names) throws IOException {
        if (names == null) {
            return;
        }
        Map<String, Object> attributes = component.getAttributes();
        for (int i = 0; i < names.length; ++i) {
            String tmp;
            Object value = attributes.get(names[i]);
            if (value == null || (tmp = value instanceof String ? (String)value : value.toString()).length() <= 0) continue;
            writer.writeAttribute(names[i].toLowerCase(), tmp, names[i]);
        }
    }

    protected Application getApplication() {
        return this.getFacesContext().getApplication();
    }

    protected Object getAsObject(FacesContext context, UIComponent component, String value) {
        Class<?> clazz;
        ValueExpression vb;
        if (value == null) {
            return null;
        }
        Converter converter = ((ValueHolder)((Object)component)).getConverter();
        if (converter == null && (vb = component.getValueExpression("value")) != null && (clazz = vb.getType(context.getELContext())) != null) {
            converter = this.getApplication().createConverter(clazz);
        }
        if (converter != null) {
            return converter.getAsObject(context, component, value);
        }
        return value;
    }

    protected String getAsString(FacesContext context, UIComponent component) {
        Object submittedValue;
        if (component instanceof EditableValueHolder && (submittedValue = ((EditableValueHolder)((Object)component)).getSubmittedValue()) != null) {
            return (String)submittedValue;
        }
        Object value = ((ValueHolder)((Object)component)).getValue();
        if (value == null) {
            return null;
        }
        Converter converter = ((ValueHolder)((Object)component)).getConverter();
        if (converter == null) {
            if (value instanceof String) {
                return (String)value;
            }
            converter = this.getApplication().createConverter(value.getClass());
        }
        if (converter != null) {
            return converter.getAsString(context, component, value);
        }
        return value.toString();
    }

    protected ExternalContext getExternalContext() {
        return FacesContext.getCurrentInstance().getExternalContext();
    }

    protected FacesContext getFacesContext() {
        return FacesContext.getCurrentInstance();
    }

    protected Object getSubmittedValue(FacesContext context, UIComponent component) {
        String clientId = component.getClientId(context);
        Map<String, String> parameters = context.getExternalContext().getRequestParameterMap();
        return parameters.get(clientId);
    }

    protected boolean isDisabled(UIComponent component) {
        Object disabled = component.getAttributes().get("disabled");
        if (disabled == null) {
            return false;
        }
        if (disabled instanceof String) {
            return Boolean.valueOf((String)disabled);
        }
        return disabled.equals(Boolean.TRUE);
    }

    protected boolean isPortlet(FacesContext context) {
        return false;
    }

    protected boolean isReadOnly(UIComponent component) {
        Object readonly = component.getAttributes().get("readonly");
        if (readonly == null) {
            return false;
        }
        if (readonly instanceof String) {
            return Boolean.valueOf((String)readonly);
        }
        return readonly.equals(Boolean.TRUE);
    }

    protected void renderAttributes(FacesContext context, UIComponent component, ResponseWriter writer) throws IOException {
    }

    protected void renderEnd(FacesContext context, UIComponent component, ResponseWriter writer) throws IOException {
    }

    protected void renderMarkup(FacesContext context, UIComponent component, ResponseWriter writer, Markup markup) throws IOException {
        writer.write(markup.getMarkup());
    }

    protected void renderStart(FacesContext context, UIComponent component, ResponseWriter writer) throws IOException {
    }

    protected void setSubmittedValue(FacesContext context, UIComponent component) {
        if (!(component instanceof EditableValueHolder)) {
            return;
        }
        component.getAttributes().put("submittedValue", this.getSubmittedValue(context, component));
    }
}

