/*
 * Decompiled with CFR 0.152.
 */
package com.sun.webui.jsf.renderkit.html;

import com.sun.webui.jsf.component.Alarm;
import com.sun.webui.jsf.component.ImageComponent;
import com.sun.webui.jsf.renderkit.html.ImageRenderer;
import com.sun.webui.jsf.util.ThemeUtilities;
import com.sun.webui.theme.Theme;
import java.io.IOException;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;

public class AlarmRenderer
extends ImageRenderer {
    private static final String LABEL_LEFT = "left";
    private static final String LABEL_RIGHT = "right";
    private static final String WHITE_SPACE = "&nbsp;";
    private static final String CRITICAL_ALT_TEXT_KEY = "Alarm.criticalImageAltText";
    private static final String MAJOR_ALT_TEXT_KEY = "Alarm.majorImageAltText";
    private static final String MINOR_ALT_TEXT_KEY = "Alarm.minorImageAltText";
    private static final String DOWN_ALT_TEXT_KEY = "Alarm.downImageAltText";

    protected void renderStart(FacesContext context, UIComponent component, ResponseWriter writer) throws IOException {
        boolean showImage;
        if (context == null || component == null) {
            throw new NullPointerException("FacesContext or UIComponent is null");
        }
        Alarm alarm = (Alarm)component;
        String label = alarm.getText();
        String severity = this.getSeverity(alarm);
        boolean severityOk = this.isSeverityOk(severity);
        boolean bl = showImage = !severityOk || alarm.getUrl() != null;
        if (showImage) {
            Theme theme = ThemeUtilities.getTheme(context);
            if (label == null) {
                this.renderImage(context, alarm, severity, writer);
            } else if (LABEL_LEFT.equalsIgnoreCase(alarm.getTextPosition())) {
                this.renderLabel(context, alarm, label, true, true, writer);
                this.renderImage(context, alarm, severity, writer);
            } else {
                this.renderImage(context, alarm, severity, writer);
                this.renderLabel(context, alarm, label, false, true, writer);
            }
        } else if (label != null) {
            this.renderLabel(context, alarm, label, false, false, writer);
        }
    }

    private void renderLabel(FacesContext context, Alarm alarm, String label, boolean labelLeft, boolean addSpace, ResponseWriter writer) throws IOException {
        if (labelLeft) {
            writer.writeText(label, null);
            if (addSpace) {
                writer.write(WHITE_SPACE);
            }
        } else {
            if (addSpace) {
                writer.write(WHITE_SPACE);
            }
            writer.writeText(label, null);
        }
    }

    private void renderImage(FacesContext context, Alarm alarm, String severity, ResponseWriter writer) throws IOException {
        super.renderStart(context, alarm, writer);
        ImageComponent sevImage = this.getImage(context, alarm, severity);
        super.renderAttributes(context, sevImage, writer);
        String[] integerAttributes = new String[]{"border", "hspace", "vspace"};
        this.addIntegerAttributes(context, alarm, writer, integerAttributes);
        String[] stringAttributes = new String[]{"align", "onClick", "onDblClick"};
        AlarmRenderer.addStringAttributes(context, alarm, writer, stringAttributes);
    }

    private ImageComponent getImage(FacesContext context, Alarm alarm, String severity) {
        String url;
        String toolTip;
        String alt;
        Theme theme = ThemeUtilities.getTheme(context);
        String sevIcon = null;
        String sevAlt = null;
        String sevToolTip = null;
        String sevUrl = null;
        if (severity.equalsIgnoreCase("critical")) {
            sevIcon = "ALARM_CRITICAL_MEDIUM";
            sevAlt = theme.getMessage(CRITICAL_ALT_TEXT_KEY);
            sevToolTip = theme.getMessage(CRITICAL_ALT_TEXT_KEY);
        } else if (severity.equalsIgnoreCase("major")) {
            sevIcon = "ALARM_MAJOR_MEDIUM";
            sevAlt = theme.getMessage(MAJOR_ALT_TEXT_KEY);
            sevToolTip = theme.getMessage(MAJOR_ALT_TEXT_KEY);
        } else if (severity.equalsIgnoreCase("minor")) {
            sevIcon = "ALARM_MINOR_MEDIUM";
            sevAlt = theme.getMessage(MINOR_ALT_TEXT_KEY);
            sevToolTip = theme.getMessage(MINOR_ALT_TEXT_KEY);
        } else if (severity.equalsIgnoreCase("down")) {
            sevIcon = "ALARM_DOWN_MEDIUM";
            sevAlt = theme.getMessage(DOWN_ALT_TEXT_KEY);
            sevToolTip = theme.getMessage(DOWN_ALT_TEXT_KEY);
        }
        String icon = alarm.getIcon();
        if (icon != null) {
            sevIcon = icon;
        }
        if ((alt = alarm.getAlt()) != null) {
            sevAlt = alt;
        }
        if ((toolTip = alarm.getToolTip()) != null) {
            sevToolTip = toolTip;
        }
        if ((url = alarm.getUrl()) != null) {
            sevUrl = url;
        }
        ImageComponent sevImage = new ImageComponent();
        sevImage.setIcon(sevIcon);
        sevImage.setUrl(url);
        sevImage.setAlt(sevAlt);
        sevImage.setToolTip(sevToolTip);
        int dim = alarm.getHeight();
        if (dim >= 0) {
            sevImage.setHeight(dim);
        }
        if ((dim = alarm.getWidth()) >= 0) {
            sevImage.setWidth(dim);
        }
        return sevImage;
    }

    protected void renderEnd(FacesContext context, UIComponent component, ResponseWriter writer) throws IOException {
        String severity = this.getSeverity((Alarm)component);
        boolean severityOk = this.isSeverityOk(severity);
        if (!severityOk || ((Alarm)component).getUrl() != null) {
            super.renderEnd(context, component, writer);
        }
    }

    protected void renderAttributes(FacesContext context, UIComponent component, ResponseWriter writer) throws IOException {
    }

    private String getSeverity(Alarm alarm) {
        String severity;
        block3: {
            block2: {
                severity = alarm.getSeverity();
                if (severity == null) break block2;
                if (severity.equals("critical")) break block3;
                if (severity.equals("down")) break block3;
                if (severity.equals("major")) break block3;
                if (severity.equals("minor")) break block3;
            }
            severity = "ok";
        }
        return severity.toLowerCase();
    }

    private boolean isSeverityOk(String severity) {
        return "ok".equalsIgnoreCase(severity);
    }
}

