/*
 * Decompiled with CFR 0.152.
 */
package com.sun.webui.jsf.renderkit.html;

import com.sun.webui.jsf.component.Breadcrumbs;
import com.sun.webui.jsf.component.Hyperlink;
import com.sun.webui.jsf.util.ConversionUtilities;
import com.sun.webui.jsf.util.RenderingUtilities;
import com.sun.webui.jsf.util.ThemeUtilities;
import com.sun.webui.theme.Theme;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import javax.faces.render.Renderer;

public class BreadcrumbsRenderer
extends Renderer {
    static final String SEPARATOR_KEY = "Breadcrumbs.separator";

    public boolean getRendersChildren() {
        return true;
    }

    public void encodeBegin(FacesContext context, UIComponent component) throws IOException {
        if (!component.isRendered()) {
            return;
        }
        Breadcrumbs breadcrumbs = (Breadcrumbs)component;
        ResponseWriter writer = context.getResponseWriter();
        writer.startElement("div", breadcrumbs);
        writer.writeAttribute("id", breadcrumbs.getClientId(context), "id");
        Theme theme = ThemeUtilities.getTheme(context);
        String styleClass = breadcrumbs.getStyleClass();
        if (!breadcrumbs.isVisible()) {
            String hiddenStyleClass = theme.getStyleClass("HIDDEN");
            styleClass = styleClass == null ? hiddenStyleClass : (styleClass.trim().endsWith(";") ? styleClass + " " + hiddenStyleClass : styleClass + "; " + hiddenStyleClass);
        }
        if (theme == null && styleClass != null) {
            writer.writeAttribute("class", styleClass, "class");
        } else {
            RenderingUtilities.renderStyleClass(context, writer, breadcrumbs, theme.getStyleClass("BREADCRUMB_WHITE_DIV"));
        }
        String style = breadcrumbs.getStyle();
        if (style != null) {
            writer.writeAttribute("style", style, "style");
        }
        writer.writeText("\n", null);
    }

    public void encodeChildren(FacesContext context, UIComponent component) throws IOException {
        Breadcrumbs breadcrumbs = (Breadcrumbs)component;
        if (!breadcrumbs.isRendered()) {
            return;
        }
        ResponseWriter writer = context.getResponseWriter();
        Theme theme = ThemeUtilities.getTheme(context);
        Hyperlink[] hyperlinks = breadcrumbs.getPages();
        if (hyperlinks != null && hyperlinks.length > 0) {
            int i;
            for (i = 0; i < hyperlinks.length - 1; ++i) {
                if (!hyperlinks[i].isRendered()) continue;
                UIComponent parent = hyperlinks[i].getParent();
                hyperlinks[i].setParent(breadcrumbs);
                BreadcrumbsRenderer.renderBreadcrumbsLink(context, hyperlinks[i], theme);
                hyperlinks[i].setParent(parent);
                if (i >= hyperlinks.length - 2 && !hyperlinks[i + 1].isRendered()) continue;
                this.renderBreadcrumbsSeparator(context, breadcrumbs, theme);
            }
            if (hyperlinks[i].isRendered()) {
                BreadcrumbsRenderer.renderBreadcrumbsText(context, hyperlinks[i], theme);
            }
        } else if (breadcrumbs.getChildCount() > 0) {
            int i;
            List<UIComponent> childrenList = breadcrumbs.getChildren();
            for (i = 0; i < childrenList.size() - 1; ++i) {
                Hyperlink hyperlink;
                if (!Hyperlink.class.isAssignableFrom(childrenList.get(i).getClass()) || !(hyperlink = (Hyperlink)childrenList.get(i)).isRendered()) continue;
                BreadcrumbsRenderer.renderBreadcrumbsLink(context, hyperlink, theme);
                if (i >= childrenList.size() - 2 && !childrenList.get(i + 1).isRendered()) continue;
                this.renderBreadcrumbsSeparator(context, breadcrumbs, theme);
            }
            if (childrenList.get(i).isRendered() && Hyperlink.class.isAssignableFrom(childrenList.get(i).getClass())) {
                BreadcrumbsRenderer.renderBreadcrumbsText(context, (Hyperlink)childrenList.get(i), theme);
            }
        }
    }

    public void encodeEnd(FacesContext context, UIComponent component) throws IOException {
        if (!component.isRendered()) {
            return;
        }
        ResponseWriter writer = context.getResponseWriter();
        writer.endElement("div");
        writer.writeText("\n", null);
    }

    private void renderBreadcrumbsSeparator(FacesContext context, Breadcrumbs breadcrumbs, Theme theme) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        writer.startElement("span", breadcrumbs);
        String separatorStyle = theme.getStyleClass("BREADCRUMB_SEPARATOR");
        writer.writeAttribute("class", separatorStyle, null);
        String separator = BreadcrumbsRenderer.escapeCharacterEntities(theme.getMessage(SEPARATOR_KEY));
        if (separator != null) {
            writer.write(separator);
        }
        writer.endElement("span");
    }

    private static void renderBreadcrumbsLink(FacesContext context, Hyperlink crumb, Theme theme) throws IOException {
        String linkStyle = theme.getStyleClass("BREADCRUMB_LINK");
        Map<String, Object> attributes = crumb.getAttributes();
        if (attributes != null && attributes.get("styleClass") == null) {
            attributes.put("styleClass", linkStyle);
        }
        RenderingUtilities.renderComponent(crumb, context);
    }

    private static void renderBreadcrumbsText(FacesContext context, Hyperlink hyperlink, Theme theme) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        String text = ConversionUtilities.convertValueToString(hyperlink, hyperlink.getText());
        if (text == null || text.length() <= 0) {
            return;
        }
        writer.startElement("span", hyperlink);
        String textStyle = theme.getStyleClass("BREADCRUMB_TEXT");
        writer.writeAttribute("class", textStyle, null);
        writer.writeText(text, null);
        writer.endElement("span");
    }

    private static String escapeCharacterEntities(String str) {
        StringBuffer buffer = new StringBuffer();
        block5: for (char c : str.toCharArray()) {
            switch (c) {
                case '<': {
                    buffer.append("&lt;");
                    continue block5;
                }
                case '>': {
                    buffer.append("&gt;");
                    continue block5;
                }
                case '&': {
                    buffer.append("&amp;");
                    continue block5;
                }
                default: {
                    buffer.append(c);
                }
            }
        }
        return buffer.toString();
    }
}

