/*
 * Decompiled with CFR 0.152.
 */
package com.sun.webui.jsf.renderkit.html;

import com.sun.webui.jsf.component.ComplexComponent;
import com.sun.webui.jsf.component.Field;
import com.sun.webui.jsf.component.HiddenField;
import com.sun.webui.jsf.util.ConversionUtilities;
import com.sun.webui.jsf.util.MessageUtil;
import java.io.IOException;
import java.util.Map;
import javax.faces.FacesException;
import javax.faces.component.EditableValueHolder;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import javax.faces.render.Renderer;

public class HiddenFieldRenderer
extends Renderer {
    private static final boolean DEBUG = false;

    public void encodeEnd(FacesContext context, UIComponent component) throws IOException {
        if (!(component instanceof HiddenField)) {
            Object[] params = new Object[]{component.toString(), this.getClass().getName(), HiddenField.class.getName()};
            String message = MessageUtil.getMessage("com.sun.webui.jsf.resources.LogMessages", "Renderer.component", params);
            throw new FacesException(message);
        }
        HiddenField field = (HiddenField)component;
        ResponseWriter writer = context.getResponseWriter();
        writer.startElement("input", field);
        writer.writeAttribute("type", "hidden", null);
        String id = field.getClientId(context);
        writer.writeAttribute("id", id, null);
        writer.writeAttribute("name", id, null);
        if (((HiddenField)component).getSubmittedValue() == null) {
            ConversionUtilities.setRenderedValue(component, ((HiddenField)component).getText());
        }
        String value = field.getValueAsString(context);
        writer.writeAttribute("value", value, "value");
        if (field.isDisabled()) {
            writer.writeAttribute("disabled", "disabled", null);
        }
        writer.endElement("input");
    }

    public void decode(FacesContext context, UIComponent component) {
        HiddenFieldRenderer.decodeInput(context, component);
    }

    static void decodeInput(FacesContext context, UIComponent component) {
        String id = component.getClientId(context);
        Map<String, String> params = context.getExternalContext().getRequestParameterMap();
        String valueObject = params.get(id);
        String value = null;
        if (valueObject == null && component instanceof Field) {
            id = component instanceof ComplexComponent ? ((Field)component).getLabeledElementId(context) : component.getClientId(context);
            valueObject = params.get(id);
        }
        if (valueObject != null) {
            value = valueObject;
            if (component instanceof Field && ((Field)component).isTrim()) {
                value = value.toString().trim();
            }
        }
        ((EditableValueHolder)((Object)component)).setSubmittedValue(value);
    }

    protected static void log(String s) {
        System.out.println(s);
    }
}

