/*
 * Decompiled with CFR 0.152.
 */
package com.sun.webui.jsf.renderkit.html;

import com.sun.webui.jsf.component.Property;
import com.sun.webui.jsf.util.RenderingUtilities;
import com.sun.webui.jsf.util.ThemeUtilities;
import com.sun.webui.theme.Theme;
import java.io.IOException;
import java.util.List;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import javax.faces.render.Renderer;

public class PropertyRenderer
extends Renderer {
    public boolean getRendersChildren() {
        return true;
    }

    public void encodeEnd(FacesContext context, UIComponent component) throws IOException {
        boolean overlapLabel;
        String labelAlign;
        if (context == null || component == null) {
            throw new NullPointerException();
        }
        if (!component.isRendered()) {
            return;
        }
        ResponseWriter writer = context.getResponseWriter();
        Property property = (Property)component;
        Theme theme = ThemeUtilities.getTheme(context);
        writer.startElement("tr", property);
        writer.writeAttribute("id", property.getClientId(context), null);
        String propValue = RenderingUtilities.getStyleClasses(context, component, null);
        if (propValue != null) {
            writer.writeAttribute("class", propValue, null);
        }
        if ((propValue = property.getStyle()) != null) {
            writer.writeAttribute("style", propValue, "style");
        }
        writer.startElement("td", property);
        writer.writeAttribute("valign", "top", null);
        boolean nowrap = property.isNoWrap();
        if (nowrap) {
            writer.writeAttribute("nowrap", "nowrap", null);
        }
        if ((labelAlign = property.getLabelAlign()) != null) {
            writer.writeAttribute("align", labelAlign, null);
        }
        if (overlapLabel = property.isOverlapLabel()) {
            writer.writeAttribute("colspan", "2", null);
        }
        writer.startElement("div", property);
        writer.writeAttribute("class", theme.getStyleClass("CONTENT_TABLE_COL1_DIV"), null);
        this.renderLabel(context, property, theme, writer);
        if (!overlapLabel) {
            writer.endElement("div");
            writer.endElement("td");
            writer.startElement("td", property);
            writer.startElement("div", property);
            writer.writeAttribute("class", theme.getStyleClass("CONTENT_TABLE_COL2_DIV"), null);
        }
        this.renderPropertyComponents(context, property, theme, writer);
        this.renderHelpText(context, property, theme, writer);
        writer.endElement("div");
        writer.endElement("td");
        writer.endElement("tr");
    }

    protected void renderPropertyComponents(FacesContext context, Property property, Theme theme, ResponseWriter writer) throws IOException {
        UIComponent content = property.getContentComponent();
        if (content != null) {
            RenderingUtilities.renderComponent(content, context);
            return;
        }
        List<UIComponent> children = property.getChildren();
        for (UIComponent child : children) {
            RenderingUtilities.renderComponent(child, context);
        }
    }

    protected void renderLabel(FacesContext context, Property property, Theme theme, ResponseWriter writer) throws IOException {
        UIComponent label = property.getLabelComponent();
        if (label != null) {
            RenderingUtilities.renderComponent(label, context);
            return;
        }
        writer.startElement("span", property);
        writer.writeAttribute("class", theme.getStyleClass("LABEL_LEVEL_TWO_TEXT"), null);
        writer.write("&nbsp;");
        writer.endElement("span");
    }

    protected void renderHelpText(FacesContext context, Property property, Theme theme, ResponseWriter writer) throws IOException {
        UIComponent helpText = property.getHelpTextComponent();
        if (helpText != null) {
            RenderingUtilities.renderComponent(helpText, context);
        }
    }

    public void encodeChildren(FacesContext context, UIComponent component) throws IOException {
        if (context == null || component == null) {
            throw new NullPointerException();
        }
    }
}

