/*
 * Decompiled with CFR 0.152.
 */
package com.sun.webui.jsf.renderkit.html;

import com.sun.webui.jsf.component.DropDown;
import com.sun.webui.jsf.component.Icon;
import com.sun.webui.jsf.component.Scheduler;
import com.sun.webui.jsf.component.Time;
import com.sun.webui.jsf.util.JSONUtilities;
import com.sun.webui.jsf.util.JavaScriptUtilities;
import com.sun.webui.jsf.util.MessageUtil;
import com.sun.webui.jsf.util.RenderingUtilities;
import com.sun.webui.jsf.util.ThemeUtilities;
import com.sun.webui.theme.Theme;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.MissingResourceException;
import javax.faces.FacesException;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import javax.faces.render.Renderer;
import org.json.JSONException;
import org.json.JSONObject;

public class SchedulerRenderer
extends Renderer {
    private static final String SPACE = "&nbsp;";
    private static final boolean DEBUG = false;

    public void encodeBegin(FacesContext context, UIComponent component) {
    }

    public boolean getRendersChildren() {
        return true;
    }

    public void encodeChildren(FacesContext context, UIComponent component) throws IOException {
    }

    public void encodeEnd(FacesContext context, UIComponent component) throws IOException {
        if (!(component instanceof Scheduler)) {
            Object[] params = new Object[]{component.toString(), this.getClass().getName(), Scheduler.class.getName()};
            String message = MessageUtil.getMessage("com.sun.webui.jsf.resources.LogMessages", "Renderer.component", params);
            throw new FacesException(message);
        }
        Scheduler scheduler = (Scheduler)component;
        Theme theme = ThemeUtilities.getTheme(context);
        ResponseWriter writer = context.getResponseWriter();
        String spacerPath = theme.getImagePath("DOT");
        this.renderEnclosingDiv(scheduler, theme, context, writer);
        writer.writeText("\n", null);
        this.renderOpenTable(scheduler, writer, null);
        writer.writeText("\n", null);
        writer.startElement("tr", scheduler);
        writer.writeText("\n", null);
        this.renderDatePicker(scheduler, theme, spacerPath, writer, context);
        this.renderInputControls(context, scheduler, writer, theme, spacerPath);
        writer.endElement("td");
        writer.writeText("\n", null);
        writer.endElement("tr");
        writer.writeText("\n", null);
        writer.endElement("table");
        writer.writeText("\n", null);
        writer.endElement("div");
        this.renderJavaScript(context, scheduler, writer, theme);
    }

    private void renderEnclosingDiv(Scheduler scheduler, Theme theme, FacesContext context, ResponseWriter writer) throws IOException {
        writer.startElement("div", scheduler);
        writer.writeAttribute("id", scheduler.getClientId(context), null);
        String style = scheduler.getStyle();
        if (style != null) {
            writer.writeAttribute("style", style, "style");
        }
        style = scheduler.getStyleClass();
        if (scheduler.isVisible()) {
            if (style != null) {
                writer.writeAttribute("class", style, "styleClass");
            }
        } else {
            style = style + " " + theme.getStyleClass("HIDDEN");
            writer.writeAttribute("class", style, "styleClass");
        }
    }

    private void renderOpenTable(UIComponent comp, ResponseWriter writer, String styleClass) throws IOException {
        writer.startElement("table", comp);
        if (styleClass != null) {
            writer.writeAttribute("class", styleClass, null);
        }
        writer.writeAttribute("border", "0", null);
        writer.writeAttribute("cellpadding", "0", null);
        writer.writeAttribute("cellspacing", "0", null);
        writer.writeAttribute("title", "", null);
    }

    private void renderLegendRow(Scheduler scheduler, Theme theme, ResponseWriter writer, FacesContext context, String spacerPath) throws IOException {
        writer.writeText("\n", null);
        writer.startElement("tr", scheduler);
        writer.writeText("\n", null);
        writer.startElement("td", scheduler);
        this.renderSpacerImage(scheduler, spacerPath, 1, 30, writer);
        writer.endElement("td");
        writer.writeText("\n", null);
        writer.startElement("td", scheduler);
        writer.writeAttribute("colspan", "3", null);
        writer.writeAttribute("height", "25", null);
        writer.writeAttribute("valign", "top", null);
        if (scheduler.isRequiredLegend()) {
            writer.writeText("\n", null);
            writer.startElement("div", scheduler);
            writer.writeAttribute("align", "left", null);
            writer.writeAttribute("class", theme.getStyleClass("LABEL_REQUIRED_DIV"), null);
            writer.writeText("\n", null);
            Icon icon = ThemeUtilities.getIcon(theme, "LABEL_REQUIRED_ICON");
            icon.setId(scheduler.getId().concat("_icon"));
            icon.setParent(scheduler);
            RenderingUtilities.renderComponent(icon, context);
            writer.writeText("\n", null);
            writer.write(SPACE);
            writer.writeText(theme.getMessage("Scheduler.requiredLegend"), null);
            writer.writeText("\n", null);
            writer.endElement("div");
        } else {
            writer.write(SPACE);
        }
        writer.endElement("td");
        writer.writeText("\n", null);
        writer.endElement("tr");
        writer.writeText("\n", null);
    }

    private void renderSpacerRow(UIComponent component, String path, int height, int width, int colspan, ResponseWriter writer) throws IOException {
        writer.startElement("tr", component);
        writer.writeText("\n", null);
        writer.startElement("td", component);
        writer.writeAttribute("colspan", String.valueOf(colspan), null);
        writer.writeText("\n", null);
        this.renderSpacerImage(component, path, height, width, writer);
        writer.endElement("td");
        writer.writeText("\n", null);
        writer.endElement("tr");
        writer.writeText("\n", null);
    }

    private void renderSpacerImage(UIComponent component, String path, int height, int width, ResponseWriter writer) throws IOException {
        writer.startElement("img", component);
        writer.writeAttribute("src", path, null);
        writer.writeAttribute("height", String.valueOf(height), null);
        writer.writeAttribute("width", String.valueOf(width), null);
        writer.writeAttribute("alt", "", null);
        writer.endElement("img");
    }

    private void renderDatePicker(Scheduler scheduler, Theme theme, String spacerPath, ResponseWriter writer, FacesContext context) throws IOException {
        writer.startElement("td", scheduler);
        writer.writeAttribute("valign", "top", null);
        writer.writeText("\n", null);
        RenderingUtilities.renderComponent(scheduler.getDatePicker(), context);
        writer.endElement("td");
        writer.writeText("\n", null);
    }

    private void renderInputControls(FacesContext context, Scheduler scheduler, ResponseWriter writer, Theme theme, String spacerPath) throws IOException {
        UIComponent label;
        writer.startElement("td", scheduler);
        writer.writeAttribute("valign", "top", null);
        writer.writeText("\n", null);
        String styleClass = theme.getStyleClass("DATE_TIME_FIELD_TABLE");
        this.renderOpenTable(scheduler, writer, styleClass);
        this.renderLegendRow(scheduler, theme, writer, context, spacerPath);
        this.renderStartDateRow(scheduler, spacerPath, theme, context, writer);
        if (scheduler.isStartTime()) {
            label = scheduler.getStartTimeLabelComponent(theme);
            this.renderTimeRow(scheduler, label, scheduler.getStartTimeComponent(), theme, spacerPath, context, writer);
        }
        if (scheduler.isEndTime()) {
            label = scheduler.getEndTimeLabelComponent(theme);
            this.renderTimeRow(scheduler, label, scheduler.getEndTimeComponent(), theme, spacerPath, context, writer);
        }
        if (scheduler.isRepeating()) {
            this.renderSpacerRow(scheduler, spacerPath, 5, 1, 4, writer);
            this.renderRepeatIntervalRow(scheduler, theme, context, writer);
            if (scheduler.isLimitRepeating()) {
                this.renderSpacerRow(scheduler, spacerPath, 5, 1, 4, writer);
                this.renderRepeatLimitRow(context, scheduler, writer, theme, spacerPath);
                this.renderRepeatLegend(scheduler, theme, context, writer);
            }
        }
        if (scheduler.isPreviewButton()) {
            this.renderSpacerRow(scheduler, spacerPath, 30, 1, 4, writer);
            this.renderPreviewRow(context, scheduler, writer, theme);
        }
        writer.writeText("\n", null);
        writer.endElement("table");
        writer.writeText("\n", null);
    }

    private void renderTimeRow(Scheduler scheduler, UIComponent label, Time time, Theme theme, String spacerPath, FacesContext context, ResponseWriter writer) throws IOException {
        this.renderSpacerRow(scheduler, spacerPath, 5, 1, 4, writer);
        writer.writeText("\n", null);
        this.renderInputRowStart(scheduler, writer, theme);
        RenderingUtilities.renderComponent(label, context);
        writer.writeText("\n", null);
        writer.endElement("span");
        writer.endElement("td");
        writer.writeText("\n", null);
        writer.startElement("td", scheduler);
        writer.write(SPACE);
        writer.endElement("td");
        writer.writeText("\n", null);
        writer.startElement("td", scheduler);
        writer.writeText("\n", null);
        RenderingUtilities.renderComponent(time, context);
        writer.endElement("td");
        writer.writeText("\n", null);
        writer.endElement("tr");
        writer.writeText("\n", null);
    }

    private void renderStartDateRow(Scheduler scheduler, String spacerPath, Theme theme, FacesContext context, ResponseWriter writer) throws IOException {
        UIComponent date = scheduler.getDateComponent();
        UIComponent label = scheduler.getDateLabelComponent(theme);
        writer.startElement("tr", scheduler);
        writer.writeText("\n", null);
        writer.startElement("td", scheduler);
        writer.writeText("\n", null);
        this.renderSpacerImage(scheduler, spacerPath, 1, 30, writer);
        writer.endElement("td");
        writer.writeText("\n", null);
        writer.startElement("td", scheduler);
        writer.writeAttribute("nowrap", "nowrap", null);
        writer.writeText("\n", null);
        RenderingUtilities.renderComponent(label, context);
        writer.endElement("td");
        writer.writeText("\n", null);
        writer.startElement("td", scheduler);
        writer.writeText("\n", null);
        this.renderSpacerImage(scheduler, spacerPath, 1, 10, writer);
        writer.endElement("td");
        writer.writeText("\n", null);
        writer.startElement("td", scheduler);
        writer.writeAttribute("nowrap", "nowrap", null);
        writer.writeText("\n", null);
        RenderingUtilities.renderComponent(date, context);
        writer.writeText("\n", null);
        writer.startElement("span", scheduler);
        String styleClass = theme.getStyleClass("HELP_FIELD_TEXT");
        writer.writeAttribute("class", styleClass, null);
        writer.write(SPACE);
        writer.write(SPACE);
        writer.writeText(this.getPattern(scheduler, theme), null);
        writer.endElement("span");
        writer.endElement("td");
        writer.writeText("\n", null);
        writer.endElement("tr");
        writer.writeText("\n", null);
    }

    private String getPattern(Scheduler scheduler, Theme theme) {
        String hint = scheduler.getDateFormatPatternHelp();
        if (hint == null) {
            try {
                String pattern = scheduler.getDatePicker().getDateFormatPattern();
                hint = theme.getMessage("calendar.".concat(pattern));
            }
            catch (MissingResourceException mre) {
                hint = ((SimpleDateFormat)scheduler.getDateFormat()).toLocalizedPattern().toLowerCase();
            }
        }
        return hint;
    }

    private void renderPreviewRow(FacesContext context, Scheduler scheduler, ResponseWriter writer, Theme theme) throws IOException {
        writer.startElement("tr", scheduler);
        writer.writeText("\n", null);
        writer.startElement("td", scheduler);
        writer.writeAttribute("colspan", "3", null);
        writer.write(SPACE);
        writer.endElement("td");
        writer.writeText("\n", null);
        writer.startElement("td", scheduler);
        UIComponent button = scheduler.getPreviewButtonComponent();
        RenderingUtilities.renderComponent(button, context);
        writer.endElement("td");
        writer.writeText("\n", null);
        writer.endElement("tr");
        writer.writeText("\n", null);
    }

    private void renderRepeatIntervalRow(Scheduler scheduler, Theme theme, FacesContext context, ResponseWriter writer) throws IOException {
        UIComponent label = scheduler.getRepeatIntervalLabelComponent();
        DropDown menu = scheduler.getRepeatIntervalComponent();
        this.renderInputRowStart(scheduler, writer, theme);
        RenderingUtilities.renderComponent(label, context);
        writer.writeText("\n", null);
        writer.endElement("span");
        writer.endElement("td");
        writer.writeText("\n", null);
        writer.startElement("td", scheduler);
        writer.write(SPACE);
        writer.endElement("td");
        writer.writeText("\n", null);
        writer.startElement("td", scheduler);
        writer.writeText("\n", null);
        RenderingUtilities.renderComponent(menu, context);
        writer.endElement("td");
        writer.writeText("\n", null);
        writer.endElement("tr");
        writer.writeText("\n", null);
    }

    private void renderInputRowStart(Scheduler scheduler, ResponseWriter writer, Theme theme) throws IOException {
        writer.startElement("tr", scheduler);
        writer.writeText("\n", null);
        writer.startElement("td", scheduler);
        writer.write(SPACE);
        writer.endElement("td");
        writer.writeText("\n", null);
        writer.startElement("td", scheduler);
        writer.writeAttribute("nowrap", "nowrap", null);
        writer.writeText("\n", null);
        writer.startElement("span", scheduler);
        String styleClass = theme.getStyleClass("DATE_TIME_LABEL_TEXT");
        writer.writeAttribute("class", styleClass, null);
        writer.writeText("\n", null);
    }

    private void renderRepeatLimitRow(FacesContext context, Scheduler scheduler, ResponseWriter writer, Theme theme, String spacerPath) throws IOException {
        UIComponent label = scheduler.getRepeatLimitLabelComponent();
        UIComponent field = scheduler.getRepeatingFieldComponent();
        DropDown menu = scheduler.getRepeatUnitComponent();
        this.renderInputRowStart(scheduler, writer, theme);
        RenderingUtilities.renderComponent(label, context);
        writer.endElement("span");
        writer.endElement("td");
        writer.writeText("\n", null);
        writer.startElement("td", scheduler);
        writer.write(SPACE);
        writer.endElement("td");
        writer.writeText("\n", null);
        writer.startElement("td", scheduler);
        RenderingUtilities.renderComponent(field, context);
        writer.writeText("\n", null);
        RenderingUtilities.renderComponent(menu, context);
        writer.endElement("td");
        writer.writeText("\n", null);
        writer.endElement("tr");
        writer.writeText("\n", null);
    }

    private void renderRepeatLegend(Scheduler scheduler, Theme theme, FacesContext context, ResponseWriter writer) throws IOException {
        this.renderInputRowStart(scheduler, writer, theme);
        writer.write(SPACE);
        writer.endElement("span");
        writer.endElement("td");
        writer.writeText("\n", null);
        writer.startElement("td", scheduler);
        writer.write(SPACE);
        writer.endElement("td");
        writer.write("\n");
        writer.startElement("td", scheduler);
        writer.writeAttribute("nowrap", "nowrap", null);
        writer.startElement("div", scheduler);
        writer.writeAttribute("class", theme.getStyleClass("HELP_FIELD_TEXT"), null);
        writer.writeText(theme.getMessage("Scheduler.blankForWhat"), null);
        writer.write("\n");
        writer.endElement("div");
        writer.endElement("td");
        writer.write("\n");
        writer.endElement("tr");
        writer.write("\n");
    }

    private void renderJavaScript(FacesContext context, Scheduler scheduler, ResponseWriter writer, Theme theme) throws IOException {
        try {
            StringBuffer buff = new StringBuffer(256);
            JSONObject json = new JSONObject();
            json.put("id", scheduler.getClientId(context)).put("datePickerId", scheduler.getDatePicker().getClientId(context)).put("dateFieldId", scheduler.getDateComponent().getClientId(context)).put("dateClass", theme.getStyleClass("DATE_TIME_LINK")).put("selectedClass", theme.getStyleClass("DATE_TIME_BOLD_LINK")).put("edgeClass", theme.getStyleClass("DATE_TIME_OTHER_LINK")).put("edgeSelectedClass", theme.getStyleClass("DATE_TIME_OTHER_BOLD_LINK")).put("todayClass", theme.getStyleClass("DATE_TIME_TODAY_LINK")).put("dateFormat", scheduler.getDatePicker().getDateFormatPattern());
            buff.append(JavaScriptUtilities.getModule("scheduler")).append("\n").append(JavaScriptUtilities.getModuleName("scheduler._init")).append("(").append(JSONUtilities.getString(json)).append(");");
            JavaScriptUtilities.renderJavaScript(scheduler, writer, buff.toString(), JavaScriptUtilities.isParseOnLoad());
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
    }

    public String toString() {
        return this.getClass().getName();
    }

    private void log(String s) {
        System.out.println(this.getClass().getName() + "::" + s);
    }
}

