/*
 * Decompiled with CFR 0.152.
 */
package com.sun.webui.jsf.renderkit.html;

import com.sun.webui.jsf.component.Table;
import com.sun.webui.jsf.component.TableActions;
import com.sun.webui.jsf.component.TableRowGroup;
import com.sun.webui.jsf.util.FocusManager;
import com.sun.webui.jsf.util.LogUtil;
import com.sun.webui.jsf.util.RenderingUtilities;
import com.sun.webui.jsf.util.ThemeUtilities;
import com.sun.webui.theme.Theme;
import java.io.IOException;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import javax.faces.render.Renderer;

public class TableActionsRenderer
extends Renderer {
    private static final String[] stringAttributes = new String[]{"abbr", "align", "axis", "bgColor", "char", "charOff", "dir", "headers", "height", "lang", "onClick", "onDblClick", "onKeyDown", "onKeyPress", "onKeyUp", "onMouseDown", "onMouseUp", "onMouseMove", "onMouseOut", "onMouseOver", "style", "valign", "width"};

    public void encodeBegin(FacesContext context, UIComponent component) throws IOException {
        if (context == null || component == null) {
            this.log("encodeBegin", "Cannot render, FacesContext or UIComponent is null");
            throw new NullPointerException();
        }
        if (!component.isRendered()) {
            this.log("encodeBegin", "Component not rendered, nothing to display");
            return;
        }
        TableActions action = (TableActions)component;
        ResponseWriter writer = context.getResponseWriter();
        this.renderEnclosingTagStart(context, action, writer);
    }

    public void encodeChildren(FacesContext context, UIComponent component) throws IOException {
        if (context == null || component == null) {
            this.log("encodeChildren", "Cannot render, FacesContext or UIComponent is null");
            throw new NullPointerException();
        }
        if (!component.isRendered()) {
            this.log("encodeChildren", "Component not rendered, nothing to display");
            return;
        }
        TableActions action = (TableActions)component;
        ResponseWriter writer = context.getResponseWriter();
        if (action.isActionsBottom()) {
            this.renderActionsBottom(context, action, writer);
        } else {
            this.renderActionsTop(context, action, writer);
        }
    }

    public void encodeEnd(FacesContext context, UIComponent component) throws IOException {
        if (context == null || component == null) {
            this.log("encodeEnd", "Cannot render, FacesContext or UIComponent is null");
            throw new NullPointerException();
        }
        if (!component.isRendered()) {
            this.log("encodeEnd", "Component not rendered, nothing to display");
            return;
        }
        TableActions action = (TableActions)component;
        ResponseWriter writer = context.getResponseWriter();
        this.renderEnclosingTagEnd(context, action, writer);
    }

    public boolean getRendersChildren() {
        return true;
    }

    protected void renderActionsTop(FacesContext context, TableActions component, ResponseWriter writer) throws IOException {
        boolean renderPaginateButton;
        Table table;
        Table table2 = table = component != null ? component.getTableAncestor() : null;
        if (table == null) {
            this.log("renderActionsTop", "Cannot render actions bar, Table is null");
            return;
        }
        int totalRows = table.getRowCount();
        boolean emptyTable = totalRows == 0;
        boolean singleRow = totalRows == 1;
        boolean singlePage = totalRows <= table.getRows();
        UIComponent actions = table.getFacet("actionsTop");
        UIComponent filter = table.getFacet("filter");
        UIComponent sort = table.getFacet("sortPanel");
        UIComponent prefs = table.getFacet("preferencesPanel");
        boolean renderActions = actions != null && actions.isRendered();
        boolean renderFilter = filter != null && filter.isRendered();
        boolean renderSort = sort != null && sort.isRendered();
        boolean renderPrefs = prefs != null && prefs.isRendered();
        boolean renderSelectMultipleButton = !emptyTable && table.isSelectMultipleButton();
        boolean renderDeselectMultipleButton = !emptyTable && table.isDeselectMultipleButton();
        boolean renderDeselectSingleButton = !emptyTable && table.isDeselectSingleButton();
        boolean renderClearTableSortButton = !emptyTable && !singleRow && table.isClearSortButton();
        boolean renderTableSortPanelToggleButton = !emptyTable && !singleRow && (table.isSortPanelToggleButton() || renderSort);
        boolean bl = renderPaginateButton = !emptyTable && !singlePage && table.isPaginateButton();
        if (!(renderActions || renderFilter || renderPrefs || renderSelectMultipleButton || renderDeselectMultipleButton || renderDeselectSingleButton || renderClearTableSortButton || renderTableSortPanelToggleButton || renderPaginateButton)) {
            this.log("renderActionsTop", "Actions bar not rendered, nothing to display");
            return;
        }
        if (renderSelectMultipleButton) {
            writer.writeText("\n", null);
            RenderingUtilities.renderComponent(component.getSelectMultipleButton(), context);
        }
        if (renderDeselectMultipleButton) {
            writer.writeText("\n", null);
            RenderingUtilities.renderComponent(component.getDeselectMultipleButton(), context);
        }
        if (renderDeselectSingleButton) {
            writer.writeText("\n", null);
            RenderingUtilities.renderComponent(component.getDeselectSingleButton(), context);
        }
        if (renderActions) {
            if (renderSelectMultipleButton || renderDeselectMultipleButton || renderDeselectSingleButton) {
                writer.writeText("\n", null);
                RenderingUtilities.renderComponent(component.getActionsSeparatorIcon(), context);
            }
            writer.writeText("\n", null);
            RenderingUtilities.renderComponent(actions, context);
        }
        if (renderFilter) {
            if (renderActions || renderSelectMultipleButton || renderDeselectMultipleButton || renderDeselectSingleButton) {
                writer.writeText("\n", null);
                RenderingUtilities.renderComponent(component.getFilterSeparatorIcon(), context);
            }
            writer.writeText("\n", null);
            RenderingUtilities.renderComponent(component.getFilterLabel(), context);
            writer.writeText("\n", null);
            RenderingUtilities.renderComponent(filter, context);
        }
        if ((renderActions || renderFilter || renderSelectMultipleButton || renderDeselectMultipleButton || renderDeselectSingleButton) && (renderPrefs || renderClearTableSortButton || renderTableSortPanelToggleButton)) {
            writer.writeText("\n", null);
            RenderingUtilities.renderComponent(component.getViewActionsSeparatorIcon(), context);
        }
        if (renderTableSortPanelToggleButton) {
            writer.writeText("\n", null);
            UIComponent child = component.getSortPanelToggleButton();
            RenderingUtilities.renderComponent(child, context);
        }
        if (renderClearTableSortButton) {
            writer.writeText("\n", null);
            RenderingUtilities.renderComponent(component.getClearSortButton(), context);
        }
        if (renderPrefs) {
            writer.writeText("\n", null);
            RenderingUtilities.renderComponent(component.getPreferencesPanelToggleButton(), context);
        }
        if (renderPaginateButton) {
            if (renderActions || renderFilter || renderPrefs || renderSelectMultipleButton || renderDeselectMultipleButton || renderDeselectSingleButton || renderClearTableSortButton || renderTableSortPanelToggleButton) {
                writer.writeText("\n", null);
                RenderingUtilities.renderComponent(component.getPaginateSeparatorIcon(), context);
            }
            writer.writeText("\n", null);
            RenderingUtilities.renderComponent(component.getPaginateButton(), context);
        }
    }

    protected void renderActionsBottom(FacesContext context, TableActions component, ResponseWriter writer) throws IOException {
        boolean renderPaginateButton;
        Table table;
        Table table2 = table = component != null ? component.getTableAncestor() : null;
        if (table == null) {
            this.log("renderActionsBottom", "Cannot render actions bar, Table is null");
            return;
        }
        int totalRows = table.getRowCount();
        boolean emptyTable = totalRows == 0;
        boolean singleRow = totalRows == 1;
        boolean singlePage = totalRows <= table.getRows();
        UIComponent actions = table.getFacet("actionsBottom");
        boolean renderActions = !emptyTable && !singleRow && actions != null && actions.isRendered();
        boolean renderPaginationControls = !emptyTable && !singlePage && table.isPaginationControls();
        boolean bl = renderPaginateButton = !emptyTable && !singlePage && table.isPaginateButton();
        if (renderActions) {
            writer.writeText("\n", null);
            RenderingUtilities.renderComponent(actions, context);
        }
        if ((renderPaginationControls || renderPaginateButton) && renderActions) {
            writer.writeText("\n", null);
            RenderingUtilities.renderComponent(component.getActionsSeparatorIcon(), context);
        }
        if (renderPaginationControls) {
            boolean paginated;
            TableRowGroup group = table.getTableRowGroupChild();
            boolean bl2 = paginated = group != null ? group.isPaginated() : false;
            if (paginated) {
                this.renderPagination(context, component, writer);
            }
        }
        if (renderPaginateButton) {
            writer.writeText("\n", null);
            RenderingUtilities.renderComponent(component.getPaginateButton(), context);
        }
    }

    protected void renderEnclosingTagStart(FacesContext context, TableActions component, ResponseWriter writer) throws IOException {
        if (component == null) {
            this.log("renderEnclosingTagStart", "Cannot render enclosing tag, TableActions is null");
            return;
        }
        writer.writeText("\n", null);
        writer.startElement("td", component);
        writer.writeAttribute("id", component.getClientId(context), null);
        String extraHtml = RenderingUtilities.renderStyleClass(context, writer, component, this.getStyleClass(component), component.getExtraHtml());
        if (component.getColSpan() > -1 && (extraHtml == null || extraHtml.indexOf("colspan=") == -1)) {
            writer.writeAttribute("colspan", Integer.toString(component.getColSpan()), null);
        }
        if (component.getRowSpan() > -1 && (extraHtml == null || extraHtml.indexOf("rowspan=") == -1)) {
            writer.writeAttribute("rowspan", Integer.toString(component.getRowSpan()), null);
        }
        if (component.isNoWrap() && (extraHtml == null || extraHtml.indexOf("nowrap=") == -1)) {
            writer.writeAttribute("nowrap", "nowrap", null);
        }
        if (component.getToolTip() != null && (extraHtml == null || extraHtml.indexOf("title=") == -1)) {
            writer.writeAttribute("title", component.getToolTip(), "toolTip");
        }
        RenderingUtilities.writeStringAttributes(component, writer, stringAttributes, extraHtml);
    }

    protected void renderEnclosingTagEnd(FacesContext context, TableActions component, ResponseWriter writer) throws IOException {
        if (component == null) {
            this.log("renderEnclosingTagEnd", "Cannot render enclosing tag, TableActions is null");
            return;
        }
        writer.endElement("td");
    }

    private String getStyleClass(TableActions component) {
        String styleClass = null;
        if (component == null) {
            this.log("getStyleClass", "Cannot obtain style class, TableActions is null");
            return styleClass;
        }
        styleClass = component.isActionsBottom() ? "TABLE_ACTION_TD_LASTROW" : "TABLE_ACTION_TD";
        return this.getTheme().getStyleClass(styleClass);
    }

    private Theme getTheme() {
        return ThemeUtilities.getTheme(FacesContext.getCurrentInstance());
    }

    private void log(String method, String message) {
        Class<?> clazz = this.getClass();
        if (LogUtil.fineEnabled(clazz)) {
            LogUtil.fine(clazz, clazz.getName() + "." + method + ": " + message);
        }
    }

    private void renderPagination(FacesContext context, TableActions component, ResponseWriter writer) throws IOException {
        if (component == null) {
            this.log("renderPagination", "Cannot render pagination controls, TableActions is null");
            return;
        }
        Theme theme = this.getTheme();
        UIComponent paginationControl = null;
        UIComponent paginationPageField = component.getPaginationPageField();
        writer.writeText("\n", null);
        writer.startElement("span", component);
        writer.writeAttribute("class", theme.getStyleClass("TABLE_PAGINATION_LEFT_BUTTON"), null);
        paginationControl = component.getPaginationFirstButton();
        this.setPaginationFocus(context, paginationControl, paginationPageField);
        writer.writeText("\n", null);
        RenderingUtilities.renderComponent(paginationControl, context);
        paginationControl = component.getPaginationPrevButton();
        this.setPaginationFocus(context, paginationControl, paginationPageField);
        writer.writeText("\n", null);
        RenderingUtilities.renderComponent(paginationControl, context);
        writer.endElement("span");
        writer.writeText("\n", null);
        writer.startElement("span", component);
        writer.writeAttribute("class", theme.getStyleClass("TABLE_PAGINATION_TEXT_BOLD"), null);
        writer.writeText("\n", null);
        RenderingUtilities.renderComponent(paginationPageField, context);
        writer.endElement("span");
        writer.writeText("\n", null);
        RenderingUtilities.renderComponent(component.getPaginationPagesText(), context);
        writer.writeText("\n", null);
        writer.startElement("span", component);
        writer.writeAttribute("class", theme.getStyleClass("TABLE_PAGINATION_SUBMIT_BUTTON"), null);
        writer.writeText("\n", null);
        RenderingUtilities.renderComponent(component.getPaginationSubmitButton(), context);
        writer.endElement("span");
        writer.writeText("\n", null);
        writer.startElement("span", component);
        writer.writeAttribute("class", theme.getStyleClass("TABLE_PAGINATION_RIGHT_BUTTON"), null);
        paginationControl = component.getPaginationNextButton();
        this.setPaginationFocus(context, paginationControl, paginationPageField);
        writer.writeText("\n", null);
        RenderingUtilities.renderComponent(paginationControl, context);
        paginationControl = component.getPaginationLastButton();
        this.setPaginationFocus(context, paginationControl, paginationPageField);
        writer.writeText("\n", null);
        RenderingUtilities.renderComponent(paginationControl, context);
        writer.endElement("span");
    }

    private void setPaginationFocus(FacesContext context, UIComponent paginationControl, UIComponent paginationPageField) {
        String focusId = FocusManager.getRequestFocusElementId(context);
        if (focusId == null || paginationControl == null || paginationPageField == null) {
            return;
        }
        Boolean disabled = (Boolean)paginationControl.getAttributes().get("disabled");
        if (disabled == null || disabled != null && !disabled.booleanValue()) {
            return;
        }
        String id = RenderingUtilities.getFocusElementId(context, paginationControl);
        if (!focusId.equals(id)) {
            return;
        }
        FocusManager.setRequestFocusElementId(context, RenderingUtilities.getFocusElementId(context, paginationPageField));
    }
}

