/*
 * Decompiled with CFR 0.152.
 */
package com.sun.webui.jsf.renderkit.widget;

import com.sun.webui.jsf.component.ComplexComponent;
import com.sun.webui.jsf.component.ListManager;
import com.sun.webui.jsf.component.ListSelector;
import com.sun.webui.jsf.model.Separator;
import com.sun.webui.jsf.model.list.EndGroup;
import com.sun.webui.jsf.model.list.ListItem;
import com.sun.webui.jsf.model.list.StartGroup;
import com.sun.webui.jsf.renderkit.widget.RendererBase;
import com.sun.webui.jsf.util.ConversionUtilities;
import com.sun.webui.jsf.util.LogUtil;
import com.sun.webui.jsf.util.WidgetUtilities;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Map;
import javax.faces.component.EditableValueHolder;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public abstract class ListRendererBase
extends RendererBase {
    protected static final String[] stringAttributes = new String[]{"onBlur", "onChange", "onClick", "onDblClick", "onFocus", "onMouseDown", "onMouseUp", "onMouseOver", "onMouseMove", "onMouseOut", "onKeyPress", "onKeyDown", "onKeyUp", "onSelect", "style", "dir", "lang", "accessKey"};

    public void decode(FacesContext context, UIComponent component) {
        if (((ListManager)((Object)component)).isReadOnly()) {
            return;
        }
        String id = component.getClientId(context);
        if (component instanceof ComplexComponent) {
            id = ((ComplexComponent)((Object)component)).getLabeledElementId(context);
        }
        this.decode(context, component, id);
    }

    protected void decode(FacesContext context, UIComponent component, String id) {
        ListManager lmComponent = (ListManager)((Object)component);
        if (lmComponent.isReadOnly()) {
            return;
        }
        Map<String, String[]> params = context.getExternalContext().getRequestParameterValuesMap();
        String[] values = null;
        String[] p = params.get(id);
        values = p == null ? new String[]{} : p;
        if (values.length > 1) {
            ArrayList<String> newParams = new ArrayList<String>();
            for (int i = 0; i < values.length; ++i) {
                if ("com_sun_webui_jsf_NONESELECTED".equals(values[i])) continue;
                newParams.add(values[i]);
            }
            values = newParams.toArray(new String[newParams.size()]);
        } else if (values.length == 1 && "com_sun_webui_jsf_NONESELECTED".equals(values[0])) {
            return;
        }
        if (values.length > 0 || !lmComponent.isDisabled()) {
            lmComponent.setSubmittedValue(values);
        }
    }

    protected JSONObject getProperties(FacesContext context, ListSelector component) throws JSONException, IOException {
        JSONObject json = new JSONObject();
        UIComponent label = component.getFacet("label");
        if (label != null) {
            json.put("label", WidgetUtilities.renderComponent(context, label));
        } else {
            String labelstring = component.getLabel();
            if (labelstring != null) {
                JSONObject labelobj = new JSONObject();
                labelobj.put("value", labelstring);
                labelobj.put("level", component.getLabelLevel());
                json.put("label", labelobj);
            }
        }
        json.put("className", component.getStyleClass());
        boolean labelOnTop = component.isLabelOnTop();
        json.put("labelOnTop", labelOnTop);
        this.recordRenderedValue(component);
        this.getListProperties(json, component, context);
        return json;
    }

    private void getListProperties(JSONObject json, ListManager listManager, FacesContext context) throws JSONException {
        boolean boolprop = listManager.isDisabled();
        if (boolprop) {
            json.put("disabled", boolprop);
        }
        boolprop = listManager.isRequired();
        json.put("required", boolprop);
        boolprop = listManager.isValid();
        json.put("valid", boolprop);
        json.put("size", listManager.getRows());
        String width = listManager.getWidth();
        if (width != null && width.trim().length() != 0) {
            json.put("width", width.trim());
        }
        json.put("multiple", listManager.isMultiple());
        int tabindex = listManager.getTabIndex();
        if (tabindex > 0 && tabindex < Short.MAX_VALUE) {
            json.put("tabIndex", tabindex);
        }
        json.put("title", listManager.getToolTip());
        this.getListOptionsProperties(json, (UIComponent)((Object)listManager), listManager.getListItems(context, true));
    }

    private void getListOptionsProperties(JSONObject json, UIComponent component, Iterator optionsIterator) throws JSONException {
        JSONObject separatorProps = this.getSeparatorProperties(component);
        JSONArray allOptionsArray = new JSONArray();
        json.put("options", allOptionsArray);
        JSONArray optionsArray = allOptionsArray;
        boolean addStartSeparator = false;
        while (optionsIterator.hasNext()) {
            Object option = optionsIterator.next();
            if (option instanceof ListItem) {
                JSONObject optionJson = new JSONObject();
                this.getListItemProperties(optionJson, (ListItem)option);
                optionsArray.put(optionJson);
                addStartSeparator = true;
                continue;
            }
            if (option instanceof StartGroup) {
                if (separatorProps != null && addStartSeparator) {
                    optionsArray.put(separatorProps);
                }
                StartGroup group = (StartGroup)option;
                JSONObject groupOptionJson = new JSONObject();
                groupOptionJson.put("group", true);
                groupOptionJson.put("label", group.getLabel());
                optionsArray.put(groupOptionJson);
                JSONArray groupOptionsJsonArray = new JSONArray();
                groupOptionJson.put("options", groupOptionsJsonArray);
                optionsArray = groupOptionsJsonArray;
                continue;
            }
            if (option instanceof EndGroup) {
                optionsArray = allOptionsArray;
                if (separatorProps == null || !optionsIterator.hasNext()) continue;
                optionsArray.put(separatorProps);
                addStartSeparator = false;
                continue;
            }
            if (!(option instanceof Separator) || separatorProps == null) continue;
            optionsArray.put(separatorProps);
        }
    }

    private JSONObject getSeparatorProperties(UIComponent component) throws JSONException {
        if (!(component instanceof ListSelector) || !((ListSelector)component).isSeparators()) {
            return null;
        }
        ListSelector selector = (ListSelector)component;
        JSONObject json = new JSONObject();
        json.put("separator", true);
        json.put("disabled", true);
        boolean escape = true;
        String separatorString = this.getMessage("ListSelector.optionSeparatorChar", null);
        if (separatorString != null) {
            String escapeSeparator = this.getMessage("ListSelector.optionSeparatorCharEscape", null);
            if (escapeSeparator != null) {
                escape = Boolean.valueOf(escapeSeparator);
            }
        } else {
            separatorString = "\u2014";
        }
        if (!escape) {
            json.put("escape", false);
        }
        int numEns = selector.getSeparatorLength();
        StringBuilder labelBuffer = new StringBuilder();
        for (int en = 0; en < numEns; ++en) {
            labelBuffer.append(separatorString);
        }
        json.put("label", labelBuffer.toString());
        return json;
    }

    private void getListItemProperties(JSONObject json, ListItem listItem) throws JSONException {
        String tmp;
        if (listItem.isDisabled()) {
            json.put("disabled", listItem.isDisabled());
        }
        if (listItem.isSelected()) {
            json.put("selected", listItem.isSelected());
        }
        json.put("value", listItem.getValue());
        String titleLabel = listItem.getLabel();
        boolean escapeTitle = true;
        if (listItem.isTitle() && titleLabel != null && (tmp = this.getMessage("ListSelector.titleOptionLabel", new Object[]{titleLabel})) != null) {
            titleLabel = tmp;
            escapeTitle = this.getTheme().getMessageBoolean("ListSelector.titleOptionLabelEscape", true);
        }
        if (!escapeTitle || !listItem.isEscape()) {
            json.put("escape", false);
        }
        if (titleLabel != null) {
            json.put("label", titleLabel);
        }
    }

    private void recordRenderedValue(UIComponent component) {
        if (component instanceof EditableValueHolder && ((EditableValueHolder)((Object)component)).getSubmittedValue() == null) {
            ConversionUtilities.setRenderedValue(component, ((EditableValueHolder)((Object)component)).getValue());
        }
    }

    private String getMessage(String key, Object[] params) {
        String msg;
        block2: {
            msg = null;
            try {
                msg = params != null ? this.getTheme().getMessage(key, params) : this.getTheme().getMessage(key);
            }
            catch (Exception e) {
                if (!LogUtil.finestEnabled()) break block2;
                LogUtil.finest("ListRendererBase.getMessage: Can't get message key" + key, e);
            }
        }
        return msg != null && msg.length() != 0 ? msg : null;
    }
}

