/*
 * Decompiled with CFR 0.152.
 */
package com.sun.webui.jsf.util;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.List;
import org.apache.commons.fileupload.FileUploadBase;

public class UploadFilterDeferredFileOutputStream
extends OutputStream {
    private static final long DEFAULT_MAX_FILE_SIZE = 1000000L;
    private static final int DEFAULT_THRESHOLD = 10240;
    private ByteArrayOutputStream memoryOutputStream;
    private FileOutputStream diskOutputStream;
    private OutputStream currentOutputStream;
    private File outputFile;
    private long maxFileSize = 1000000L;
    private List errorLog;
    private int threshold = 10240;
    private long written;
    private boolean thresholdExceeded;

    public UploadFilterDeferredFileOutputStream(int threshold, File outputFile, long maxFileSize, List errorLog) {
        this.threshold = threshold;
        this.outputFile = outputFile;
        this.maxFileSize = maxFileSize;
        this.errorLog = errorLog;
        this.memoryOutputStream = new ByteArrayOutputStream(threshold);
        this.currentOutputStream = this.memoryOutputStream;
    }

    public UploadFilterDeferredFileOutputStream() {
        this.currentOutputStream = new DevNullOutputStream();
    }

    public boolean isInMemory() {
        return !this.isThresholdExceeded();
    }

    public byte[] getData() {
        if (this.memoryOutputStream != null) {
            return this.memoryOutputStream.toByteArray();
        }
        return null;
    }

    public File getFile() {
        return this.outputFile;
    }

    public void write(int b) throws IOException {
        this.checkThreshold(1);
        try {
            this.currentOutputStream.write(b);
        }
        catch (Exception e) {
            this.logException(e);
        }
        ++this.written;
    }

    public void write(byte[] b) throws IOException {
        this.checkThreshold(b.length);
        try {
            this.currentOutputStream.write(b);
        }
        catch (Exception e) {
            this.logException(e);
        }
        this.written += (long)b.length;
    }

    public void write(byte[] b, int off, int len) throws IOException {
        this.checkThreshold(len);
        try {
            this.currentOutputStream.write(b, off, len);
        }
        catch (Exception e) {
            this.logException(e);
        }
        this.written += (long)len;
    }

    public void flush() throws IOException {
        try {
            this.currentOutputStream.flush();
        }
        catch (Exception e) {
            this.logException(e);
        }
    }

    public void close() throws IOException {
        try {
            this.currentOutputStream.flush();
            this.currentOutputStream.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public int getThreshold() {
        return this.threshold;
    }

    public long getByteCount() {
        return this.written;
    }

    public boolean isThresholdExceeded() {
        return this.written > (long)this.threshold;
    }

    private void checkThreshold(int count) {
        if (this.currentOutputStream instanceof DevNullOutputStream) {
            return;
        }
        long total = this.written + (long)count;
        if (this.maxFileSize > -1L && total > this.maxFileSize) {
            this.logException(new FileUploadBase.SizeLimitExceededException(Long.toString(this.maxFileSize)));
        } else if (!this.thresholdExceeded && total > (long)this.threshold) {
            this.thresholdExceeded = true;
            FileOutputStream fos = null;
            try {
                byte[] data = this.memoryOutputStream.toByteArray();
                fos = new FileOutputStream(this.outputFile);
                fos.write(data);
                this.diskOutputStream = fos;
                this.currentOutputStream = fos;
            }
            catch (Exception e) {
                try {
                    if (fos != null) {
                        fos.close();
                    }
                }
                catch (Exception e0) {
                    // empty catch block
                }
                this.diskOutputStream = null;
                this.logException(e);
            }
            this.memoryOutputStream = null;
        }
    }

    private void logException(Exception e) {
        try {
            this.close();
            this.outputFile.delete();
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.currentOutputStream = new DevNullOutputStream();
        if (this.errorLog != null) {
            this.errorLog.add(e);
        }
    }

    class DevNullOutputStream
    extends OutputStream {
        DevNullOutputStream() {
        }

        public void write(int b) throws IOException {
        }

        public void write(byte[] b) throws IOException {
        }

        public void write(byte[] b, int off, int len) throws IOException {
        }

        public void flush() throws IOException {
        }

        public void close() throws IOException {
        }
    }
}

