/*
 * Decompiled with CFR 0.152.
 */
package com.sun.webui.jsf.validator;

import javax.el.ELContext;
import javax.el.ELException;
import javax.el.MethodExpression;
import javax.faces.application.FacesMessage;
import javax.faces.component.StateHolder;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.validator.Validator;
import javax.faces.validator.ValidatorException;

public class MethodExprValidator
implements Validator,
StateHolder {
    private MethodExpression methodExpression = null;
    private boolean transientValue = false;

    public MethodExprValidator() {
    }

    public MethodExprValidator(MethodExpression methodExpression) {
        this.methodExpression = methodExpression;
    }

    public void validate(FacesContext context, UIComponent component, Object value) throws ValidatorException {
        if (context == null || component == null) {
            throw new NullPointerException();
        }
        if (value != null) {
            try {
                ELContext elContext = context.getELContext();
                this.methodExpression.invoke(elContext, new Object[]{context, component, value});
            }
            catch (ELException ee) {
                Throwable e = ee.getCause();
                if (e instanceof ValidatorException) {
                    throw (ValidatorException)e;
                }
                FacesMessage message = new FacesMessage(ee.getMessage());
                throw new ValidatorException(message, ee.getCause());
            }
        }
    }

    public Object saveState(FacesContext context) {
        Object[] values = new Object[]{this.methodExpression};
        return values;
    }

    public void restoreState(FacesContext context, Object state) {
        Object[] values = (Object[])state;
        this.methodExpression = (MethodExpression)values[0];
    }

    public boolean isTransient() {
        return this.transientValue;
    }

    public void setTransient(boolean transientValue) {
        this.transientValue = transientValue;
    }

    public MethodExpression getMethodExpression() {
        return this.methodExpression;
    }

    public boolean equals(Object otherObject) {
        if (!(otherObject instanceof MethodExprValidator)) {
            return false;
        }
        MethodExprValidator other = (MethodExprValidator)otherObject;
        MethodExpression otherMe = other.getMethodExpression();
        return this.methodExpression.equals(otherMe);
    }
}

