/*
 * Decompiled with CFR 0.152.
 */
package com.sun.webui.theme;

import java.util.ArrayList;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;

class ThemeResourceBundle {
    private static final String CANT_FIND_PROPERTY = "Can't find property";
    static final String VALUE_SEPARATOR = " ";

    ThemeResourceBundle() {
    }

    protected void getGlobalArrayProperty(String basename, ThemeBundle themeBundle, String key, Locale locale, ClassLoader classLoader, ArrayList properties) throws MissingResourceException {
        this.getGlobalArrayPropertyFromBundle(basename, key, locale, classLoader, properties);
        String[] basenames = null;
        try {
            basenames = (String[])this.getProperty(basename, themeBundle, locale, classLoader);
        }
        catch (MissingResourceException mre) {
            // empty catch block
        }
        if (basenames != null && basenames.length > 0) {
            for (String bname : basenames) {
                this.getGlobalArrayPropertyFromBundle(bname, key, locale, classLoader, properties);
            }
        } else if (properties.size() == 0) {
            throw new MissingResourceException(CANT_FIND_PROPERTY, basename, key);
        }
    }

    protected Object getProperty(String basename, ThemeBundle themeBundle, String key, Locale locale, ClassLoader classLoader) throws MissingResourceException {
        Object property = null;
        property = this.getPropertyFromBundle(basename, key, locale, classLoader, null);
        if (property != null) {
            return property;
        }
        String[] basenames = (String[])this.getProperty(basename, themeBundle, locale, classLoader);
        if (basenames == null || basenames.length == 0) {
            throw new MissingResourceException(CANT_FIND_PROPERTY, basename, key);
        }
        return this.getProperty(basenames, key, locale, classLoader);
    }

    protected Object[] getProperties(String basename, ThemeBundle themeBundle, String[] keys, Locale locale, ClassLoader classLoader) throws MissingResourceException {
        if (keys == null || keys.length == 0) {
            return null;
        }
        Object[] properties = null;
        MissingResourceException lastMre = null;
        try {
            properties = this.getPropertiesFromBundle(basename, keys, locale, classLoader);
        }
        catch (MissingResourceException mre) {
            lastMre = mre;
        }
        if (properties != null) {
            return properties;
        }
        String[] basenames = (String[])this.getProperty(basename, themeBundle, locale, classLoader);
        if (basenames == null || basenames.length == 0) {
            if (lastMre != null) {
                throw lastMre;
            }
            throw new MissingResourceException(CANT_FIND_PROPERTY, basename, "");
        }
        for (String bname : basenames) {
            try {
                properties = this.getPropertiesFromBundle(bname, keys, locale, classLoader);
            }
            catch (MissingResourceException mre) {
                lastMre = mre;
            }
        }
        if (properties == null) {
            if (lastMre != null) {
                throw lastMre;
            }
            throw new MissingResourceException(CANT_FIND_PROPERTY, basename, "");
        }
        return properties;
    }

    private Object getProperty(String basename, ThemeBundle themeBundle, Locale locale, ClassLoader classLoader) throws MissingResourceException {
        String basenames = (String)this.getPropertyFromBundle(basename, themeBundle.getKey(), locale, classLoader);
        if (basenames == null || basenames.trim().length() == 0) {
            throw new MissingResourceException(CANT_FIND_PROPERTY, basename, themeBundle.getKey());
        }
        return basenames.trim().split(VALUE_SEPARATOR);
    }

    private Object getProperty(String[] basenames, String key, Locale locale, ClassLoader classLoader) throws MissingResourceException {
        Object property = null;
        for (int i = 0; i < basenames.length && property == null; ++i) {
            try {
                property = this.getPropertyFromBundle(basenames[i], key, locale, classLoader);
                continue;
            }
            catch (MissingResourceException mre) {
                // empty catch block
            }
        }
        if (property == null) {
            throw new MissingResourceException(CANT_FIND_PROPERTY, basenames[0], key);
        }
        return property;
    }

    private void getGlobalArrayPropertyFromBundle(String basename, String key, Locale locale, ClassLoader classLoader, ArrayList properties) throws MissingResourceException {
        Object property = this.getArrayPropertyFromBundle(basename, key, locale, classLoader);
        if (property == null) {
            return;
        }
        if (property instanceof Object[]) {
            for (Object obj : (Object[])property) {
                properties.add(obj);
            }
        } else {
            properties.add(property);
        }
    }

    private Object getArrayPropertyFromBundle(String basename, String key, Locale locale, ClassLoader classLoader) throws MissingResourceException {
        Object property = this.getPropertyFromBundle(basename, key, locale, classLoader, null);
        if (property != null && property instanceof String) {
            String value = ((String)property).trim();
            property = value.length() > 0 ? value.split(VALUE_SEPARATOR) : null;
        }
        return property;
    }

    private Object getPropertyFromBundle(String basename, String key, Locale locale, ClassLoader classLoader, String defaultValue) throws MissingResourceException {
        Object property;
        block2: {
            ResourceBundle bundle = null;
            property = defaultValue;
            try {
                bundle = this.getResourceBundle(basename, locale, classLoader);
                property = bundle.getObject(key);
            }
            catch (MissingResourceException mre) {
                if (bundle != null) break block2;
                throw mre;
            }
        }
        return property;
    }

    private Object getPropertyFromBundle(String basename, String key, Locale locale, ClassLoader classLoader) throws MissingResourceException {
        ResourceBundle bundle = this.getResourceBundle(basename, locale, classLoader);
        return bundle.getObject(key);
    }

    private Object[] getPropertiesFromBundle(String basename, String[] keys, Locale locale, ClassLoader classLoader) throws MissingResourceException {
        ResourceBundle bundle = null;
        bundle = this.getResourceBundle(basename, locale, classLoader);
        int failures = 0;
        String badkey = null;
        Object[] properties = new Object[keys.length];
        for (int i = 0; i < keys.length; ++i) {
            try {
                properties[i] = bundle.getObject(keys[i]);
                continue;
            }
            catch (Exception e) {
                ++failures;
                if (badkey == null) continue;
                badkey = keys[i];
            }
        }
        if (failures == keys.length) {
            throw new MissingResourceException(CANT_FIND_PROPERTY, basename, badkey);
        }
        return properties;
    }

    private ResourceBundle getResourceBundle(String basename, Locale locale, ClassLoader classLoader) throws MissingResourceException {
        if (locale != null) {
            if (classLoader != null) {
                return ResourceBundle.getBundle(basename, locale, classLoader);
            }
            return ResourceBundle.getBundle(basename, locale);
        }
        return ResourceBundle.getBundle(basename);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static enum ThemeResource {
        THEME_PROPERTIES(ThemeProperty.values()),
        THEME_BUNDLES(ThemeBundle.values());

        private ThemeProperty[] properties;
        private ThemeBundle[] bundles;

        private ThemeResource(ThemeProperty[] properties) {
            this.properties = properties;
        }

        private ThemeResource(ThemeBundle[] bundles) {
            this.bundles = bundles;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static enum ThemeBundle {
        STYLESHEET(ThemeProperty.STYLESHEET_BUNDLE),
        CLASSMAPPER(ThemeProperty.STYLESHEET_CLASSMAPPER),
        JAVASCRIPT(ThemeProperty.JAVASCRIPT_BUNDLE),
        MESSAGES(ThemeProperty.MESSAGES_BUNDLE),
        TEMPLATE(ThemeProperty.TEMPLATE_BUNDLE),
        PROPERTIES(ThemeProperty.PROPERTIES_BUNDLE),
        IMAGES(ThemeProperty.IMAGES_BUNDLE);

        private final ThemeProperty property;

        private ThemeBundle(ThemeProperty property) {
            this.property = property;
        }

        public String getKey() {
            return this.property.getKey();
        }

        public ThemeProperty getProperty() {
            return this.property;
        }

        public static ThemeBundle toThemeBundle(String key) {
            for (ThemeBundle b : ThemeBundle.values()) {
                if (!b.property.getKey().equals(key)) continue;
                return b;
            }
            return null;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static enum ThemeProperty {
        NAME("Theme.name"),
        VERSION("Theme.version"),
        STYLESHEET_MASTER("master", true),
        STYLESHEET("Theme.stylesheet", true),
        STYLESHEET_BUNDLE("Theme.bundle.stylesheet"),
        STYLESHEET_CLASSMAPPER("Theme.bundle.stylesheet.classMapper"),
        JAVASCRIPT("Theme.javascript", true),
        JAVASCRIPT_BUNDLE("Theme.bundle.javascript"),
        TEMPLATE_BUNDLE("Theme.bundle.template"),
        MESSAGES_BUNDLE("Theme.bundle.messages"),
        PROPERTIES_BUNDLE("Theme.bundle.properties"),
        IMAGES_BUNDLE("Theme.bundle.images", false);

        private final String key;
        private final boolean multiValue;

        private ThemeProperty(String key, boolean multiValue) {
            this.key = key;
            this.multiValue = multiValue;
        }

        private ThemeProperty(String key) {
            this(key, false);
        }

        public static ThemeProperty toThemeProperty(String key) {
            for (ThemeProperty p : ThemeProperty.values()) {
                if (!p.getKey().equals(key)) continue;
                return p;
            }
            return null;
        }

        public String getKey() {
            return this.key;
        }

        public boolean isMultiValue() {
            return this.multiValue;
        }
    }
}

